/***************************************************************************
                              kssheetdlgs.h
                             -------------------
    begin                : 
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSSHEETDLGS_H
#define KSSHEETDLGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include "kssheetdlgcoldatainterf.h"
#include "kssheetdlgcellrangeinterf.h"
#include "kssheetdlgvaluerangeinterf.h"
#include "kssheetdlgsequenceinterf.h"
#include "../ksglobalmatrixlist.h"

class QWidget;
class KSWorkbook;

//--------------------------------------------------------------------------------------------------//

class KSSheetDlgCellRange : public KSSheetDlgCellRangeInterf
 {
  Q_OBJECT
  public:
	KSSheetDlgCellRange( QWidget *parent );
	virtual ~KSSheetDlgCellRange();
 };

//--------------------------------------------------------------------------------------------------//

class KSSheetDlgValueRange : public KSSheetDlgValueRangeInterf
 {
  Q_OBJECT
  public:
	KSSheetDlgValueRange( QWidget *parent );
	virtual ~KSSheetDlgValueRange();
	void setText( const QString& text );
	void setMinValue( double value );
	void setMaxValue( double value );
	double minValue() const;
	double maxValue() const;
 };

//--------------------------------------------------------------------------------------------------//

class KSSheetDlgSequence : public KSSheetDlgSequenceInterf
 {
  Q_OBJECT
  public:
	KSSheetDlgSequence( QWidget *parent );
	virtual ~KSSheetDlgSequence();
	double from() const;
	double to() const;
	bool useStep() const;
	bool reversedDirection() const;
 };

//--------------------------------------------------------------------------------------------------//

class KSSheetDlgColData : public KSSheetDlgColDataInterf {
   Q_OBJECT
   public:
	KSSheetDlgColData( QWidget *parent, KSSheet *matrix, int columnFrom, int columnStep, int columnTo );
	virtual ~KSSheetDlgColData();
	KSSheet::ColumnType columnType() const;
	QString columnTitle() const;
	void apply();
   protected:
	KSSheet *m_global_matrix;
	int m_column_from;
	int m_column_step;
	int m_column_to;
  };

#endif
