/***************************************************************************
                                  kmatplotshell.cpp
                             -------------------
    begin                : Sat Mar 11 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmatplotshell.h"

#include "kscommands.h"
#include "kssocketio.h"
#include "ksglobalmatrixlist.h"
#include "ksprojectxml.h"
#include "ksglobalsettings.h"
#include "ksworkbook.h"
#include "ksworkspace.h"
#include "kswinpageview.h"
#include "kswinworksheet.h"
#include "dialogs/ksconfiguredlg.h"
#include "widgets/qsplotview.h"

#include <qevent.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qpaintdevicemetrics.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qdockwindow.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qworkspace.h>

// icons
#include"pixmaps/action_open.xpm"
#include"pixmaps/action_save.xpm"
#include"pixmaps/action_print.xpm"
#include"pixmaps/action_exit.xpm"

#include"pixmaps/action_undo.xpm"
#include"pixmaps/action_redo.xpm"
#include"pixmaps/action_cut.xpm"
#include"pixmaps/action_copy.xpm"
#include"pixmaps/action_paste.xpm"
#include"pixmaps/action_delete.xpm"

#include"pixmaps/action_wizard.xpm"
#include"pixmaps/action_curve.xpm"
#include"pixmaps/action_contour.xpm"
#include"pixmaps/action_pixmap.xpm"
#include"pixmaps/action_surface.xpm"
#include"pixmaps/action_figure.xpm"

#include"pixmaps/panel_x.xpm"
#include"pixmaps/panel_y.xpm"
#include"pixmaps/panel_z.xpm"
#include"pixmaps/panel_v.xpm"

#include"pixmaps/action_exportpicture.xpm"

#include"pixmaps/action_toback.xpm"
#include"pixmaps/action_tofront.xpm"
#include"pixmaps/action_raise.xpm"
#include"pixmaps/action_lower.xpm"

#include"pixmaps/action_arrow.xpm"
#include"pixmaps/action_label.xpm"
#include"pixmaps/action_fullpage.xpm"
#include"pixmaps/action_locate.xpm"
#include"pixmaps/action_properties.xpm"
#include"pixmaps/action_rectangle.xpm"
#include"pixmaps/action_select.xpm"
#include"pixmaps/action_zoom.xpm"
#include"pixmaps/action_worksheet.xpm"
#include"pixmaps/action_green.xpm"
#include"pixmaps/action_gray.xpm"
#include"pixmaps/action_red.xpm"

// see main.cpp
extern KSSocketIO *kmatplot_socket;

//-----------------------------------------------------------------------------//

KMatplotShell::KMatplotShell( const char * )
: QMainWindow()
 {
  setCaption(tr(" KMatplot "));
  resize( 710, 690 );
  m_curr_data_object = NULL;
  m_workspace = new KSWorkspace( this );
  setCentralWidget( m_workspace );

  m_workbook = new KSWorkbook( this );
  m_workbook->clear();
  m_workbook->pageAdd( new QSPage(m_workbook) );
  connect( m_workbook->commandHistory(), SIGNAL(sigNewUndo()), this, SLOT(slot_new_undo()) );
  connect( m_workbook->commandHistory(), SIGNAL(sigNewRedo()), this, SLOT(slot_new_redo()) );
  connect( m_workbook->commandHistory(), SIGNAL(sigError(const QString&)), this, SLOT(slot_show_error(const QString&)) );
  connect( m_workbook, SIGNAL(sigWorkbookChanged()), this, SLOT(slot_set_dirty()) );
  m_modified = false;

  create_actions();
  create_dock_areas();
  // QPrinter::HighResolution has problems with fonts
  m_printer = new QPrinter( );
  m_printer->setFullPage(true);
  m_workbook->setPrinter( m_printer );

  if ( kmatplot_socket ) kmatplot_socket->setShell( this );

  m_show_full_page->setOn( true );
  m_zoom_75->setOn( TRUE );

  slot_new_undo();
  slot_new_redo();
  slot_dock_visiblity_changed( TRUE );

  connect( m_side_dock, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );
  connect( m_help_dock, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );
  connect( m_bottom_dock, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );

  connect( m_file_toolbar, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );
  connect( m_edit_toolbar, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );
  connect( m_view_toolbar, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );
  connect( m_tool_toolbar, SIGNAL(visibilityChanged(bool)), this, SLOT(slot_dock_visiblity_changed(bool)) );
  setUpLayout();
  show();
  KSWinPageView *window = new KSWinPageView( m_workspace );
  window->view()->setWorkbook( m_workbook );
  //window->hide();
  window->showMaximized();
  window->setFocus();
  //window->resize( m_workspace->size() );
  //new QWidget( m_workspace );
  //slotNewPageViewWin();
  m_modified = false;
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::create_actions()
 {
  // FILE
  m_new = new QAction( tr("New"), tr("&New"), 0, this, "new_file" );
  connect( m_new, SIGNAL(activated()), this, SLOT(slotNew()) );
  m_open = new QAction( tr("Open"), QPixmap(action_open), tr("&Open file ..."), CTRL+Key_O, this, "open_file" );
  connect( m_open, SIGNAL(activated()), this, SLOT(slotOpen()) );
  m_merge = new QAction( tr("Merge"), tr("&Merge ..."), 0, this, "merge_file" );
  connect( m_merge, SIGNAL(activated()), this, SLOT(slotMerge()) );
  m_save_as = new QAction( tr("Save as"), tr("Save &as ..."), 0, this, "save_as" );
  connect( m_save_as, SIGNAL(activated()), this, SLOT(slotSaveAs()) );
  m_save = new QAction( tr("Save"), QPixmap(action_save), tr("&Save"), CTRL+Key_S, this, "save" );
  connect( m_save, SIGNAL(activated()), this, SLOT(slotSave()) );

  m_print = new QAction( tr("Print"), QPixmap(action_print), tr("&Print"), CTRL+Key_P, this, "print" );
  connect( m_print, SIGNAL(activated()), this, SLOT(slotPrint()) );
  m_printer_setup = new QAction( tr("Priner"), tr("Printer Setup..."), 0, this, "printer_setup" );
  connect( m_printer_setup, SIGNAL(activated()), this, SLOT(slotPrinterSetup()) );

  m_exit = new QAction( tr("Exit"), QPixmap(action_exit), tr("&Exit"), CTRL+Key_X, this, "exit" );
  connect( m_exit, SIGNAL(activated()), this, SLOT(close()) );

  QPopupMenu *file = new QPopupMenu( this );
  menuBar()->insertItem( "&File", file );
  m_new->addTo( file );
  file->insertSeparator();
  m_open->addTo( file );
  m_merge->addTo( file );
  m_save_as->addTo( file );
  m_save->addTo( file );
  file->insertSeparator();
  m_print->addTo( file );
  m_printer_setup->addTo( file );
  //m_dpi->addTo( file );
  file->insertSeparator();
  m_exit->addTo( file );

  m_file_toolbar = new QToolBar(this,"file operations");
  m_file_toolbar->setLabel(tr("File Operations"));
  m_open->addTo( m_file_toolbar );
  m_save->addTo( m_file_toolbar );
  m_print->addTo( m_file_toolbar );

  //------------------------------------------------------------------------------------------//
  // EDIT
  m_undo = new QAction( tr("Undo"), QPixmap(action_undo), tr("&Undo"), CTRL+Key_Z, this, "undo" );
  connect( m_undo, SIGNAL(activated()), this, SLOT(slotUndo()) );
  m_redo = new QAction( tr("Redo"), QPixmap(action_redo), tr("&Redo"), CTRL+Key_Y, this, "redo" );
  connect( m_redo, SIGNAL(activated()), this, SLOT(slotRedo()) );
  m_copy = new QAction( tr("Copy"), QPixmap(action_copy), tr("&Copy"), CTRL+Key_C, this, "copy" );
  connect( m_copy, SIGNAL(activated()), this, SLOT(slotCopy()) );
  m_copy_all = new QAction( tr("Copy all"), tr("&Copy with data"), 0, this, "copy_all" );
  connect( m_copy_all, SIGNAL(activated()), this, SLOT(slotCopyAll()) );
  m_paste = new QAction( tr("Paste"), QPixmap(action_paste), tr("&Paste"), CTRL+Key_V, this, "paste" );
  connect( m_paste, SIGNAL(activated()), this, SLOT(slotPaste()) );
  m_cut = new QAction( tr("Cut"), QPixmap(action_cut), tr("C&ut"), CTRL+Key_X, this, "cut" );
  connect( m_cut, SIGNAL(activated()), this, SLOT(slotCut()) );
  m_delete = new QAction( tr("Delete"), QPixmap(action_delete), tr("&Delete"), 0, this, "delete" );
  connect( m_delete, SIGNAL(activated()), this, SLOT(slotDelete()) );

  // not visible
  m_object_menu = new KSSimpleAction( this, tr("Object"), tr("&Object menu"), 0, this, "object_menu" );

  QPopupMenu *edit = new QPopupMenu( this );
  menuBar()->insertItem( "&Edit", edit );
  m_undo->addTo( edit );
  m_redo->addTo( edit );
  edit->insertSeparator();
  m_cut->addTo( edit );
  m_copy->addTo( edit );
  m_copy_all->addTo( edit );
  m_paste->addTo( edit );
  m_delete->addTo( edit );

  m_edit_toolbar = new QToolBar(this,"edit operations");
  m_edit_toolbar->setLabel(tr("Edit Operations"));
  m_undo->addTo( m_edit_toolbar );
  m_cut->addTo( m_edit_toolbar );
  m_copy->addTo( m_edit_toolbar );
  m_paste->addTo( m_edit_toolbar );

  //-------------------------------------------------------------------------------------//
  // VIEW
  m_zoom = new QActionGroup( this, "page_zoom", TRUE );
  m_zoom->setUsesDropDown( TRUE );
  m_zoom->setMenuText( tr("Zoom") );
  m_zoom_50  = new QAction( tr("50%"), tr("50%"), 0, m_zoom, "zoom_50", TRUE );
  m_zoom_75  = new QAction( tr("75%"), tr("75%"), 0, m_zoom, "zoom_75", TRUE );
  m_zoom_100 = new QAction( tr("100%"), tr("100%"), 0, m_zoom, "zoom_100", TRUE );
  m_zoom_150 = new QAction( tr("150%"), tr("150%"), 0, m_zoom, "zoom_150", TRUE );
  m_zoom_200 = new QAction( tr("200%"), tr("200%"), 0, m_zoom, "zoom_200", TRUE );
  connect( m_zoom, SIGNAL(selected(QAction*)), this, SLOT(slotPageZoom(QAction*)) );

  m_show_full_page = new KSSimpleAction( this, tr("Page"), QPixmap(action_fullpage), tr("&Full page"), CTRL+Key_F, this, "full_page", TRUE  );
  m_grid = new KSSimpleAction( this, tr("Grid"), tr("Grid ..."), 0, this, "grid" );
  m_ioinfo = new KSSimpleAction( this, tr("I/O"), tr("&I/O info ..."), 0, this, "io_info" );

  m_toolbars = new QActionGroup( this, "toolbars", FALSE );
  m_toolbars->setUsesDropDown( TRUE );
  m_toolbars->setMenuText( tr("Toolbars") );
  m_show_side_dock = new QAction( tr("Objects"), tr("Show objects"), 0, m_toolbars, "side_dock", TRUE );
  m_show_help_dock = new QAction( tr("Messages"), tr("Show messages"), 0, m_toolbars, "help_dock", TRUE );
  m_show_bottom_dock = new QAction( tr("Properties/Output"), tr("Show properties/output"), 0, m_toolbars, "bottom_dock", TRUE );
  m_show_file_toolbar = new QAction( tr("File toolbar"), tr("Show file toolbar"), 0, m_toolbars, "file_toolbar", TRUE );
  m_show_edit_toolbar = new QAction( tr("Edit toolbar"), tr("Show edit toolbar"), 0, m_toolbars, "edit_toolbar", TRUE );
  m_show_view_toolbar = new QAction( tr("View toolbar"), tr("Show view toolbar"), 0, m_toolbars, "view_toolbar", TRUE );
  m_show_tool_toolbar = new QAction( tr("Tool toolbar"), tr("Show tool toolbar"), 0, m_toolbars, "tool_toolbar", TRUE );
  connect( m_show_side_dock, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );
  connect( m_show_help_dock, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );
  connect( m_show_bottom_dock, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );
  connect( m_show_file_toolbar, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );
  connect( m_show_edit_toolbar, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );
  connect( m_show_view_toolbar, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );
  connect( m_show_tool_toolbar, SIGNAL(activated()), this, SLOT(slot_show_toolbars()) );

  QPopupMenu *view = new QPopupMenu( this );
  menuBar()->insertItem( "&View", view );
  m_zoom->addTo( view );
  view->insertSeparator();
  m_show_full_page->addTo( view );
  view->insertSeparator();
  m_ioinfo->addTo( view );
  m_grid->addTo( view );
  view->insertSeparator();
  m_toolbars->addTo( view );

  m_view_toolbar = new QToolBar(this,"view operations");
  m_view_toolbar->setLabel(tr("View Operations"));
  m_show_full_page->addTo( m_view_toolbar );
  m_zoom->addTo( m_view_toolbar );

  //-----------------------------------------------------------------------------------------//
  // GRAPH
  m_wizard = new KSSimpleAction( this, tr("Wizard"), QPixmap(action_wizard), tr("&Wizard ..."), 0, this, "wizard" );
  m_new_axes2d = new KSSimpleAction( this, tr("XY axes"), tr("XY Axes"), 0, this, "new_axes2d" );
  m_new_axes3d = new KSSimpleAction( this, tr("XYZ Axes"), tr("XYZ Axes"), 0, this, "new_axes3d" );

  m_new_curve = new KSSimpleAction( this, tr("XY plot"), QPixmap(action_curve), tr("&XY plot"), 0, this, "new_curve" );
  m_new_image = new KSSimpleAction( this, tr("Pixmap"), QPixmap(action_pixmap),tr("&Pixmap"), 0, this, "new_pixmap" );
  m_new_contour = new KSSimpleAction( this, tr("Contour"), QPixmap(action_contour), tr("C&ontour"), 0, this, "new_contour" );
  m_new_ngcontour = new KSSimpleAction( this, tr("Non Gridded contour"), QPixmap(action_contour), tr("&Non Gridded contour"), 0, this, "new_non_gridded_contour" );
  m_new_surface   = new KSSimpleAction( this, tr("Surface"), QPixmap(action_surface), tr("&Surface"), 0, this, "new_surface" );
  m_new_figure    = new KSSimpleAction( this, tr("Figure"), QPixmap(action_figure), tr("&Figure"), 0, this, "new_figure" );

  m_new_xaxis  = new KSSimpleAction( this, tr("X"), QPixmap(panel_x), tr("&X axis"), 0, this,  "add_x_axis" );
  m_new_yaxis  = new KSSimpleAction( this, tr("Y"), QPixmap(panel_y), tr("&Y axis"), 0, this, "add_y_axis" );
  m_new_zaxis  = new KSSimpleAction( this, tr("Z"), QPixmap(panel_z), tr("&Z axis"), 0, this,"add_z_axis" );
  m_new_vaxis  = new KSSimpleAction( this, tr("V"), QPixmap(panel_v), tr("&V axis"), 0, this, "add_v_axis" );

  m_new_legend = new KSSimpleAction( this, tr("Legend"), tr("Legend"), 0, this, "new_legend" );

  m_cut_dataset = new KSSimpleAction( this, tr("Cut dataset"), tr("Cut dataset"), 0, this, "cut_dataset" );
  m_copy_dataset = new KSSimpleAction( this, tr("Copy dataset"), tr("Copy dataset"), 0, this, "copy_dataset" );
  m_copy_all_dataset = new KSSimpleAction( this, tr("Copy dataset with data"), tr("Copy dataset with data"), 0, this, "copy_all_dataset" );
  m_paste_dataset = new KSSimpleAction( this, tr("Paste dataset"), tr("Paste dataset"), 0, this, "paste_dataset" );
  m_delete_dataset = new KSSimpleAction( this, tr("Delete dataset"), tr("Delete dataset"), 0, this, "delete_dataset" );
  m_raise_dataset = new KSSimpleAction( this, tr("Raise dataset"), tr("Raise dataset"), 0, this, "raise_dataset" );
  m_lower_dataset = new KSSimpleAction( this, tr("Lower dataset"), tr("Lower dataset"), 0, this, "lower_dataset" );
  m_bring_dataset_to_front  = new KSSimpleAction( this, tr("Bring dataset to front"), tr("Bring dataset to front"), 0, this, "bring_dataset_to_front" );
  m_send_dataset_to_back = new KSSimpleAction( this, tr("Send dataset to back"), tr("Send dataset to back"), 0, this, "send_dataset_to_back" );

  m_datasets = new KSSimpleAction( this, tr("Datasets"), tr("Edit datasets ..."), 0, this, "edit_datasets" );


  QPopupMenu *graph = new QPopupMenu( this );

  menuBar()->insertItem( "&Graph", graph );
  m_wizard->addTo( graph );
  graph->insertSeparator();
  m_new_axes2d->addTo( graph );
  m_new_axes3d->addTo( graph );
  graph->insertSeparator();

  QPopupMenu *graph_insert = new QPopupMenu( graph );
  graph->insertItem( "&Insert", graph_insert );
  m_new_curve->addTo( graph_insert );
  m_new_image->addTo( graph_insert );
  m_new_contour->addTo( graph_insert );
  m_new_ngcontour->addTo( graph_insert );
  m_new_surface->addTo( graph_insert );
  m_new_figure->addTo( graph_insert );
  graph_insert->insertSeparator();
  m_new_xaxis->addTo( graph_insert );
  m_new_yaxis->addTo( graph_insert );
  m_new_zaxis->addTo( graph_insert );
  m_new_vaxis->addTo( graph_insert );
  graph_insert->insertSeparator();
  m_new_legend->addTo( graph_insert );

  QPopupMenu *graph_dataset = new QPopupMenu( graph );
  graph->insertItem( "&Current dataset", graph_dataset );
  m_cut_dataset->addTo( graph_dataset );
  m_copy_dataset->addTo( graph_dataset );
  m_copy_all_dataset->addTo( graph_dataset );
  m_paste_dataset->addTo( graph_dataset );
  m_delete_dataset->addTo( graph_dataset );
  graph_dataset->insertSeparator();
  m_raise_dataset->addTo( graph_dataset );
  m_lower_dataset->addTo( graph_dataset );
  graph_dataset->insertSeparator();
  m_bring_dataset_to_front->addTo( graph_dataset );
  m_send_dataset_to_back->addTo( graph_dataset );

  graph->insertSeparator();
  m_datasets->addTo( graph );

  //------------------------------------------------------------------------------------------//
  // WORKSHEET

  m_new_sheet = new KSSimpleAction( this, tr("Sheet"), tr("&New sheet"), 0, this, "new_sheet" );
  m_rename_sheet = new KSSimpleAction( this, tr("Rename sheet"), tr("&Rename sheet ..."), 0, this, "rename_sheet" );
  m_new_matrix = new KSSimpleAction( this, tr("Numerical"), tr("N&umerical matrix"), 0, this, "new_matrix" );
  m_new_string = new KSSimpleAction( this, tr("String"), tr("&String matrix"), 0, this, "new_string" );
  m_new_formula = new KSSimpleAction( this, tr("Formula"), tr("&Formula matrix"), 0, this, "new_formula" );
  m_new_reference = new KSSimpleAction( this, tr("Range"), tr("&Point to: sheet cell range"), 0, this, "new_reference" );

  m_import_octave = new KSSimpleAction( this, tr("Import"), tr("&Import Octave/MAT1.0 data ..."), 0, this, "import_data" );
  m_export_octave = new KSSimpleAction( this, tr("Export"), tr("&Export Octave ASCII data ..."), 0, this, "export_data" );
  m_detach = new KSSimpleAction( this, tr("Detach"), tr("&Detach"), 0, this, "detach" );
  m_transpose = new KSSimpleAction( this, tr("Transpose"), tr("&Transpose"), 0, this, "transpose" );

  m_cut_sheet = new KSSimpleAction( this, tr("Cut sheet"), tr("Cut sheet"), 0, this, "cut_sheet" );
  m_copy_sheet = new KSSimpleAction( this, tr("Copy sheet"), tr("Copy sheet"), 0, this, "copy_sheet" );
  m_copy_all_sheet = new KSSimpleAction( this, tr("Copy all sheet"), tr("Copy sheet with data"), 0, this, "copy_all_sheet" );
  m_paste_sheet = new KSSimpleAction( this, tr("Paste sheet"), tr("Paste sheet"), 0, this, "paste_sheet" );
  m_delete_sheet = new KSSimpleAction( this, tr("Delete sheet"), tr("Delete sheet"), 0, this, "delete_sheet" );

  QPopupMenu *worksheet = new QPopupMenu( this );
  menuBar()->insertItem( tr("&Worksheet"), worksheet );
  m_new_sheet->addTo( worksheet );
  m_rename_sheet->addTo( worksheet );
  QPopupMenu *new_matrix = new QPopupMenu( worksheet );
  worksheet->insertItem( tr("New matrix"), new_matrix );
  m_new_matrix->addTo( new_matrix );
  m_new_string->addTo( new_matrix );
  m_new_formula->addTo( new_matrix );
  m_new_reference->addTo( new_matrix );

  worksheet->insertSeparator();
  QPopupMenu *import_data = new QPopupMenu( worksheet );
  worksheet->insertItem( tr("Import data"), import_data );
  m_import_octave->addTo( import_data );
  QPopupMenu *export_data = new QPopupMenu( worksheet );
  worksheet->insertItem( tr("Export data"), export_data );
  m_export_octave->addTo( export_data );

  worksheet->insertSeparator();
  QPopupMenu *selected_sheet = new QPopupMenu( worksheet );
  worksheet->insertItem( tr("Selected sheet"), selected_sheet );
  m_cut_sheet->addTo( selected_sheet );
  m_copy_sheet->addTo( selected_sheet );
  m_copy_all_sheet->addTo( selected_sheet );
  m_paste_sheet ->addTo( selected_sheet );

  worksheet->insertSeparator();
  m_detach->addTo( worksheet );
  m_transpose->addTo( worksheet );
  worksheet->insertSeparator();
  m_delete_sheet->addTo( worksheet );

//------------------------------------------------------------------------------------------//
  // PAGE

  m_new_page = new QAction( tr("Page"), tr("New &page"), 0, this, "new_page" );
  connect( m_new_page, SIGNAL(activated()), this, SLOT(slotNewPage()) );
  m_rename_page = new KSSimpleAction( this, tr("Rename"), tr("&Rename ..."), 0, this, "rename_page" );
  m_delete_page = new KSSimpleAction( this, tr("Delete page"), tr("&Delete page"), 0, this, "delete_page" );
  m_page_to_front = new KSSimpleAction( this, tr("Page to front"), tr("Page to &front"), 0, this, "page_to_back" );
  m_page_to_back = new KSSimpleAction( this, tr("Page to back"), tr("Page to &back"), 0, this, "page_to_front" );

  m_raise_page = new KSSimpleAction( this, tr("Raise page"), tr("&Raise page"), 0, this, "raise_page" );
  m_lower_page = new KSSimpleAction( this, tr("Lower page"), tr("&Lower page"), 0, this, "lower_page" );

  m_export_picture = new KSSimpleAction( this, tr("Export picture"), QPixmap(action_exportpicture), tr("Export p&icture ..."), 0, this, "export_picture" );

  QPopupMenu *page = new QPopupMenu( this );
  menuBar()->insertItem( "&Page", page );

  m_new_page->addTo( page );
  page->insertSeparator();
  m_rename_page->addTo( page );
  m_delete_page->addTo( page );
  page->insertSeparator();
  m_page_to_front->addTo( page );
  m_page_to_back->addTo( page );
  page->insertSeparator();
  m_raise_page->addTo( page );
  m_lower_page->addTo( page );
  page->insertSeparator();
  m_export_picture->addTo( page );

  //------------------------------------------------------------------------------------------//
  // ARRANGE
  m_send_to_back   = new KSSimpleAction( this, tr("ToBack"), QPixmap(action_toback), tr("Send To Back"), 0, this, "send_to_back" );
  m_bring_to_front = new KSSimpleAction( this, tr("ToFront"), QPixmap(action_tofront), tr("Bring To Front"), 0, this, "bring_to_front" );
  m_raise = new KSSimpleAction( this, tr("Raise"), QPixmap(action_raise), tr("Raise"), 0, this, "raise" );
  m_lower = new KSSimpleAction( this, tr("Lower"), QPixmap(action_lower), tr("Lower"), 0, this, "lower" );
  m_group   = new KSSimpleAction( this, tr("Group"), tr("Group"), 0, this, "group" );
  m_ungroup = new KSSimpleAction( this, tr("Ungroup"), tr("Ungroup"), 0, this, "ungroup" );

  QPopupMenu *arrange = new QPopupMenu( this );
  menuBar()->insertItem( "&Arrange", arrange );
  m_group->addTo( arrange );
  m_ungroup->addTo( arrange );
  arrange->insertSeparator();
  m_raise->addTo( arrange );
  m_lower->addTo( arrange );
  arrange->insertSeparator();
  m_bring_to_front->addTo( arrange );
  m_send_to_back->addTo( arrange );

  //-------------------------------------------------------------------------------------------//
  // TOOLS
  //QString tool_group = "Tools";
  m_tools = new QActionGroup( this, "tools", TRUE );
  m_tool_select  = new QAction( tr("Select"), QPixmap(action_select), tr("Select"), 0, m_tools, "tool_select", TRUE );
  m_tool_label   = new QAction( tr("Label"), QPixmap(action_label), tr("Label"),  0, m_tools, "tool_label", TRUE );
  m_tool_arrow   = new QAction( tr("Arrow"), QPixmap(action_arrow), tr("Arrow"), 0, m_tools, "tool_arrow", TRUE );
  m_tool_rect    = new QAction( tr("Rect"), QPixmap(action_rectangle), tr("Rect"), 0, m_tools, "tool_rectangle", TRUE );
  m_tool_zoom  = new QAction( tr("Zoom"), QPixmap(action_zoom), tr("Zoom"),  0, m_tools, "tool_zoom", TRUE );
  m_tool_locate  = new QAction( tr("Locate"), QPixmap(action_locate), tr("Locate"), 0, m_tools, "tool_locate", TRUE );
  connect( m_tools, SIGNAL(selected(QAction*)), this, SLOT(slotTool(QAction*)) );

  QPopupMenu *tools = new QPopupMenu( this );
  menuBar()->insertItem( "&Tools", tools );
  m_tools->addTo( tools );

  m_tool_toolbar = new QToolBar(this,"tools");
  m_tool_toolbar->setLabel(tr("Tools"));
  m_tools->addTo( m_tool_toolbar );


  //--------------------------------------------------------------------------------------//
  // WINDOWS
  m_new_worksheet_win = new QAction( tr("Worksheet"), QPixmap(action_green), tr("Worksheets"), 0, this, "new_worksheet_window" );
  connect( m_new_worksheet_win, SIGNAL(activated()), this, SLOT(slotNewWorksheetWin()) );
  m_new_page_view_win = new QAction( tr("Page view"), QPixmap(action_red), tr("Page view"), 0, this, "new_page_view_window" );
  connect( m_new_page_view_win, SIGNAL(activated()), this, SLOT(slotNewPageViewWin()) );
  m_new_edit_data_win = new QAction( tr("Dataset"), QPixmap(action_gray), tr("Current dataset"), 0, this, "new_data_window" );
  connect( m_new_edit_data_win, SIGNAL(activated()), this, SLOT(slotNewEditDataWin()) );

  m_tile_windows = new QAction( tr("Tile"), tr("Tile"), 0, this, "tile_windows" );
  connect( m_tile_windows, SIGNAL(activated()), this, SLOT(slotTileWindows()) );
  m_cascade_windows = new QAction( tr("Cascade"), tr("Cascade"), 0, this, "cascade_windows" );
  connect( m_cascade_windows, SIGNAL(activated()), this, SLOT(slotCascadeWindows()) );

  m_maximize_windows = new QAction( tr("Maximize"), tr("Maximize"), 0, this, "maximize_windows" );
  connect( m_maximize_windows, SIGNAL(activated()), this, SLOT(slotMaximizeWindows()) );
  m_minimize_windows = new QAction( tr("Minimize"), tr("Minimize"), 0, this, "minimize_windows" );
  connect( m_minimize_windows, SIGNAL(activated()), this, SLOT(slotMinimizeWindows()) );
  m_close_window = new QAction( tr("Close"), tr("Close"), 0, this, "close_windows" );
  connect( m_close_window, SIGNAL(activated()), this, SLOT(slotCloseWindow()) );
  m_close_all_windows = new QAction( tr("Close all"), tr("Close all"), 0, this, "close_all_windows" );
  connect( m_close_all_windows, SIGNAL(activated()), this, SLOT(slotCloseAllWindows()) );

  m_restore_windows = new QAction( tr("Restore"), tr("Restore"), 0, this, "restore_windows" );
  connect( m_restore_windows, SIGNAL(activated()), this, SLOT(slotRestoreWindows()) );
  m_hide_window = new QAction( tr("Hide"), tr("Hide"), 0, this, "hide_window" );
  connect( m_hide_window, SIGNAL(activated()), this, SLOT(slotHideWindow()) );
  m_show_window = new QAction( tr("Show"), tr("Show"), 0, this, "show_window" );
  connect( m_show_window, SIGNAL(activated()), this, SLOT(slotShowWindow()) );

  QPopupMenu *windows = new QPopupMenu( this );
  menuBar()->insertItem( "&Windows", windows );
  QPopupMenu *new_window = new QPopupMenu( windows );
  windows->insertItem( tr("New window"), new_window );
  m_new_page_view_win->addTo( new_window );
  m_new_worksheet_win->addTo( new_window );
  m_new_edit_data_win->addTo( new_window );
  windows->insertSeparator();
  m_restore_windows->addTo( windows );
  m_maximize_windows->addTo( windows );
  m_minimize_windows->addTo( windows );
  windows->insertSeparator();
  m_hide_window->addTo( windows );
  m_show_window->addTo( windows );
  windows->insertSeparator();
  m_close_window->addTo( windows );
//  m_close_all_windows->addTo( windows );
  windows->insertSeparator();
  m_tile_windows->addTo( windows );
  m_cascade_windows->addTo( windows );

  //-----------------------------------------------------------------------------------------------//
  // SETTINGS actions
  m_hide_sliders = new KSSimpleAction( this, tr("Sliders"), tr("Hide S&liders"), 0, this, "hide_sliders", TRUE );
  m_apply_button = new KSSimpleAction( this, tr("Apply"), tr("Show &Apply button"), 0, this, "apply_properties", TRUE  );
  m_auto_apply = true;
  m_hide_rulers = new KSSimpleAction( this, tr("Rulers"), tr("Hide &Rulers"), 0, this, "hide_rulers", TRUE );
  m_x11_backstoring = new KSSimpleAction( this, tr("Backstoring"), tr("X11 backstoring"), 0, this, "x11_backstoring",TRUE );
  m_configure = new QAction( tr("Configure"), tr("&Configure KMatplot ..."), 0, this, "configure_kmatplot" );
  connect( m_configure, SIGNAL(activated()), this, SLOT(slotConfigure()) );

  QPopupMenu *settings = new QPopupMenu( this );
  menuBar()->insertItem( "&Settings", settings );
  m_apply_button->addTo( settings );
  m_x11_backstoring->addTo( settings );
  m_hide_rulers->addTo( settings );
  m_hide_sliders->addTo( settings );
  settings->insertSeparator();
  m_configure->addTo( settings );

  //-------------------------------------------------------------------------------------------//
  // HELP
  m_example_simple = new QAction( tr("Simple"), tr("Simple"), 0, this, "example_simple" );
  connect( m_example_simple, SIGNAL(activated()), this, SLOT(slotExampleSimple()) );
  m_example_contour = new QAction( tr("Contour"), tr("Contour"), 0, this, "example_contour" );
  connect( m_example_contour, SIGNAL(activated()), this, SLOT(slotExampleContour()) );
  m_example_3dpath = new QAction( tr("3D path"), tr("3D path"), 0, this, "example_3dpath" );
  connect( m_example_3dpath, SIGNAL(activated()), this, SLOT(slotExamplePath3d()) );
  m_example_surface = new QAction( tr("Surface"), tr("Surface"), 0, this, "example_surface" );
  connect( m_example_surface, SIGNAL(activated()), this, SLOT(slotExampleSurface()) );
  m_example_shell = new QAction( tr("Shell"), tr("Shell"), 0, this, "example_shell" );
  connect( m_example_shell, SIGNAL(activated()), this, SLOT(slotExampleShell()) );
  m_about = new QAction( tr("About"), tr("&About ..."), 0, this, "about" );
  connect( m_about, SIGNAL(activated()), this, SLOT(slotAbout()) );

  QPopupMenu *help = new QPopupMenu( this );
  menuBar()->insertSeparator();
  menuBar()->insertItem( "&Help", help );
  QPopupMenu *help_examples = new QPopupMenu( help );
  help->insertItem( "&Examples", help_examples );
  m_example_simple->addTo( help_examples );
  m_example_contour->addTo( help_examples );
  m_example_3dpath->addTo( help_examples );
  m_example_surface->addTo( help_examples );
  m_example_shell->addTo( help_examples );
  help->insertSeparator();
  m_about->addTo( help );


 }

//-----------------------------------------------------------------------------//

void KMatplotShell::create_dock_areas()
 {
  //------------------------------------------------------//
  // BOTTOM DOCK
  m_bottom_dock = new QDockWindow( QDockWindow::InDock, this );
  m_bottom_dock->setResizeEnabled(TRUE);
  m_bottom_dock->setFixedExtentWidth( 1 );
  m_bottom_dock->setFixedExtentHeight( 1 );
  m_bottom_dock->setCloseMode( QDockWindow::Always );
  moveDockWindow( m_bottom_dock, DockBottom );
  m_bottom_tab = new QTabWidget( m_bottom_dock );
  m_bottom_dock->setWidget( m_bottom_tab );

  // add property container
  m_property_container = new KSSimpleContainer( m_bottom_tab, 500, 135 );
  m_bottom_tab->addTab( m_property_container, tr("Properties") );

  // add console
  m_output_message = new QTextEdit(m_bottom_tab);
  m_output_message->setReadOnly( TRUE );
  m_output_message->setTextFormat( RichText );
  m_output_message->setUndoRedoEnabled( FALSE );
  m_output_message->setWordWrap( QTextEdit::NoWrap );
  m_bottom_tab->addTab( m_output_message, tr("Output") );
  m_console = new KSSimpleConsole( this );

  //-------------------------------------------------------//
  // SIDE DOCK
  m_side_dock = new QDockWindow( QDockWindow::InDock, this );
  m_side_dock->setResizeEnabled(TRUE);
  m_side_dock->setFixedExtentWidth( 1 );
  m_side_dock->setFixedExtentHeight( 1 );
  m_side_dock->setCloseMode( QDockWindow::Always );
  moveDockWindow( m_side_dock, DockLeft );
  m_side_tab = new QTabWidget( m_side_dock );
  m_side_dock->setWidget( m_side_tab );

  // add object container
  m_object_container = new KSSimpleContainer( m_side_tab, 200, 260 );
  m_side_tab->addTab( m_object_container, tr("Objects") );

  // add datasets
  //m_side_tab->addTab( new QWidget(m_side_tab), tr("Datasets") );

  //------------------------------------------------------//
  // HELP DOCK
  m_help_dock = new QDockWindow( QDockWindow::InDock, this );
  m_help_dock->setResizeEnabled(TRUE);
  m_help_dock->setCloseMode( QDockWindow::Always );
  moveDockWindow( m_help_dock, DockLeft );
  m_help_container = new KSSimpleContainer( m_help_dock, 200, 150 );
  m_help_dock->setWidget( m_help_container );

  m_help_message = new QLabel( m_help_container );
  m_help_message->setTextFormat( RichText );
  m_help_message->setAlignment( AlignAuto | AlignTop | ExpandTabs | WordBreak );
  m_help_message->setFont( QFont("Arial", 9) );
  m_help_message->setIndent( 5 );
  m_help_container->setWidget( m_help_message );

 }

//-----------------------------------------------------------------------------//

KMatplotShell::~KMatplotShell()
 {
  //if ( kmatplot_socket ) kmatplot_socket->unregisterPart( part_id );
  m_workbook->commandHistory()->clear();
  delete m_printer;
  delete m_console;
 }


//-----------------------------------------------------------------------------//

void KMatplotShell::slot_show_toolbars()
 {
  if ( m_show_file_toolbar->isOn() ) m_file_toolbar->show(); else m_file_toolbar->hide();
  if ( m_show_edit_toolbar->isOn() ) m_edit_toolbar->show(); else m_edit_toolbar->hide();
  if ( m_show_view_toolbar->isOn() ) m_view_toolbar->show(); else m_view_toolbar->hide();
  if ( m_show_tool_toolbar->isOn() ) m_tool_toolbar->show(); else m_tool_toolbar->hide();
  if ( m_show_bottom_dock->isOn() ) m_bottom_dock->show(); else m_bottom_dock->hide();
  if ( m_show_side_dock->isOn() ) m_side_dock->show(); else m_side_dock->hide();
  if ( m_show_help_dock->isOn() ) m_help_dock->show(); else m_help_dock->hide();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slot_dock_visiblity_changed( bool )
 {
  if ( m_file_toolbar->isVisible() ) m_show_file_toolbar->setOn( TRUE ); else m_show_file_toolbar->setOn( FALSE );
  if ( m_edit_toolbar->isVisible() ) m_show_edit_toolbar->setOn( TRUE ); else m_show_edit_toolbar->setOn( FALSE );
  if ( m_view_toolbar->isVisible() ) m_show_view_toolbar->setOn( TRUE ); else m_show_view_toolbar->setOn( FALSE );
  if ( m_tool_toolbar->isVisible() ) m_show_tool_toolbar->setOn( TRUE ); else m_show_tool_toolbar->setOn( FALSE );
  if ( m_bottom_dock->isVisible() ) m_show_bottom_dock->setOn( TRUE ); else m_show_bottom_dock->setOn( FALSE );
  if ( m_side_dock->isVisible() ) m_show_side_dock->setOn( TRUE ); else m_show_side_dock->setOn( FALSE );
  if ( m_help_dock->isVisible() ) m_show_help_dock->setOn( TRUE ); else m_show_help_dock->setOn( FALSE );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::doAction( QAction *action )
 {
  if ( m_workspace->activeWindow() ) m_workspace->activeWindow()->doAction( action );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotDataObjectSelected( QSData *data )
 {
  m_curr_data_object = data;
  if ( data ) m_new_edit_data_win->setEnabled( TRUE  );
	 else m_new_edit_data_win->setEnabled( FALSE );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotNewEditDataWin()
 {
  KSWinWorksheet *window = new KSWinWorksheet( m_workspace, false );
  window->resize( 200, 250 );
  window->setDataObject( m_curr_data_object );
  window->showMaximized();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotNewWorksheetWin()
 {
  KSWinWorksheet *window = new KSWinWorksheet( m_workspace, true );
  window->resize( 200, 250 );
  window->setDataObject( m_workbook->sheets() );
  window->showMaximized();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotNewPageViewWin()
 {
  KSWinPageView *window = new KSWinPageView( m_workspace );
  window->resize( 200, 250 );
  window->view()->setWorkbook( m_workbook );
  window->showMaximized();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotTileWindows()
 {
  m_workspace->workspace()->tile();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotCascadeWindows()
 {
  m_workspace->workspace()->cascade();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotMaximizeWindows()
 {
  if ( m_workspace->workspace()->activeWindow() )  m_workspace->workspace()->activeWindow()->showMaximized();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotRestoreWindows()
 {
  if ( m_workspace->workspace()->activeWindow() )  m_workspace->workspace()->activeWindow()->showNormal();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotMinimizeWindows()
 {
   if ( m_workspace->workspace()->activeWindow() ) m_workspace->workspace()->activeWindow()->showMinimized();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotHideWindow()
 {
   if ( m_workspace->workspace()->activeWindow() ) m_workspace->workspace()->activeWindow()->hide();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotShowWindow()
 {
   if ( m_workspace->workspace()->activeWindow() ) m_workspace->workspace()->activeWindow()->show();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotCloseWindow()
 {
  if ( m_workspace->workspace()->activeWindow() ) m_workspace->workspace()->activeWindow()->close();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotCloseAllWindows()
 {
  QWidgetList l = m_workspace->workspace()->windowList();

 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotShowHelpMessage( const QString& message )
 {
  m_help_message->setText( message );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotShowOutputMessage( const QString& message )
 {
  if ( m_output_message->paragraphs() > 200 ) {
	 int parags_to_remove = m_output_message->paragraphs()-200;
	 for( int i=0;i<parags_to_remove;i++) m_output_message->removeParagraph( 0 );
	}
  m_output_message->insertParagraph( "<p>"+message+"</p>", -1 );
 }


//-----------------------------------------------------------------------------//

void KMatplotShell::toggleToolBar()
{
  /*
  if (m_show_toolbar->isChecked())
    toolBar()->show();
    else
    toolBar()->hide();
  */
}

//-----------------------------------------------------------------------------//

bool KMatplotShell::openFile( const QString& filename )
 {
	clearAll();
  	bool result = mergeFile( filename );
  	if ( result ) {
		m_modified = false;
		m_curr_file = filename;
		setCaption(tr(" KMatplot - %1 ").arg(m_curr_file));
		}	
	return result;
 }

//-----------------------------------------------------------------------------//

bool KMatplotShell::mergeFile( const QString& filename )
 {
  QFile f( filename );
  KSProjectXML *xml = new KSProjectXML( this );
  bool result = xml->loadFromFile( f );
  delete xml;
  f.close();
  if ( result ) {
	m_modified = true;
	setCaption(tr(" KMatplot - %1 ").arg(m_curr_file));
	}
  return result;
 }

//-----------------------------------------------------------------------------//

bool KMatplotShell::saveFile( const QString& filename )
 {
  QFile f( filename );
  if ( !f.open( IO_WriteOnly ) ) return false;
  KSProjectXML *xml = new KSProjectXML( this );
  bool result = xml->saveToFile( f );
  delete xml;
  f.close();
  if ( result ) {
	m_modified = false;
	m_curr_file = filename;
	setCaption(tr(" KMatplot - %1 ").arg(m_curr_file));
	}
  return result;
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotNew()
 {
  if ( !m_modified || QMessageBox::warning( this,
	"Closing the current document",
	"The current document was modified. Close anyway ?",
        QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ) {
  	clearAll();
	m_workbook->pageAdd( new QSPage(m_workbook) );
	m_modified = false;
	}
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::clearAll()
 {
  	m_workbook->clear();
  	m_workbook->sheets()->clearAll();
	m_curr_file = QString::null;
	setCaption(tr(" KMatplot "));
 	m_modified = false;
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotOpen()
 {
  if ( !m_modified || QMessageBox::warning( this,
	"Closing the current document",
	"The current document was modified. Close anyway ?",
        QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ) {
  	QString filename = QFileDialog::getOpenFileName(
			m_open_path.isEmpty() ? QDir::homeDirPath() : m_open_path,
			tr("*.kmp|KMatplot files (*.kmp)"),
			this, "file_open", tr("Open File...") );
  	if ( !filename.isEmpty() )
		if ( openFile(filename) ) {
			m_open_path = filename;
			} else {
			QMessageBox::critical(NULL,tr("Error !"),tr("Can't open the file."));
			}
	}
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotMerge()
 {
  QString filename = QFileDialog::getOpenFileName(
			m_open_path.isEmpty() ? QDir::homeDirPath() : m_open_path,
			tr("*.kmp|KMatplot files (*.kmp)"),
			this, "file_merge", tr("Merge File...") );

  if ( !filename.isEmpty() )
	if ( mergeFile(filename) ) {
		m_open_path = filename;
		} else {
		QMessageBox::critical(NULL,tr("Error !"),tr("Can't open the file."));
		}
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotSaveAs()
 {
  QString filename = QFileDialog::getSaveFileName(
			m_save_path.isEmpty() ? QDir::currentDirPath() : m_save_path,
			tr("*.kmp|KMatplot files (*.kmp)"),
			this, "file_save",
			tr("Save file...") );
  if ( !filename.isEmpty() )
  	if ( saveFile(filename) ) {
		m_save_path = filename;
		} else {
		QMessageBox::critical(NULL,tr("Error !"),tr("Can't save the file."));
		}
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotSave()
 {
  if ( m_curr_file.isEmpty() ) slotSaveAs();
	else if ( !saveFile(m_curr_file) ) QMessageBox::critical(NULL,tr("Error !"),tr("Can't save the file."));
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::closeEvent( QCloseEvent* e )
 {
  if ( queryExit() ) e->accept(); else e->ignore();
 }

//-----------------------------------------------------------------------------//

bool KMatplotShell::queryExit()
 {
  if ( !m_modified || QMessageBox::warning( this,
	"Exit",
	"The current document was modified. Close anyway ?",
        QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ) return TRUE;
  return FALSE;
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::load_example( const QString& filename )
 {
    if ( !m_modified || QMessageBox::warning( this,
	"Closing the current document",
	"The current document was modified. Close anyway ?",
        QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ) {
  	openFile( KSGlobalSettings::examplePath()+"/"+filename );
	}
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotExampleSimple()
 {
  load_example( "simple.kmp" );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotExampleContour()
 {
  load_example( "contour.kmp" );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotExamplePath3d()
 {
  load_example( "path3d.kmp" );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotExampleSurface()
 {
  load_example( "surface.kmp" );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotExampleShell()
 {
  load_example( "shell.kmp" );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotAbout()
 {
  QString message = tr("KMatplot 0.4 \n"
	"This program is distibuted under GPL licence.\n\n"
	"(c) 2000-2002 Kamil Dobkowski kamildobk@poczta.onet.pl \n"
	" Python module: Martin Wiechert martin.wiechert@qmx.de" );
  QMessageBox::critical( NULL, tr("Error"), message, QMessageBox::Ok, 0, 0 );
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotCut()
 {
  if ( m_workspace->activeWindow() ) m_workspace->activeWindow()->cut();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotCopy()
 {
  if ( m_workspace->activeWindow() ) m_workspace->activeWindow()->copy();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotCopyAll()
 {
  if ( m_workspace->activeWindow() ) m_workspace->activeWindow()->copyAll();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::slotPaste()
 {
  if ( m_workspace->activeWindow() ) m_workspace->activeWindow()->paste();
 }

//-----------------------------------------------------------//

void KMatplotShell::slotDelete()
 {
  if ( m_workspace->activeWindow() ) m_workspace->activeWindow()->del();
 }

//-----------------------------------------------------------------------------//

void KMatplotShell::refreshSettings()
 {
 }

//-------------------------------------------------------------//

void KMatplotShell::slotNewPage()
 {
  m_workbook->execute( new KSCmdAddPage( new QSPage(NULL), m_workbook ) );
 }

//-----------------------------------------------------------//

void KMatplotShell::slot_new_undo()
 {
  m_undo->setEnabled( m_workbook->commandHistory()->isUndoPossible() );
  m_undo->setMenuText( tr("Undo: ")+m_workbook->commandHistory()->undoCommandTitle() );
 }

//-----------------------------------------------------------//

void KMatplotShell::slot_new_redo()
 {
  m_redo->setEnabled( m_workbook->commandHistory()->isRedoPossible() );
  m_redo->setMenuText( tr("Redo: ")+m_workbook->commandHistory()->redoCommandTitle() );
 }

//-----------------------------------------------------------//

void KMatplotShell::slotUndo()
 {
  m_workbook->commandHistory()->undo();
 }

//-----------------------------------------------------------//

void KMatplotShell::slotRedo()
 {
  m_workbook->commandHistory()->redo();
 }

//-----------------------------------------------------------//

void KMatplotShell::slot_set_dirty()
 {
  m_modified = true;
 }

//-----------------------------------------------------------//

void KMatplotShell::slot_show_error( const QString& message )
 {
  QMessageBox::critical( NULL, tr("Error"), message, QMessageBox::Ok, 0, 0 );
 }

//-----------------------------------------------------------//

void KMatplotShell::slotTool( QAction *action )
 {
  doAction( action );
 }

//-----------------------------------------------------------//

void KMatplotShell::slotPageZoom( QAction */*action*/ )
 {
  doAction( m_zoom );
 }

//-----------------------------------------------------------//

bool KMatplotShell::slotPrint()
 {
  bool end = false;
  while( !end )
  switch( QMessageBox::information( centralWidget(),
                                    tr("Print"),
                                    tr("Print the current document ?"),
                                    tr("&Print"), tr("Printer &Setup..."), tr("&Cancel"),
                                    0, 2 ) ) {
        case 0: // Print
                end = true;
                break;
        case 1: // Page setup
                end = false;
                slotPrinterSetup();
                break;
        case 2: // Cancel
                end = true;
                return TRUE;
                break;
       }

  QSConsole::write(tr("Printing. Please wait..."));
  slotShowHelpMessage(tr("Printing. Please wait..."));

  QPainter paint(m_printer);
  QPaintDeviceMetrics pdm(m_printer);

  int print_dpi = KSGlobalSettings::useCustomPrintDpi() ? KSGlobalSettings::customPrintDpi() : 600 ;
  if ( print_dpi != pdm.logicalDpiX() || print_dpi != pdm.logicalDpiY() ) {
	// set resolution of the paper
	paint.setWindow( 0, 0,
		   int(pdm.width()  * print_dpi / pdm.logicalDpiX() + 0.5),
		   int(pdm.height() * print_dpi / pdm.logicalDpiY() + 0.5) );
	}

  m_workbook->print( &paint, m_printer, print_dpi );
  paint.end();
  QSConsole::write(tr("Done."));
  slotShowHelpMessage(tr("Done."));
  return FALSE;
 }

//-----------------------------------------------------------//

void KMatplotShell::slotPrinterSetup()
 {
  m_printer->setMinMax( 1, m_workbook->pageCount() );
  if ( m_printer->setup(centralWidget()) ) m_workbook->setPrinter( m_printer );
 }

//-----------------------------------------------------------//

void KMatplotShell::slotConfigure()
 {
  KSConfigureDlg dlg;
  if ( dlg.exec() ) dlg.applySettings();
 }

//-----------------------------------------------------------//

void KMatplotShell::disableCustomActions()
 {
 m_copy->setEnabled( FALSE );
 m_copy_all->setEnabled( FALSE );
 m_cut->setEnabled( FALSE );
 m_paste->setEnabled( FALSE );
 m_delete->setEnabled( FALSE );
 m_zoom->setEnabled( FALSE );
 m_datasets->setEnabled( FALSE );
/*
 m_zoom_50->setEnabled( FALSE );
 m_zoom_75->setEnabled( FALSE );
 m_zoom_100->setEnabled( FALSE );
 m_zoom_150->setEnabled( FALSE );
 m_zoom_200->setEnabled( FALSE );
*/
 m_grid->setEnabled( FALSE );
 m_ioinfo->setEnabled( FALSE );

 m_new_legend->setEnabled( FALSE );

 m_wizard->setEnabled( FALSE );
 m_new_axes2d->setEnabled( FALSE );
 m_new_axes3d->setEnabled( FALSE );
 m_new_curve->setEnabled( FALSE );
 m_new_image->setEnabled( FALSE );
 m_new_contour->setEnabled( FALSE );
 m_new_ngcontour->setEnabled( FALSE );
 m_new_surface->setEnabled( FALSE );
 m_new_figure->setEnabled( FALSE );
 m_new_xaxis->setEnabled( FALSE );
 m_new_yaxis->setEnabled( FALSE );
 m_new_zaxis->setEnabled( FALSE );
 m_new_vaxis->setEnabled( FALSE );

 m_cut_dataset->setEnabled( FALSE );
 m_copy_dataset->setEnabled( FALSE );
 m_copy_all_dataset->setEnabled( FALSE );
 m_paste_dataset->setEnabled( FALSE );
 m_delete_dataset->setEnabled( FALSE );
 m_raise_dataset->setEnabled( FALSE );
 m_lower_dataset->setEnabled( FALSE );
 m_bring_dataset_to_front->setEnabled( FALSE );
 m_send_dataset_to_back->setEnabled( FALSE );

 m_new_sheet->setEnabled( FALSE );
 m_rename_sheet->setEnabled( FALSE );
 m_new_matrix->setEnabled( FALSE );
 m_new_string->setEnabled( FALSE );
 m_new_formula->setEnabled( FALSE );
 m_new_reference->setEnabled( FALSE );
 m_import_octave->setEnabled( FALSE );
 m_export_octave->setEnabled( FALSE );
 m_detach->setEnabled( FALSE );
 m_transpose->setEnabled( FALSE );

 m_cut_sheet ->setEnabled( FALSE );
 m_copy_sheet->setEnabled( FALSE );
 m_copy_all_sheet->setEnabled( FALSE );
 m_paste_sheet->setEnabled( FALSE );
 m_delete_sheet->setEnabled( FALSE );

 m_rename_page->setEnabled( FALSE );
 m_delete_page->setEnabled( FALSE );
 m_page_to_front->setEnabled( FALSE );
 m_page_to_back->setEnabled( FALSE );
 m_raise_page->setEnabled( FALSE );
 m_lower_page->setEnabled( FALSE );
 m_export_picture->setEnabled( FALSE );

 m_bring_to_front->setEnabled( FALSE );
 m_send_to_back->setEnabled( FALSE );
 m_raise->setEnabled( FALSE );
 m_lower->setEnabled( FALSE );
 m_group->setEnabled( FALSE );
 m_ungroup->setEnabled( FALSE );

 m_tools->setEnabled( FALSE );
/*
 m_tool_zoom->setEnabled( FALSE );
 m_tool_locate->setEnabled( FALSE );
 m_tool_select->setEnabled( FALSE );
 m_tool_label->setEnabled( FALSE );
 m_tool_arrow->setEnabled( FALSE );
 m_tool_rect->setEnabled( FALSE );
 */
 m_hide_sliders->setEnabled( FALSE );
 m_apply_button->setEnabled( FALSE );
 m_hide_rulers->setEnabled( FALSE );
 m_x11_backstoring->setEnabled( FALSE );
 m_show_full_page->setEnabled( FALSE );
 }


 //-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//

KSSimpleAction::KSSimpleAction( KMatplotShell *shell, QObject *parent, const char *name, bool toggle )
:QAction( parent, name, toggle )
 {
  m_shell = shell;
  connect( this, SIGNAL(activated()), this, SLOT(slot_activated()) );
 }

//-----------------------------------------------------------//

KSSimpleAction::KSSimpleAction( KMatplotShell *shell, const QString &text, const QIconSet &icon, const QString &menuText, QKeySequence accel, QObject *parent, const char *name, bool toggle )
:QAction( text, icon, menuText, accel, parent, name, toggle )
 {
  m_shell = shell;
  connect( this, SIGNAL(activated()), this, SLOT(slot_activated()) );
 }

//-----------------------------------------------------------//

KSSimpleAction::KSSimpleAction ( KMatplotShell *shell, const QString & text, const QString & menuText, QKeySequence accel, QObject * parent, const char *name, bool toggle )
:QAction( text, menuText, accel, parent, name, toggle )
 {
  m_shell = shell;
  connect( this, SIGNAL(activated()), this, SLOT(slot_activated()) );
 }

//-----------------------------------------------------------//

KSSimpleAction::~KSSimpleAction()
 {
 }

//-----------------------------------------------------------//

void KSSimpleAction::slot_activated()
 {
  if ( m_shell ) m_shell->doAction( this );
 }

//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//
//-----------------------------------------------------------//


KSSimpleContainer::KSSimpleContainer( QWidget *parent, int w, int h, int margin )
 : QFrame( parent )
 {
  m_widget = NULL;
  m_size = QSize( w, h );
  m_margin = margin;
 }

//-----------------------------------------------------------//

KSSimpleContainer::~KSSimpleContainer()
 {
  delete m_widget;
 }

//-----------------------------------------------------------//

void KSSimpleContainer::setWidget( QWidget *widget )
 {
  delete m_widget;
  m_widget = widget;
  if ( m_widget ) {
	m_widget->move( m_margin, m_margin );
	m_widget->resize( width()-2*m_margin, height()-2*m_margin );
	m_widget->show();
	}
 }

//-----------------------------------------------------------//

void KSSimpleContainer::resizeEvent ( QResizeEvent * )
 {
  if ( m_widget ) {
	m_widget->resize( width()-2*m_margin, height()-2*m_margin );
	}
 }

//-----------------------------------------------------------//

QSize KSSimpleContainer::sizeHint() const
 {
  return m_size;
 }

//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//

KSSimpleConsole::KSSimpleConsole( KMatplotShell *shell )
: QSConsole()
 {
  m_shell = shell;
 }

//------------------------------------------------------------------------------//

KSSimpleConsole::~KSSimpleConsole()
 {
 }

//------------------------------------------------------------------------------//

void KSSimpleConsole::appendText( const QString& message )
 {
  m_shell->slotShowOutputMessage( message );
 }

//------------------------------------------------------------------------------//
