/***************************************************************************
                          ksdataobjectfactory.h  -  description
                             -------------------
    begin                : Thu Dec 6 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSDATAOBJECTFACTORY_H
#define KSDATAOBJECTFACTORY_H

#include<qstring.h>
#include<qstringlist.h>

class QWidget;
class QSMatrix;
class QSData;
class MPSymbol;
class MPSymbolList;
class KSMPanel;
class KSMatrixEditorInterf;
class KSWorkbook;

/**
  * This is the class which provides some metadata information
  * about QSData objects. Many of the methods should be really
  * virtual functions of the QSData objects.
  * @author kamil
  */
class KSDataObjectFactory {
public:
	enum DataObject { ObjectAxis, ObjectCurve, ObjectImage, ObjectGriddedContour, ObjectNonGriddedContour, ObjectSurface, ObjectFigure, ObjectAxes2D, ObjectAxes3D, ObjectSheet, ObjectSheetList };
	/**
	  * Constructor
	  */
	KSDataObjectFactory();
	/**
	  * Destructor
	  */
	virtual ~KSDataObjectFactory();
	/**
	  * Returns channels as a variable 'x', 'y', 'z', 'v', 'dx', 'dy' ... etc
	  * For use in formulas.
	  */
	static MPSymbol *channelVariable( QSData *object, const char *identifier, MPSymbolList *args, int columnFrom, int columnTo );
	/**
	  * Returns a number of channels
	  */
	static int channelNumber( DataObject objectType );
    	/**
      	  * Returns a description of the given channel or the object itself( when channel is -1 ).
      	  */
    	static QString channelNameFactory( QSData *object, int channel = -1 );
   	/**
      	  * Returns a description of the given channel or the object itself( when channel is -1 ).
      	  */
    	static QString channelNameFactory( DataObject objectType, int channel = -1 );
    /**
      * Returns a long description of the given channel.
      */
	static QString channelDescFactory( QSData *object, int channel );
    /**
      * Returns a long description of the given channel.
      */
	static QString channelDescFactory( DataObject objectType, int channel );
    /**
      * Returns a long description of the given channel.
      */
 	static QStringList channelColumnTitlesFactory( QSData *object, int channel );
    /**
      * Creates editor for this matrix.
      */
	static KSMatrixEditorInterf *createEditor( KSWorkbook *workbook, QSData *dataObject, int channel, QWidget *parent );
    /**
      * Create and return a config panel for this matrix.
      * It should have a fixed height.
      */
	static KSMPanel *createCfgPanel( QSMatrix *matrix, KSWorkbook *workbook, QWidget *parent );


};

#endif
