/***************************************************************************
                          ksdatasymbolfactory.cpp  -  description
                             -------------------
    begin                : Thu Dec 6 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksdatasymbolfactory.h"
#include "ksworkbook.h"
#include "ksglobalmatrixlist.h"
#include "ksdataobjectfactory.h"
#include "ksmatrix.h"

//-------------------------------------------------------------------------//

KSDataSymbolFactory::KSDataSymbolFactory( KSWorkbook *workbook, QSData *object )
 {
  m_workbook =  workbook;
  m_data_object = object;
  m_sel_matrix = NULL;
 }

//-------------------------------------------------------------------------//

KSDataSymbolFactory::~KSDataSymbolFactory()
 {
 }

//-------------------------------------------------------------------------//

void KSDataSymbolFactory::setSelection( QSMatrix *matrix, const QRect& range )
 {
  m_sel_matrix = matrix;
  m_sel_range  = range;
 }

//-------------------------------------------------------------------------//

MPSymbol *KSDataSymbolFactory::create( const char *identifier, MPSymbolList *args, int colFrom, int colTo )
 {
  if ( m_sel_matrix && qstrcmp(identifier,"selection") == 0 ) {
	 return new MPSymQSMatrix( m_sel_matrix, m_sel_range, args, colFrom, colTo, "sel" );
	}
  if ( m_data_object ) {
	MPSymbol *channel = KSDataObjectFactory::channelVariable( m_data_object, identifier, args, colFrom, colTo );
	if ( channel ) return channel;
	}
  if ( m_workbook ) {
	 KSSheetList *sheets = m_workbook->sheets();
	 for( int i=0; i<sheets->childCount(); i++ ) {
		KSSheet *sheet = sheets->child(i);
		if (	qstrcmp(sheet->name(),identifier)==0 &&
			sheet->matrix(0) &&
			sheet->matrix(0)->rows() &&
			sheet->matrix(0)->cols()  )
				return new MPSymQSMatrix( sheet->matrix(0), args, colFrom, colTo, identifier );
		}
	}
  return NULL;
 }

//-------------------------------------------------------------------------//


