/***************************************************************************
                          ksdatasymbolfactory.h  -  description
                             -------------------
    begin                : Thu Dec 6 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSDATASYMBOLFACTORY_H
#define KSDATASYMBOLFACTORY_H

#include "formula/mpsymbol.h"
#include <qrect.h>

class KSWorkbook;
class QSData;
class QSMatrix;
/**
  * Symbol factory for formulas, which proveides a sheets ( symbol names follows sheet titles )
  * and channels ( such as x, y, z, v, dx, dy )
  * @author kamil
  */
class KSDataSymbolFactory : public MPSymbolFactory  {
public:
	/**
	  * Constructor
	  * Set workbook if you want sheet variables to be available in formula.
	  * Set data object if you want channels variables (x, y, z ) to be available in formuls
	  */
	KSDataSymbolFactory( KSWorkbook *workbook, QSData *object=NULL );
	/**
	  * Destructor
	  */
	virtual ~KSDataSymbolFactory();
	/**
	  * Set selection if you want 'selection' symbol to be available in formula.
          */
	void setSelection( QSMatrix *matrix, const QRect& range );
	/**
	  * Creates the given symbol.
	  */
	virtual MPSymbol *create( const char *identifier, MPSymbolList *args, int colFrom, int colTo );
	/**
	  * No description available. Returns 0.
	  */
	virtual	int symbolCount() const { return 0; }
	/**
	  * Returns NULL.
	  */
	virtual const char *symbolIdentifier( int ) { return NULL; }
	/**
	  * Returns NULL.
	  */
	virtual const char *symbolDescription( int ) { return NULL; }

protected:
	KSWorkbook *m_workbook;
	QSData *m_data_object;
	QSMatrix *m_sel_matrix;
	QRect m_sel_range;
	
};

#endif
