/***************************************************************************
                                ksmatrixio.cpp
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "ksmatrixio.h"
#include "ksmatrixiohandler.h"
#include "ksmatrixmat.h"
#include "ksmatrixascii.h"

KSHandlersList KSMatrixIO::hlist;
bool KSMatrixIO::initialized = false;

//-------------------------------------------------------------------------//

KSMatrixIO::KSMatrixIO( const QString& filename, int mode  )
 {
  if ( !initialized ) {	
	// initialize a file format list
	addHandler( new KSMatrixMAT()   );
	addHandler( new KSMatrixASCII() );
	initialized = true;
	}
  if ( !filename.isNull() ) openFile( filename, mode );
 }

//-------------------------------------------------------------------------//

KSMatrixIO::~KSMatrixIO()
 {
  closeFile();
 }

//-------------------------------------------------------------------------//

void KSMatrixIO::setDefaultHandler()
 {
  KSMatrixIOHandler *dhandler;
  if ( !file.isReadable() ) { dformat = QString(); return; }
  QDataStream s( &file );
  dhandler = findHandler( s, file.name() );
  if ( dhandler ) dformat = dhandler->format();
             else dformat = QString();
 }

//-------------------------------------------------------------------------//

void KSMatrixIO::openFile( const QString& filename, int mode )
 {
  // close a previously opened file.
  closeFile();
  file.setName( filename );
  if( file.open(mode) ) {
	setDefaultHandler();
	file.resetStatus();
	file.reset();
	} else {
	file.setName(QString());
	dformat = QString();	
	}
 }

//-------------------------------------------------------------------------//

void KSMatrixIO::closeFile()
 {
  file.close();
  file.setName(QString());
  dformat = QString();
 }

//-------------------------------------------------------------------------//

KSHeadersList *KSMatrixIO::loadHeaders( const QString& format )
 {
  if ( !file.isOpen() ) return NULL;
  KSMatrixIOHandler *handler;
  QDataStream s(&file);
  if ( !format.isNull() ) handler = findHandler( format );
     else if ( !dformat.isNull() ) handler = findHandler( dformat );
                              else handler = findHandler( s, file.name() );
  if ( !handler ) return NULL;
  file.resetStatus(); file.reset();
  return handler->headers(s);
 }

//-------------------------------------------------------------------------//

KSMatrix *KSMatrixIO::loadMatrix( const QString& matrixname, const QString& format )
 {
  if ( !file.isOpen() ) return NULL;
  KSMatrixIOHandler *handler;
  QDataStream s(&file);
  if ( !format.isNull() ) handler = findHandler( format );
     else if ( !dformat.isNull() ) handler = findHandler( dformat );
                              else handler = findHandler( s, file.name() );
  if ( !handler ) return NULL;
  file.resetStatus(); file.reset();
  return handler->load( s, matrixname );
 }

//-------------------------------------------------------------------------//

void KSMatrixIO::saveMatrix( QSMatrix *m, const QString& matrixname, const QString& format )
 {
  if ( !file.isOpen() ) return;
  emit progress(0);
  QDataStream s(&file);
  KSMatrixIOHandler *handler = findHandler( format );
  if ( handler ) handler->save( s, m, matrixname );
 }

//-------------------------------------------------------------------------//

KSMatrixIOHandler *KSMatrixIO::findHandler( QDataStream& s, const QString&  )
 {
  KSHandlersList::iterator curr = hlist.begin();
  KSHandlersList::iterator last = hlist.end();
  s.device()->resetStatus(); s.device()->reset();
  while ( curr != last ) {
         if ( (*curr)->check(s) ) break;
         s.device()->resetStatus(); s.device()->reset();
         curr++;
        }

  if ( curr != last ) return (*curr);
  return NULL;
 }

//-------------------------------------------------------------------------//

KSMatrixIOHandler *KSMatrixIO::findHandler( const QString& format )
 {
  KSHandlersList::iterator curr = hlist.begin();
  KSHandlersList::iterator last = hlist.end();
  while ( curr != last ) {
         if ( (*curr)->format() == format ) break;
         curr++;
        }
  if ( curr != last ) return (*curr);
  return NULL;
 }

//-------------------------------------------------------------------------//

void KSMatrixIO::addHandler( KSMatrixIOHandler *handler )
 {
  if ( handler ) hlist.push_back( handler );
 }

//-------------------------------------------------------------------------//

int KSMatrixIO::removeHandlers( const QString& format )
 {
  KSHandlersList::iterator curr = hlist.begin();
  KSHandlersList::iterator last = hlist.end();

  int result = 0;
  while( curr != last ) {
         if ( (*curr)->format() == format ) {
                KSHandlersList::iterator last = curr; curr++;
                hlist.erase( last ); result ++;
               } else curr ++;
        }
  return result;
 }




























