/***************************************************************************
                          kswinworksheet.h  -  description
                             -------------------
    begin                : Thu Jan 17 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSWINWORKSHEET_H
#define KSWINWORKSHEET_H

#include <qwidget.h>
#include <qpoint.h>
#include "ksworkspace.h"

class QListViewItem;
class QSData;
class QSPlotView;
class KSWorkbook;
class KSChannelList;
class KSChannelListItem;
class KSMPanel;
class KSMatrixEditorInterf;
class KMatplotShell;

/**
  *@author kamil
  */
class KSWinWorksheet : public KSWorkspaceWindow  {
	Q_OBJECT
  public:
	KSWinWorksheet( KSWorkspace *workspace, bool worksheetMode );
	virtual ~KSWinWorksheet();
	void KSWinWorksheet::setDataObject( QSData *data );
	KSChannelList *chanList() const;
	KSChannelListItem *selectedItem() const;
	KSMPanel *settingsPanel() const;
	KSMatrixEditorInterf *matrixEditor() const;
	virtual void activated();
	virtual void deactivated();
	virtual void cut();
	virtual void copy();
	virtual void copyAll();
	virtual void paste();
	virtual void del();
	virtual void doAction( QAction* /*action*/ );
	virtual QWidget *createObjectPanel( QWidget *parent );
	virtual QWidget *createPropertyPanel( QWidget *parent );

  public slots:
	void slotRenameSheet();
	void slotRaiseSheet();
	void slotLowerSheet();
	void slotBringToFrontSheet();
	void slotSendToBackSheet();
	void slotNewSheet();
	void slotNewFormula();
	void slotNewReference();
	void slotNewString();
	void slotNewMatrix();
	void slotImportOctave();
	void slotExportOctave();
	void slotTranspose();
	void slotDetach();

	void slotCutSheet();
	void slotCopySheet();
	void slotCopyAllSheet();
	void slotPasteSheet();
	void slotDeleteSheet();

	void slotShowMenu(QListViewItem*, const QPoint& pos, int );

  protected:
	KSWorkbook *m_workbook;
	KMatplotShell *m_shell;
	KSMatrixEditorInterf *m_editor;
	QSData *m_data;
	QSData *m_curr_data;
	QSData *m_removed_data;
	int m_curr_channel;
	bool m_worksheet_mode;

	void make_settings_panel();
	void make_editor();
	KSMPanel *create_settings_panel();
	void set_selected( QSData *dataObject, int channel );

  protected slots:
	void slot_channel_selected();
	void slot_data_changed( QSData *dataObject, int channel );
	void slot_child_removed( QSData *dataObject );
	void slot_added( QSData *dataObject );
	void slot_removed( QSData *dataObject );
	void slot_deleted( QSData *dataObject );
	void slot_name_changed( QSData *object, const char *name );
 };

#endif
