/***************************************************************************
                                  ksworksheetdlg.h
                             -------------------
    begin                : Tue Mar 6 2001
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSWORKSHEETDLG_H
#define KSWORKSHEETDLG_H

 /*
#include "ksworkbook.h"
#include "widgets/qsdata.h"
//#include <qmainwindow.h>
#include<qwidget.h>

class QLabel;
class QGridLayout;
class QPushButton;
class QProgressDialog;
class QComboBox;
class QTabBar;
class QListView;
class QListViewItem;
class KSChannelList;
class KSChannelListItem;
class QAction;
class QSPlotView;
class KSMatrixEditorInterf;
class KSMPanel;
class QSAxes;
class KSSheet;
class KSCmdAddDatasetGroup;


class KSWorksheetDlg : public QWidget
 {
  Q_OBJECT
  public:
	KSWorksheetDlg( KSWorkbook *workbook, QSPlotView *view, QWidget *parent=0, const char *name=0 );
       ~KSWorksheetDlg();
        void setCurrentPage( int index );
	QSPage *currentPage() const { return m_curr_page; }
	void setCurrentObject( QSData *index );
	QSData *currentObject() const { return m_curr_object; }

        QSData *selectedObject() const;
	int selectedChannel() const;
	QSMatrix *selectedMatrix() const;

  public slots:
        virtual void slotNewSheet();
        virtual void slotNewMatrix();
	virtual void slotNewReference();
	virtual void slotNewString();
	virtual void slotNewFormula();

	virtual void slotImportData();
        virtual void slotExportData();

	virtual void slotUndo();
	virtual void slotRedo();
	virtual void slotCut();
	virtual void slotCopy();
	virtual void slotCopyAll();
	virtual void slotPaste();
	virtual void slotDelete();
	virtual void slotDetach();
	virtual void slotTranspose();

	virtual void slotCutSheet();
	virtual void slotCopySheet();
	virtual void slotCopyAllSheet();
	virtual void slotPasteSheet();
	virtual void slotDeleteSheet();
	virtual void slotBringToFrontSheet();
	virtual void slotSendToBackSheet();
	virtual void slotRaiseSheet();
	virtual void slotLowerSheet();

	virtual void slotNewSeriesAuto();
	virtual void slotNewPixmapDirect();
	virtual void slotNewContourDirect();
	virtual void slotNewContourDelunay();
	virtual void slotNewSurfaceDirect();
	virtual void slotNewSurfaceDelunay();
        virtual void slotNewFigureTrajectory();

        virtual void slotSettingsPanel();
	virtual void slotConfAccels();
        virtual void slotEditToolbars();
        virtual void toggleStatusBar();
        virtual void toggleToolBar();


  private:
        KSWorkbook    *m_workbook;
	QSPlotView    *m_view;

	QSPage 		*m_curr_page;
	QSData		*m_curr_object;
	int		m_curr_channel;

	QWidget       *m_main_view;
	QComboBox     *m_page_list;
	QListView     *m_object_list;
	KSChannelList *m_chan_list;

   	QLabel 	        *m_chan_description;
        QGridLayout     *m_panel_layout;
	QProgressDialog *m_progress_dlg;

  	KSMatrixEditorInterf *m_editor;
	KSMPanel     *m_settings_panel;	

        QAction *m_new_sheet;
        QAction *m_new_matrix;
        QAction *m_new_string;
        QAction *m_new_formula;
        QAction *m_new_reference;
        QAction *m_import_data;
        QAction *m_export_data;

        QAction *m_close;

 	QAction *m_undo;
	QAction *m_redo;
	QAction* m_cut;
	QAction* m_copy;
	QAction* m_copy_all;
	QAction* m_paste;
	QAction* m_delete;

        QAction *m_transpose;
        QAction *m_detach;

        QAction *m_series;
        QAction *m_pixmap;
        QAction *m_contour;
        QAction *m_contour_delunay;
        QAction *m_surface;
        QAction *m_surface_delunay;
        QAction *m_figure_trajectory;


        QMap<int,QSData*>     m_objects;
  	bool m_settings_panel_visible;

	void make_settings_panel();
	void make_editor();
	bool confirm( const QString& message );
  	KSSheet *get_sheet();
	QSAxes *get_axes();
        void add_new_series( KSCmdAddDatasetGroup *cmd, QSAxes *axes, KSSheet *m, int column_x, int column_y, int column_dx, int column_dy );
        void set_column( KSSheet *src_sheet, int src_column, QSData *dst_object, int dst_channel );
        bool confirm_new_matrix( KSChannelListItem *citem );

	void recreate_page_list();
	void update_page_list();
	void recreate_object_list();
	void update_object_list();

  private slots:
  	void slot_refresh_object_list();
  	void slot_data_changed( QSData *object, int channel );
	void slot_channel_description( const QString& text );
	void slot_progress( int percent, bool *cancel );
	void slot_page_selected(int);
        void slot_page_list_changed();
	void slot_object_selected( QListViewItem * );
	void slot_object_list_changed();
  	void slot_channel_selected();
	void slot_new_undo();
	void slot_new_redo();
	void slot_show_menu(QListViewItem*, const QPoint&, int);
 };
*/
#endif
