/***************************************************************************
                          ksworkspace.h  -  description
                             -------------------
    begin                : Thu Jan 17 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSWORKSPACE_H
#define KSWORKSPACE_H

#include <qwidget.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qpushbutton.h>

class QAction;
class QWorkspace;
class QPushButton;
class QHButtonGroup;
class KMatplotShell;
class KSWorkspaceWindow;
class KSWindowButton;

/**
  * MDI interface for KSWorkspace windows.
  *@author kamil
  */
class KSWorkspace : public QWidget  {
	friend KSWorkspaceWindow;
	Q_OBJECT
 public:
	/**
	  * Constructor
	  */
	KSWorkspace( KMatplotShell *shell, const char *name=0 );
	/**
	  * Destructor
	  */
	virtual ~KSWorkspace();
	QWorkspace *workspace() const { return m_workspace; }
	KMatplotShell *shell() const { return m_shell; }
	KSWorkspaceWindow *activeWindow() const;
	virtual bool eventFilter( QObject *o, QEvent *e );

 protected:
	/**
	  * This is called by the contructor of the workspace window. It creates window button.
	  */
	KSWindowButton *addWindow( KSWorkspaceWindow *w );
	/**
	  * Called form KSWorkspaceWindow destructor. Deactivates window if it is active and deletes
	  * window button.
	  */
	void removeWindow( KSWorkspaceWindow *w );
	/**
	  * Called when window 'w' is activated. Sets window active, sets window button to 'on'
	  * creates object and property panels.
	  */
   	void windowActivate( KSWorkspaceWindow *w );
	/**
	  * Called when window 'w' is deactivated. Deactivates window, sets window button to 'off',
	  * deletes object and property panel.
	  */
	void windowDeactivate( KSWorkspaceWindow *w );
	QWorkspace *m_workspace;
	KMatplotShell *m_shell;
 	QWidget *m_button_bar;
	QHButtonGroup *m_buttons;

  protected slots:
	void slot_window_activated( QWidget *w );
 };


//--------------------------------------------------------------------//

/**
  * MDI child window of KSWorkspace..
  */
class KSWorkspaceWindow : public QWidget {
	friend KSWorkspace;
  public:
	/**
	  * Constructor.
	  */
	KSWorkspaceWindow( KSWorkspace *workspace,  const QString& caption, const QPixmap& icon, WFlags f=0 );
	/**
	  * Destructor.
	  */
	virtual ~KSWorkspaceWindow();
	/**
	  * Sets caption and a button title.
	  */
	void setTitle( const QString& newTitle );
	/**
	  * Return caption.
	  */
	QString title() const { return caption(); }
	/**
	  * Returns if the window is active.
	  */
	bool isActive() const { return m_active; }
	/**
	  * Sets the main widget.
	  */
        void setContents( QWidget *contents );
	/**
	  * Returns the main widget.
	  */
	QWidget *contents() const { return m_contents; }
	/**
	  * Returns a button attached to this window.
	  */
        KSWindowButton *button() const { return m_button; }
	/**
	  * Called when window is activated( gains focus ).
	  */
	virtual void activated() {}
	/**
	  * Called when window is deactivated.
	  */
	virtual void deactivated() {}
	/**
	  * Action cut called in the main window
	  */
	virtual void cut() {}
	/**
	  * Action copy called in the main window
	  */
	virtual void copy() {}
	/**
	  * Action copyAll called in the main window
	  */
	virtual void copyAll() {}
	/**
	  * Action paste called in the main window
	  */
	virtual void paste() {}
	/**
	  * Action delete called in the main window
	  */
	virtual void del() {}
	/**
	  * The main window - KMatplotShell routes called actions to the currently active
	  * window by this fuction.  Notice
	  * that the standard actions: cut, sopy, paste, delete, are not
	  * routed by this function but a special functions are called directly.
	  */
	virtual void doAction( QAction* /*action*/ ) {}
	/**
	  * Reimplement this function to create an object ( side ) panel.
	  * This panel is created when windows becomes active and is deleted
	  * when it becomes inactive.
	  */
	virtual QWidget *createObjectPanel( QWidget *parent ) { return NULL; }
	/**
	  * Reimplement this function to create an property ( bottom ) panel.
	  * This panel is created when windows becomes active and is deleted
	  * when it becomes inactive.
	  */	
	virtual QWidget *createPropertyPanel( QWidget *parent ) { return NULL; }	

  protected:
	virtual void setActive( bool enable );
	virtual void resizeEvent( QResizeEvent *event );
	virtual void focusInEvent( QFocusEvent *event );
	virtual void focusOutEvent( QFocusEvent *event );
	KSWorkspace *m_workspace;
	QWidget *m_contents;
	KSWindowButton *m_button;
	bool m_active;
 };

//--------------------------------------------------------------------//

/*
 * Internal
 */
class KSWindowButton : public QPushButton
 {
	Q_OBJECT
  public:
	KSWindowButton( KSWorkspaceWindow *window, QWidget *parent );
	virtual ~KSWindowButton();
	virtual KSWorkspaceWindow *window() const { return m_window; }
  protected:
	KSWorkspaceWindow *m_window;
	virtual void contextMenuEvent ( QContextMenuEvent *e );
  protected slots:
	void slot_button_pressed();

 };

#endif
