/***************************************************************************
                                  kplot.cc
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

DEFUN_DLD (kplot, args, ,
" usage: kplot(Y)\n"
"        kplot(X,Y)\n"
"        kplot(X,Y, ...)\n"
"\n"
" If the first argument is a vector and the second is a matrix, the\n"
" the vector is plotted versus the columns (or rows) of the matrix.\n"
" (using whichever combination matches, with columns tried first.)\n"
"\n"
" If the first argument is a matrix and the second is a vector, the\n"
" the columns (or rows) of the matrix are plotted versus the vector.\n"
" (using whichever combination matches, with columns tried first.)\n"
"\n"
" If both arguments are vectors, the elements of y are plotted versus\n"
" the elements of x.\n"
"\n"
" If both arguments are matrices, the columns of y are plotted versus\n"
" the columns of x.  In this case, both matrices must have the same\n"
" number of rows and columns and no attempt is made to transpose the\n"
" arguments to make the number of rows match.\n"
"\n"
" If only one argument is given, it is taken as the set of y\n"
" coordinates and the x coordinates are taken to be the indices of the\n"
" elements, starting with 0.\n"
"\n"
" See also: ksetapp, ksetaxes, kadd, kremove, kremoveall, kaddaxes, kremoveaxes, kimage, kcontour, kmesh, ksetmatrix"
)
{
  octave_value_list result(-1.0);
  int nargin = args.length();

  int socket_fd = plot_connect( appNumber(), NULL, NULL );
  if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
	error( sys_errlist[errno] );
	return result;
	}

  int dataset_number = -1;

  //plot_remove_all_datasets( socket_fd, axesNumber() );

//
// Get the next pair of matrices from args
//
  int snum = 0;  // series number
  for( int i=0; i<nargin; i+=2 ) {
    Matrix x;
    Matrix y;
    if ( i+1 < nargin ) {
	  x = args(i+0).matrix_value();
	  y = args(i+1).matrix_value();
	 } else {
	  x = Matrix();  // empty
	  y = args(i).matrix_value();
	 }
    /**
      * Y = Y.TRANSPOSE() - not working
      */
    // normalize to column vectors ( if are row vectors )
    if  ( x.cols() > 1 && x.rows() == 1 ) { Matrix temp = x.transpose(); x = Matrix(); x = temp; }
    if  ( y.cols() > 1 && y.rows() == 1 ) { Matrix temp = y.transpose(); y = Matrix(); y = temp; }


    // fit vectors to rows or columns
    if ( x.cols() == 1 && y.rows() != x.rows() ) { Matrix temp = y.transpose(); y = Matrix(); y = temp; }
    if ( y.cols() == 1 && y.rows() != x.rows() ) { Matrix temp = x.transpose(); x = Matrix(); x = temp; }

    if ( x.cols() > 0 && x.rows() != y.rows() ) {
    	error(" matrix dimensions must match " );
	plot_disconnect( socket_fd );
	return result;
       }

    //
    // Send to application all series contained in this pair
    //
    int series = x.cols()>y.cols() ? x.cols() : y.cols();
    for ( int s=0; s<series; s++ ) {
         ColumnVector xvector;
	 ColumnVector yvector;
	 dataset_number = plot_add_dataset( socket_fd, axesNumber(), PlotCurve );
         if ( x.cols() > 0 ) xvector = (s<x.cols())?x.column(s):x.column(0);
         if ( y.cols() > 0 ) yvector = (s<y.cols())?y.column(s):y.column(0);
	 if ( x.cols() > 0 ) setMatrix( socket_fd, dataset_number, 0, Matrix(xvector) );
         if ( y.cols() > 0 ) setMatrix( socket_fd, dataset_number, 1, Matrix(yvector) );
         snum ++;
	}
    }

   //
   // Disconnect
   //		
   plot_disconnect( socket_fd );
   return octave_value_list( (double )dataset_number );			
 }


