/***************************************************************************
                                  kremoveall.cc
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

//------------------------------------------------------------------//

DEFUN_DLD (kremoveall, args, ,
" usage: kremoveall()\n"
"\n"
"Removes all datasets from a plot\an"
"See also: ksetapp, ksetaxes, kadd, kremove, kaddaxes, kremoveaxes, kplot, kimage, kcontour, kmesh, ksetmatrix\n" )
{
 int socket_fd = plot_connect( appNumber(), NULL, NULL );
 if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
			error( sys_errlist[errno] );
			return octave_value_list();
			}
 plot_remove_all_datasets( socket_fd, axesNumber() );
 plot_disconnect( socket_fd );
 return octave_value_list();
}

