/***************************************************************************
                             qscobjects.cpp
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include"qscobjects.h"
#include"widgets/qsdrv.h"
#include"widgets/qsaxes.h"
#include<qfontmetrics.h>
#include<qpainter.h>
#include<qpoint.h>
#include<qregion.h>
#include<math.h>

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//

QSCLabel::QSCLabel( const QString& init_text, QObject *parent  )
:QSCObject( parent )
 {
  m_edited = false;
  m_text   = init_text;
  m_angle  = 0;
  m_cursor = 0;
  m_shadow_pos.x = 5;
  m_shadow_pos.y = 5;
  m_pos.set( 0.0, 0.0, 0.0 );
  m_axis.set( QSAxes::normCoord, QSAxes::normCoord, QSAxes::normCoord );
  m_frame_align = m_text_align = Qt::AlignTop | Qt::AlignLeft ;
  m_fill.style = QSGFill::Transparent;
  m_shadow_fill.style = QSGFill::Transparent;
  m_shadow_fill.color = QSGColor( 0, 0, 0 );
  m_frame.style = QSGLine::Invisible;
 }

//-------------------------------------------------------------//

QSCLabel::~QSCLabel()
 {
 }

//-------------------------------------------------------------//

void QSCLabel::setEditMode( bool enabled )
 {
  m_edited = enabled;
 }

//-------------------------------------------------------------//

void QSCLabel::setCursorHint( int pos )
 {
  m_cursor = pos;
 }


//-------------------------------------------------------------//

void QSCLabel::rotate( int degs, QSDrv * )
  {
   parametersChanging();
   m_angle += degs;
   parametersChanged();
  }

//-------------------------------------------------------------//

QSPt2f QSCLabel::rCenter( QSDrv *drv )
  {
   QSPt2f pts[4];
   QSPt3f p1 = mixedToCanvas(m_pos,m_axis.x,m_axis.y,m_axis.z,drv->dpi);
   drv->setFont( m_font );
   drv->getRTextBoundingPoly( pts, QSPt2f(p1.x,p1.y), m_angle, m_text, m_text_align );

   QSPt2f a;
   QSPt2f b;
   if ( m_text_align & Qt::AlignLeft ) {
         b = pts[0]; a = pts[3] - pts[0];
        }
   else
   if ( m_text_align & Qt::AlignRight ) {
         b = pts[1]; a = pts[2] - pts[1];
        }
   else {
         QSPt2f m1 = pts[1]-pts[0];
         QSPt2f m2 = pts[2]-pts[3];
         m1 = pts[0] + QSPt2f( m1.x/2.0, m1.y/2.0 );
         m2 = pts[3] + QSPt2f( m2.x/2.0, m2.y/2.0 );
         b = m1; a = m2 - m1;
        }

   double t = 0.0;
   if ( m_text_align & Qt::AlignVCenter ) t = 0.5;
   else
   if ( m_text_align & Qt::AlignBottom ) t = 1.0;


   return QSPt2f( t*a.x+b.x, t*a.y+b.y );
  }

//-------------------------------------------------------------//

void QSCLabel::setBox( const QSRectf& r, QSDrv *drv )
  {
   parametersChanging();
   // moved on canvas by d pixels ( we ingnore sizes )
   // remember that r.pos != pos, so we cannot set pos = r,pos
   QSPt2f d = r.normalize().pos - box( drv ).pos;

   QSPt3f cpos = mixedToCanvas( m_pos, m_axis.x, m_axis.y, m_axis.z, drv->dpi );
   cpos.x += d.x;
   cpos.y += d.y;
   m_pos = canvasToMixed( cpos, m_axis.x, m_axis.y, m_axis.z, drv->dpi );
   parametersChanged();	
  }

//-------------------------------------------------------------//

QSRectf QSCLabel::box( QSDrv *drv )
  {
   QSPt2f pts[4];
   QSPt3f p1 = mixedToCanvas(m_pos,m_axis.x,m_axis.y,m_axis.z,drv->dpi);
   drv->setFont( m_font );
   drv->getRTextBoundingPoly( pts, QSPt2f(p1.x,p1.y), m_angle, m_text, m_text_align );

   double min_x = pts[0].x;
   double max_x = pts[0].x;
   double min_y = pts[0].y;
   double max_y = pts[0].y;
   for( int i=1; i<4; i++ ) {
	 min_x = QMIN( min_x, pts[i].x );
         max_x = QMAX( max_x, pts[i].x );
         min_y = QMIN( min_y, pts[i].y );
         max_y = QMAX( max_y, pts[i].y );
        }
   return QSRectf( min_x, min_y, max_x-min_x+1, max_y-min_y+1 );
  }

//-------------------------------------------------------------//

void QSCLabel::draw( QSDrv *drv, bool, bool )
  {
   if ( m_edited ) return;
   QSPt2f pts[4];
   QSPt2f shad = QSPt2f(drv->toPixels(m_shadow_pos.x), drv->toPixels(m_shadow_pos.y));
   QSPt3f p1 = mixedToCanvas(m_pos,m_axis.x,m_axis.y,m_axis.z,drv->dpi);
   drv->setFont( m_font );
   drv->getRTextBoundingPoly( pts, QSPt2f(p1.x,p1.y), m_angle, m_text, m_text_align );
	
   if ( m_shadow_fill.style != QSGFill::Transparent ) {
	for ( int i=0; i<4; i++ ) pts[i] = pts[i] + shad;
	drv->setLine( QSGLine::invisibleLine );
	drv->setFill( m_shadow_fill );
     	drv->drawPoly( pts, 4 );
	for ( int i=0; i<4; i++ ) pts[i] = pts[i] - shad;
       }
   if (  m_fill.style != QSGFill::Transparent ||
         m_frame.style != QSGLine::Invisible    ) {
         drv->setFill( m_fill );
         drv->setLine( m_frame );
         drv->drawPoly( pts, 4 );
        }

   drv->setFont( m_font );
   QSPt3f p = mixedToCanvas(m_pos,m_axis.x,m_axis.y,m_axis.z,drv->dpi);
   drv->drawRText( QSPt2f(p.x,p.y), m_angle, m_text, m_text_align );
   emit sigDrawEnds( this );
  }

//-------------------------------------------------------------//

void QSCLabel::insertString( int pos, const QString& s )
 {
  m_text.insert( pos, s );
 }

//-------------------------------------------------------------//

void QSCLabel::deleteString( int pos, int len )
 {
  m_text.remove( pos, len );
 }

//-------------------------------------------------------------//

QString QSCLabel::name()
 {
  return QString(tr("Label: ")) + m_text.simplifyWhiteSpace();
 }

//-------------------------------------------------------------//

void QSCLabel::setText( const QString& text )
 {
  SET_COBJECT_PROPERTY( m_text, text );
 }

//-------------------------------------------------------------//

void QSCLabel::setAngle( int angle )
 {
  SET_COBJECT_PROPERTY( m_angle, angle );
 }

//-------------------------------------------------------------//

void QSCLabel::setFrameAlign( int align )
 {
  SET_COBJECT_PROPERTY( m_frame_align, align );
 }

//-------------------------------------------------------------//

void QSCLabel::setTextAlign( int align )
 {
  SET_COBJECT_PROPERTY( m_text_align, align );
 }

//-------------------------------------------------------------//

void QSCLabel::setPos( const QSPt3f& pos )
 {
  SET_COBJECT_PROPERTY( m_pos, pos );
 }
	
//-------------------------------------------------------------//

void QSCLabel::setPosX( double value )
 {
  SET_COBJECT_PROPERTY( m_pos.x, value );
 }

//-------------------------------------------------------------//

void QSCLabel::setPosY( double value )
 {
  SET_COBJECT_PROPERTY( m_pos.y, value );
 }

//-------------------------------------------------------------//

void QSCLabel::setPosZ( double value )
 {
  SET_COBJECT_PROPERTY( m_pos.z, value );
 }

//-------------------------------------------------------------//

void QSCLabel::setCoord( const QSPt3& coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis, coordSystem );
 }
	
//-------------------------------------------------------------//

void QSCLabel::setCoordX( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis.x, coordSystem );
 }

//-------------------------------------------------------------//

void QSCLabel::setCoordY( int coordSystem )	
 {
  SET_COBJECT_PROPERTY( m_axis.y, coordSystem );
 }

//-------------------------------------------------------------//
   	
void QSCLabel::setCoordZ( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis.z, coordSystem );
 }

//-------------------------------------------------------------//

void QSCLabel::setFont( const QSGFont& font )
 {
  SET_COBJECT_PROPERTY( m_font, font );
 }

//-------------------------------------------------------------//

void QSCLabel::setFontProperty( const QString& data )
 {
  QSGFont new_font = toQSGFont(data);
  setFont( new_font );
 }

//-------------------------------------------------------------//

void QSCLabel::setFill( const QSGFill& fill )
 {
  SET_COBJECT_PROPERTY( m_fill, fill );
 }

//-------------------------------------------------------------//

void QSCLabel::setFillProperty( const QString &data )
 {
  QSGFill new_fill = toQSGFill(data);
  setFill( new_fill );
 }

//-------------------------------------------------------------//

void QSCLabel::setFrame( const QSGLine& line )
 {
  SET_COBJECT_PROPERTY( m_frame, line );
 }

//-------------------------------------------------------------//

void QSCLabel::setFrameProperty( const QString& data )
 {
  QSGLine new_line = toQSGLine(data);
  setFrame( new_line );
 }

//-------------------------------------------------------------//

void QSCLabel::setShadowFill( const QSGFill& fill )
 {
  SET_COBJECT_PROPERTY( m_shadow_fill, fill );
 }

//-------------------------------------------------------------//

void QSCLabel::setShadowFillProperty( const QString& data )
 {
  QSGFill new_shadow_fill = toQSGFill(data);
  setShadowFill( new_shadow_fill );
 }

//-------------------------------------------------------------//

void QSCLabel::setShadowPos( const QSPt2& shift )
 {
  SET_COBJECT_PROPERTY( m_shadow_pos, shift );
 }

//-------------------------------------------------------------//

void QSCLabel::setShadowPosX( int value )
 {
  SET_COBJECT_PROPERTY( m_shadow_pos.x, value );
 }

//-------------------------------------------------------------//

void QSCLabel::setShadowPosY( int value )
 {
  SET_COBJECT_PROPERTY( m_shadow_pos.y, value );
 }

//-------------------------------------------------------------//











//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//















QSCArrow::QSCArrow( QObject *parent )
:QSCObject( parent )
 {
  m_end1.set( 0.1, 0.5, 0.0 );
  m_end2.set( 0.1, 0.5, 0.0 );
  m_axis1.set( QSAxes::normCoord, QSAxes::normCoord, QSAxes::normCoord );
  m_axis2.set( QSAxes::normCoord, QSAxes::normCoord, QSAxes::normCoord );
  m_end2style.style = QSGArrow::FArrow;
  m_end1style.style = QSGArrow::None;

  m_visible = true;
 }

//-------------------------------------------------------------//

QSCArrow::~QSCArrow()
 {
 }


//-------------------------------------------------------------//

void QSCArrow::draw( QSDrv *drv, bool, bool )
 {
  if ( !m_visible ) return;
  QSPt3f pos1 = mixedToCanvas(m_end1,m_axis1.x,m_axis1.y,m_axis1.z,drv->dpi);
  QSPt3f pos2 = mixedToCanvas(m_end2,m_axis2.x,m_axis2.y,m_axis2.z,drv->dpi);
  QSPt2f p1 = QSPt2f(pos1.x,pos1.y);
  QSPt2f p2 = QSPt2f(pos2.x,pos2.y);
  drv->drawPoint( p1, m_end1point );
  drv->drawPoint( p2, m_end2point );
  drv->setLine( m_line );
  drv->drawArrow( p1, p2, m_end1style, m_end2style );
  emit sigDrawEnds( this );
 }


//-------------------------------------------------------------//

bool QSCArrow::isHit( const QSPt2f &p, QSDrv* drv )
 {
  return QSCObject::isHit( p, drv );
 }

//-------------------------------------------------------------//

void QSCArrow::rotate( int deg, QSDrv *drv )
 {
  parametersChanging();
  QSPt3f cp1 = mixedToCanvas( m_end1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  QSPt3f cp2 = mixedToCanvas( m_end2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );

  QWMatrix m;
  QSPt2f rc = rCenter( drv );
  m.translate( rc.x, rc.y );
  m.rotate( deg );
  m.translate( -rc.x, -rc.y );

  QSPt3f _cp1;
  QSPt3f _cp2;
  _cp1.z = cp1.z;
  _cp2.z = cp2.z;
  m.map( cp1.x, cp1.y, &_cp1.x, &_cp1.y );
  m.map( cp2.x, cp2.y, &_cp2.x, &_cp2.y );

  m_end1 = canvasToMixed( _cp1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  m_end2 = canvasToMixed( _cp2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );
  parametersChanged();
 }


//-------------------------------------------------------------//

void QSCArrow::setBox( const QSRectf& r, QSDrv *drv )
 {
  parametersChanging();
  // preserve z
  QSPt3f cp1 = mixedToCanvas( m_end1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  QSPt3f cp2 = mixedToCanvas( m_end2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );

  QSPt3f p1( r.pos.x, r.pos.y, cp1.z );
  QSPt3f p2( r.pos.x+r.size.x, r.pos.y+r.size.y, cp2.z );

  m_end1 = canvasToMixed( p1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  m_end2 = canvasToMixed( p2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );

  parametersChanged();
 }

//-------------------------------------------------------------//

QSRectf QSCArrow::box( QSDrv *drv )
 {
  QSPt3f cp1 = mixedToCanvas(m_end1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  QSPt3f cp2 = mixedToCanvas(m_end2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );
  return QSRectf( cp1.x, cp1.y, cp2.x-cp1.x, cp2.y-cp1.y );
 }

//-------------------------------------------------------------//

QSPt2f QSCArrow::rCenter( QSDrv *drv )
 {
  QSRectf r = box( drv );
  QSPt2f center( r.pos.x+r.size.x/2.0, r.pos.y+r.size.y/2.0 );
  return center;
 }

//-------------------------------------------------------------//

void QSCArrow::setEditMode( bool enabled )
 {
  m_visible = !enabled;
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginPos( const QSPt3f& pos )
 {
  SET_COBJECT_PROPERTY( m_end1, pos );
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginX( double x )
 {
  SET_COBJECT_PROPERTY( m_end1.x, x );
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginY( double y )
 {
   SET_COBJECT_PROPERTY( m_end1.y, y );
 }

//-------------------------------------------------------------//
	
void QSCArrow::setOriginZ( double z )
 {
  SET_COBJECT_PROPERTY( m_end1.z, z );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndPos( const QSPt3f& pos )
 {
  SET_COBJECT_PROPERTY( m_end2, pos );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndX( double x )
 {
  SET_COBJECT_PROPERTY( m_end2.x, x );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndY( double y )
 {
   SET_COBJECT_PROPERTY( m_end2.y, y );
 }

//-------------------------------------------------------------//
	
void QSCArrow::setEndZ( double z )
 {
  SET_COBJECT_PROPERTY( m_end2.z, z );
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginCoord( const QSPt3& coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis1, coordSystem )
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginCoordX( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis1.x, coordSystem )
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginCoordY( int coordSystem )	
 {
  SET_COBJECT_PROPERTY( m_axis1.y, coordSystem )
 }

//-------------------------------------------------------------//
  	
void QSCArrow::setOriginCoordZ( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis1.z, coordSystem )
 }

//-------------------------------------------------------------//

void QSCArrow::setEndCoord( const QSPt3& coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis2, coordSystem )
 }

//-------------------------------------------------------------//

void QSCArrow::setEndCoordX( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis2.x, coordSystem )
 }

//-------------------------------------------------------------//

void QSCArrow::setEndCoordY( int coordSystem )	
 {
  SET_COBJECT_PROPERTY( m_axis2.y, coordSystem )
 }

//-------------------------------------------------------------//
  	
void QSCArrow::setEndCoordZ( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis2.z, coordSystem )
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginArrow( const QSGArrow& arrow )
 {
  SET_COBJECT_PROPERTY( m_end1style, arrow );
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginArrowProperty( const QString& data )
 {
  QSGArrow new_arrow = toQSGArrow( data );
  setOriginArrow( new_arrow );
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginPoint( const QSGPoint& point )
 {
  SET_COBJECT_PROPERTY( m_end1point, point );
 }

//-------------------------------------------------------------//

void QSCArrow::setOriginPointProperty( const QString& data )
 {
  QSGPoint new_point = toQSGPoint( data );
  setOriginPoint( new_point );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndArrow( const QSGArrow& arrow )
 {
  SET_COBJECT_PROPERTY( m_end2style, arrow );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndArrowProperty( const QString& data )
 {
  QSGArrow new_arrow = toQSGArrow( data );
  setEndArrow( new_arrow );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndPoint( const QSGPoint& point )
 {
  SET_COBJECT_PROPERTY( m_end2point, point );
 }

//-------------------------------------------------------------//

void QSCArrow::setEndPointProperty( const QString& data )
 {
  QSGPoint new_point = toQSGPoint( data );
  setEndPoint( new_point );
 }

//-------------------------------------------------------------//

void QSCArrow::setLine( const QSGLine& line )
 {
  SET_COBJECT_PROPERTY( m_line, line );
 }

//-------------------------------------------------------------//

void QSCArrow::setLineProperty( const QString& data )
 {
  QSGLine new_line = toQSGLine( data );
  setLine( new_line );
 }

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//


QSCRect::QSCRect( QObject *parent )
:QSCObject( parent )
 {
  m_shadow_fill.style = QSGFill::Transparent;
  m_shadow_fill.color = QSGColor( 0, 0, 0 );
  m_shadow_pos.x = 5;
  m_shadow_pos.y = 5;
  m_end1.set( 0.1, 0.5, 0.0 );
  m_end2.set( 0.5, 0.1, 0.0 );
  m_ellipse   = false;
  m_axis1.set( QSAxes::normCoord, QSAxes::normCoord, QSAxes::normCoord );
  m_axis2.set( QSAxes::normCoord, QSAxes::normCoord, QSAxes::normCoord );	
 }

//-------------------------------------------------------------//

QSCRect::~QSCRect()
 {
 }

//-------------------------------------------------------------//

void QSCRect::draw( QSDrv *drv, bool, bool )
 {
  QSPt3f p1 = mixedToCanvas( m_end1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  QSPt3f p2 = mixedToCanvas( m_end2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );
  QSPt2f pos1 = QSPt2f( p1.x, p1.y );
  QSPt2f pos2 = QSPt2f( p2.x, p2.y );
  QSPt2f shad = QSPt2f(drv->toPixels(m_shadow_pos.x),drv->toPixels(m_shadow_pos.y));
	
  if ( m_shadow_fill.style != QSGFill::Transparent ) {
  	drv->setLine( QSGLine::invisibleLine );
  	drv->setFill( m_shadow_fill );
  	if ( m_ellipse ) drv->drawEllipse( pos1+shad, pos2+shad );
   		    else drv->drawRect( pos1+shad, pos2+shad );
     }

  drv->setFill( m_fill );
  drv->setLine( m_frame );
  if ( m_ellipse ) drv->drawEllipse( pos1, pos2 );
	      else drv->drawRect( pos1, pos2 );
  emit sigDrawEnds( this );
 }

//-------------------------------------------------------------//

QSRectf QSCRect::box( QSDrv *drv )
 {
  QSPt3f cp1 = mixedToCanvas( m_end1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  QSPt3f cp2 = mixedToCanvas( m_end2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );
  return QSRectf( cp1.x, cp1.y, cp2.x-cp1.x, cp2.y-cp1.y ).normalize();
 }


//-------------------------------------------------------------//

void QSCRect::setBox( const QSRectf& r, QSDrv *drv )
 {
  parametersChanging();
  // preserve a depth
  QSPt3f cp1 = mixedToCanvas( m_end1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  QSPt3f cp2 = mixedToCanvas( m_end2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );

  QSRectf rn = r.normalize();
  cp1.set( rn.pos.x, rn.pos.y, cp1.z );
  cp2.set( rn.pos.x+rn.size.x, rn.pos.y+rn.size.y, cp2.z );

  m_end1 = canvasToMixed( cp1, m_axis1.x, m_axis1.y, m_axis1.z, drv->dpi );
  m_end2 = canvasToMixed( cp2, m_axis2.x, m_axis2.y, m_axis2.z, drv->dpi );
  parametersChanged();
 }

//-------------------------------------------------------------//

bool QSCRect::isHit( const QSPt2f &p, QSDrv* drv )
 {
  QRegion r( box(drv).rect(), m_ellipse ? QRegion::Ellipse : QRegion::Rectangle );
  return r.contains( QPoint(int(p.x+0.5),int(p.y+0.5)) );
 }

//-------------------------------------------------------------//

void QSCRect::setEllipse( bool ellipse )
 {
  SET_COBJECT_PROPERTY( m_ellipse, ellipse );
 }

//-------------------------------------------------------------//

void QSCRect::setOriginPos( const QSPt3f& pos )
 {
  SET_COBJECT_PROPERTY( m_end1, pos );
 }

//-------------------------------------------------------------//

void QSCRect::setOriginX( double x )
 {
  SET_COBJECT_PROPERTY( m_end1.x, x );
 }

//-------------------------------------------------------------//

void QSCRect::setOriginY( double y )
 {
   SET_COBJECT_PROPERTY( m_end1.y, y );
 }

//-------------------------------------------------------------//
	
void QSCRect::setOriginZ( double z )
 {
  SET_COBJECT_PROPERTY( m_end1.z, z );
 }

//-------------------------------------------------------------//

void QSCRect::setEndPos( const QSPt3f& pos )
 {
  SET_COBJECT_PROPERTY( m_end2, pos );
 }

//-------------------------------------------------------------//

void QSCRect::setEndX( double x )
 {
  SET_COBJECT_PROPERTY( m_end2.x, x );
 }

//-------------------------------------------------------------//

void QSCRect::setEndY( double y )
 {
   SET_COBJECT_PROPERTY( m_end2.y, y );
 }

//-------------------------------------------------------------//
	
void QSCRect::setEndZ( double z )
 {
  SET_COBJECT_PROPERTY( m_end2.z, z );
 }

//-------------------------------------------------------------//

void QSCRect::setOriginCoord( const QSPt3& coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis1, coordSystem )
 }

//-------------------------------------------------------------//

void QSCRect::setOriginCoordX( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis1.x, coordSystem )
 }

//-------------------------------------------------------------//

void QSCRect::setOriginCoordY( int coordSystem )	
 {
  SET_COBJECT_PROPERTY( m_axis1.y, coordSystem )
 }

//-------------------------------------------------------------//
  	
void QSCRect::setOriginCoordZ( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis1.z, coordSystem )
 }

//-------------------------------------------------------------//

void QSCRect::setEndCoord( const QSPt3& coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis2, coordSystem )
 }

//-------------------------------------------------------------//

void QSCRect::setEndCoordX( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis2.x, coordSystem )
 }

//-------------------------------------------------------------//

void QSCRect::setEndCoordY( int coordSystem )	
 {
  SET_COBJECT_PROPERTY( m_axis2.y, coordSystem )
 }

//-------------------------------------------------------------//
  	
void QSCRect::setEndCoordZ( int coordSystem )
 {
  SET_COBJECT_PROPERTY( m_axis2.z, coordSystem )
 }

//-------------------------------------------------------------//

void QSCRect::setFill( const QSGFill& fill )
 {
  SET_COBJECT_PROPERTY( m_fill, fill );
 }

//-------------------------------------------------------------//

void QSCRect::setFillProperty( const QString &data )
 {
  QSGFill new_fill = toQSGFill(data);
  setFill( new_fill );
 }

//-------------------------------------------------------------//

void QSCRect::setFrame( const QSGLine& line )
 {
  SET_COBJECT_PROPERTY( m_frame, line );
 }

//-------------------------------------------------------------//

void QSCRect::setFrameProperty( const QString& data )
 {
  QSGLine new_line = toQSGLine(data);
  setFrame( new_line );
 }

//-------------------------------------------------------------//

void QSCRect::setShadowFill( const QSGFill& fill )
 {
  SET_COBJECT_PROPERTY( m_shadow_fill, fill );
 }

//-------------------------------------------------------------//

void QSCRect::setShadowFillProperty( const QString& data )
 {
  QSGFill new_shadow_fill = toQSGFill(data);
  setShadowFill( new_shadow_fill );
 }

//-------------------------------------------------------------//

void QSCRect::setShadowPos( const QSPt2& shift )
 {
  SET_COBJECT_PROPERTY( m_shadow_pos, shift );
 }

//-------------------------------------------------------------//

void QSCRect::setShadowPosX( int value )
 {
  SET_COBJECT_PROPERTY( m_shadow_pos.x, value );
 }

//-------------------------------------------------------------//

void QSCRect::setShadowPosY( int value )
 {
  SET_COBJECT_PROPERTY( m_shadow_pos.y, value );
 }

//-------------------------------------------------------------//
