/***************************************************************************
                                qsaxes2d.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QSAXES2D_H
#define QSAXES2D_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"qsaxes.h"
#include"qsprojection2d.h"

/**
  * \brief Ordinary XY axes
  *
  * @author Kamil Dobkowski
  */
class QSAxes2D : public QSAxes
 {
  Q_OBJECT
	Q_PROPERTY( int frameWidth READ frameWidth WRITE setFrameWidth )

  public:
      /**
        * Constructor.
        */
      QSAxes2D(QObject* parent=0, const char * name=0);
      /**
        * Destructor.
        */
     ~QSAxes2D();
     /**
       * Reimplemented.
       */
     virtual void stop();
     /**
       * Sets a width of the frame.
       */
     void setFrameWidth( int width );
     /**
       * Returns a frame width.
       */
     int frameWidth() const { return m_framew; }
     /**
       * Reimplemented
       */
     virtual void initMappings( QSDrv *drv );
    /**
       * From mixed type coordinates to canvas. Allows freely mixing of coordinate systems, but Z can't be normCoordinate
       */
     virtual QSPt3f mixedToCanvas( const QSPt3f& pos, CoordinateSystem in_coords[3], double dpi, QSAxis *xAxis, QSAxis *yAxis, QSAxis *zAxis ) const ;
     /**
       * From canvas to mixed coordinates. Allows freely mixing of coordinate systems, but Z can't be normCoordinate.
       */
     virtual QSPt3f canvasToMixed( const QSPt3f& pos, CoordinateSystem out_coords[3], double dpi, QSAxis *xAxis, QSAxis *yAxis, QSAxis *zAxis ) const ;
     /**
       * Reimplemented
       */
     virtual void paintPlot( QPainter *p, double dpi=72.0, bool blocking=true, bool transparent=true );
     /**
       * Reimplemented
       */
     virtual void drawPlot( QSDrv *drv, bool blocking=true, bool transparent=true );
     /**
       * Reimplemented
       */
     virtual QString posInfo( QSPt2f& pos );
     /**
       * Fill elements. See QSGraphicalData::setFill()
       */
     enum FillElement {
                RectFill  = 0,
                FrameFill
               };

     virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
     virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );
       	
     protected:
      /**
        * Reimplemented from @ref QSPlot::axisRangesCalculated .
        */
      void axisRangesCalculated();
      /**
        * Reimplemented
        */
      void allocRuntimeData();
      /**
        * Reimplemented
        */
      void freeRuntimeData();
      /**
        * Reimplemented
        */
      virtual void drawAxis( QSAxis *axis );
      /**
        * Reimplemented
        */
      virtual void drawGrid( QSAxis *axis, bool major );

     private:
      QSProjection2D t;
      int    m_framew;
      bool   m_is_graphics_active;
	struct axes2d_runtime_data;
      struct axes2d_runtime_data *d;
      void default_settings();
      void init_2dtr();
      void draw_axes();
      void draw_rect( const QSPt2f& p1, const QSPt2f& p2 );
      double ticlen( int axis, bool major );

   };

/**
  * \example demo2d.cpp
  *
  * Example of how to use QSAxes2D
  */
#endif

