/***************************************************************************
                             qsdrvopengl.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QSDRVOPENGL_H
#define QSDRVOPENGL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GL

#include "qsdrvqt.h"
#include <qgl.h>

class QPainter;
class QPixmap;
class QPicture;
class QSAxes3D;
class QSProjection3D;

/**
  * \brief OpenGL 3d graphics driver.
  *
  * Notice that it is suppesed to use only with QSAxes3D.and it uses Qt for drawing 2D, text etc.
  * @author Kamil Dobkowski
  */
class QSDrvOpenGL : public QSDrvQt
 {
  public:
         /**
           * Constructor.
           */
	 QSDrvOpenGL();
	 /**
	   * Destructor.
	   */
	virtual ~QSDrvOpenGL();
	/**
	  * Returns new copy of this driver with all settings set.
	  */
	virtual QSDrvOpenGL *copy();
	/**
	  * Copies all settings from another driver
	  */
	void copySettingsFrom( const QSDrvOpenGL *drv );
	 /**
	   * Enable/disable alpha.
	   */
	 void setAlpha( bool enabled );
	 /**
	   * Shade walls
	   */
         void setShadeWalls( bool enabled );
         /**
	   * Global transparency
	   */
         void setGlobalTransparency( unsigned char value );
         /**
	   * Mesh stoke auto-colors
	   */
         void setMeshAutoStroke( bool enabled );
         /**
	   * How mush mesh stroke is lighter than a mesh fill
	   */
         void setAutoStrokeLightness( int value );
	 /**
	   * Returns alpha setting.
	   */
	bool alpha() const { return m_alpha; }
	/**
	  * Returns shade walls setting
	  */
	bool shadeWalls() const { return m_shade_walls; }
	/**
	  * Returns global transparency
	  */
	int globalTransparency() const { return m_global_transparency; }
	/**
	  * Returns if mesh auto stroke colors is enabled
	  */
	bool meshAutoStroke() const { return m_auto_stroke; }
	/**
	  * Returns how much auto stroke is lighter than mesh fill color.
	  */
	int meshAutoStrokeLightness() const { return m_stroke_lightness; }
	/**
	  * Prepare driver
	  */
       	 void init( QSAxes3D *parent );
	/**
	  * Returns parent axes
	  */
	 QSAxes3D *parentAxes() const { return m_axes3; }
         virtual void setClipping( bool enabled );
         virtual void setCurrentElement( int category, int element );
         virtual CNormals cNormals() const;
         virtual CColors cColors() const;
         virtual COrdering cOrdering() const;
	 /**
	   * Sets a painter for this driver. If deletePainter is true, painter
	   * will be deleted in destructor. If p->device() isn't an external one,
	   * no world or view transformation of the painter are used.
	   */
	virtual void setDC( QPainter *p, double dpi = 72, bool deletePainter = false );
         virtual void startDrawing();
         virtual void stopDrawing();

         virtual void clearCanvas( const QSGFill& f, const QSPt2& pos, const QSPt2& size );
         virtual void drawPoly3( const QSPt3f pts[], int npoints,
                         const QSPt3f *nor, const QSGFill *col, const bool *edges = NULL, int edgeAutoColor = 0 );
         virtual void drawLine3( const QSPt3f& begin, const QSPt3f& end, const QSPt3f norm[2] );
         virtual void setFill( const QSGFill &f );
         virtual void setLine( const QSGLine &l );

  protected:
	 QSAxes3D     *m_axes3;
         QPainter     *m_opaint;
         QGLContext   *pgl;
         QPainter     *ppic;
         QPixmap      *pix;
         QPicture     *pic;
         QPointArray  *points;

         GLuint  plist;
         GLubyte color[4];
         GLubyte lcolor[4];

         bool axis_mode;
         bool m_alpha;
         bool m_shade_walls;
         bool m_auto_stroke;
         bool dpaint;
         int  m_global_transparency;
         int  trv;
         int  m_stroke_lightness;
         int  pasize;

         const QSProjection3D *t;
         void loadMatrix( const double m[4][4] );
         void get_qpainter_wmatrix( const QPainter *p, double m[4][4] );
         void glError();
 };

#endif // HAVE_GL
#endif




















