/***************************************************************************
                                qsprojection2d.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QSPROJECTION2D_H
#define QSPROJECTION2D_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"qsprojection.h"

/**
  * \brief Implementation of QSProjection for use in QSAxes2D.
  * @author Kamil Dobkowski
  */
class QSProjection2D : public QSProjection  {

  public:
     typedef double Matrix[3][3];
     Matrix T;
     Matrix IT;
    /**
      * constructor.
      */
     QSProjection2D();
    /**
      * destructor.
      */
    virtual ~QSProjection2D();
    /**
      * Makes 'matrix' a unity matrix.
      */
    static void matrixI( Matrix m );
    /**
      * Matrix multiplication : 'A = B*A'
      */
    static void multiply( Matrix A, Matrix B );
    /**
      * Copies the given matrix : 'dst = src' .
      */
    static void copy( Matrix dst, const Matrix src );
    /**
      * Apply shift ( translate ).
      */
    static void applyT( Matrix m, double dx, double dy );
    /**
      * Apply scaling.
      */
    static void applyS( Matrix m, double sx, double sy );
    /**
      *  Calculates inversion of 'm'.
      */
    static void inv( Matrix result, const Matrix m );
    /**
      * Apply viewport transformation.
      */
    static void applyViewport( Matrix m, double x, double y, double w, double h );
    /**
      *  Maps the X to the screen coordinates.
      */
    double world2DToCanvasX( double x ) const;
    /**
      * Maps the Y to the screen coordinates.
      */
    double world2DToCanvasY( double y ) const;
    /**
      * Maps the Z to the screen coordinates.
      */
    double world2DToCanvasZ( double z ) const;
    /**
      * Maps the X from screen coordinates
      */
    double canvasXToWorld2D( double x ) const;
    /**
      * Maps the Z from screen coordinates
      */
    double canvasYToWorld2D( double y ) const;
    /**
      * Maps the Z from screen coordinates
      */
    double canvasZToWorld2D( double z ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt2f world2DToCanvas( const QSPt2f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt3f world2DToCanvas3( const QSPt2f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt2f world3DToCanvas( const QSPt3f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt3f world3DToCanvas3( const QSPt3f& p ) const;
     /**
       * Reimplemented.
       */
    virtual QSPt3f canvas3ToWorld3D( const QSPt3f &p ) const;
    /**
      * Reimplemented. Applies transformation 'm' to 'p'.
      */
    virtual QSPt2f worldTransformation( const Matrix m, const QSPt2f& p ) const;

    void setClipRect( double x1, double y1, double x2, double y2 );
    void getClipRect( double *x1, double *y1, double *x2, double *y2 ) const;

   private:
     // clip rectangle
     QSPt2f m_cmin;
     QSPt2f m_cmax;
  };


#endif



































