/***************************************************************************
                                qsprojection3d.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef QSPROJECTION3D_H
#define QSPROJECTION3D_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include"qsprojection.h"

/**
  * \brief Implementation of  QSProjection for use in QSAxes3D
  * @author Kamil Dobkowski
  */
class QSProjection3D : public QSProjection {

    public:

        typedef double Matrix[4][4];
        /**
          * The modelview matrix;.
          *
          */
        Matrix M;
        /**
          * The projection matrix.
          */
        Matrix P;
        /**
          * The transformation matrix.
          * t = @ref QSProjection3D::S * @ref QSProjection3D::P * @ref QSProjection3D::M .
          */
        Matrix T;
        /**
          * The light vector.
          */
        QSPt3f lvector;
        /**
          * The direction vector. Valid only if a perspective is off.
	  * ( world coordinates )
          */
        QSPt3f dvector;
        /**
          * Eye ( focuspoint ) position in world coordinates. Valid only
          * if perspective is on.
          */
        QSPt3f eye;
       /**
         * Box minimum ( box + wall thickness ) in world coordinates.
         *
         */
       QSPt3f bmin;
       /**
         * Box maximum ( box + wall thickness ) in world coordinates.
         */
       QSPt3f bmax;
        /**
          * constructor.
          */
        QSProjection3D();
        /**
          * destuctor.
          */
       virtual ~QSProjection3D();
       static void matrix_to_stdout( const Matrix& m );
      /**
        * Makes 'matrix' the unity matrix.
        */
      static void matrixI( Matrix m );
      /**
        * Matrix multiplication : 'A = B*A'
        */
      static void multiply( Matrix A, const Matrix B );
      /**
        * Calculates inversion of the given matrix.
        */
      static void inv( Matrix result, const Matrix m );
     /**
       * Copies the given matrix : 'dst = src' .
       */
      static void copy( Matrix dst, const Matrix src );
      /**
        * Shift ( translate ).
        */
      static void applyT( Matrix m, double dx, double dy, double dz );
      /**
        * Scale .
        */
      static void applyS( Matrix m, double sx, double sy, double sz );
      /**
        * Rotation.
        */
      static void applyR( Matrix m, double alfay, double alfax, double alfaz = 0.0 );
      /**
        * Apply an othogonal projection.
        */
      static void ortho( Matrix m, double l, double r, double b, double t, double n, double f );
      /**
        * Apply a perspective projection.
        */
      static void frustum( Matrix m, double l, double r, double b, double t, double n, double f );
      /**
        * Apply a viewport transformation.
        */
      static void applyViewport( Matrix m, double x, double y, double w, double h, double n = 0.0, double f = 1.0 );
      /**
        * Applies any transformation, given in 'T' to 'p'.
        */
      static QSPt3f worldTransformation( const Matrix T, const QSPt3f &p );


      void setProjection( double  l, double  r, double  b, double  t, double  n, double  f, bool  perspective );
      void getProjection( double *l, double *r, double *b, double *t, double *n, double *f, bool *perspective ) const;
      void setViewport( double  x, double  y, double  w, double  h, double  n = 0.0, double  f = 0.0 );
      void getViewport( double *x, double *y, double *w, double *h, double *n, double *f  ) const;
      /**
        * Fit the [(0,0,0) (1,1,1)] cube to the screen area.
        * As result makes changes to @ref QSProjection3D::S matrix.
        * @see QSProjection3D::M
        * @see QSProjection3D::P
        */
      void fit( Matrix& S );
      /**
        * @see QSProjection3D::T
        */
      virtual QSPt2f middle() const;
      /**
        * Returns a point from [(0, 0, 0) ( 1, 1, 1 )] cube, which has the greatest
        * z coordinate and all its three neighbourng walls are visible.
        * @see QSProjection3D::T
        */
      virtual QSPt3f furthest() const;
      /**
        * Returns a point opposite to @ref QSProjection3D::furthest .
        */
      QSPt3f nearest() const;
      /**
        * Returns a point which lies at the left to the @ref QSProjection3D::furthest on the screen .
        */
      QSPt3f left() const;
      /**
        * Returns an opposite point to @ref QSProjection3D::left .
        */
      QSPt3f right() const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt2f world2DToCanvas( const QSPt2f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt3f world2DToCanvas3( const QSPt2f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt2f world3DToCanvas( const QSPt3f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt3f world3DToCanvas3( const QSPt3f& p ) const;
     /**
       * Reimplemented. Maps the point to the screen coordinates.
       */
    virtual QSPt3f canvas3ToWorld3D( const QSPt3f &p ) const;

     private:

        bool m_perspective;

        double m_proj[6];
        double m_view[6];

       static void ludcmp( Matrix a, int indx[4], double *d );
       static void lubksb( Matrix a, int indx[4], double b[] );


     };

#endif










