/***************************************************************************
                              qsserializable.h
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSSERIALIZABLE_H
#define QSSERIALIZABLE_H

#include<qdatastream.h>

class QObject;
class QSSerializable;
/**
  * \brief Object that creates and saves serializable objects.
  * @author Kamil Dobkowski
  */
class QSObjectFactory
 {
  public:
	enum Flags {
		CopyAllData = 1<<0
		};
	/**
	  * Constructor
	  */
	QSObjectFactory();
	/**
          * Destructor
          */
	virtual ~QSObjectFactory();
	/**
          * Loads objects from a stream. It loads a type of object ( eg. class name ), creates it, and
	  * calls QSSerializable::loadStateFromStream()
          */
	virtual QSSerializable *loadObjectFromStream( QDataStream& stream, QObject *parent=NULL ) = 0;
	/**
          * Save object to stream. It save a type of object ( eg. class name ) to the stream and calls
	  * QSSerializable::saveStateToStream().
          */
	virtual void saveObjectToStream( QSSerializable *object, QDataStream& stream ) = 0;
        /**
          * Sets flags
          */
	void setFlags( int flags );
	/**
          * Returns flags.
          */
	int flags() const { return m_flags; }

  protected:
	int m_flags;
 };

//---------------------------------------------------------------------------------------------------//

/**
  *\brief Object which can load or save its state into a stream.
  *@author Kamil Dobkowski
  */
class QSSerializable
  {
  public:
	/**
          * Constructor
          */
	QSSerializable();
	/**
          * Destructor
	  */
	virtual ~QSSerializable();
	/**
          * Loads state from a stream. You can load child objects from the stream using QSObjectFactory::loadObjectFromStream()
          */
	virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
	/**
          * Saves state to a stream. You can save child objects to the stream using QSObjectFactory::saveObjectToStream()
          */
	virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );
	};

#endif
