#ifndef LINT_H
#define LINT_H


#define LINT_SINGLE_SIZE 8
#define LINT_BIT_COUNT 1024

typedef unsigned char LintSingle;
typedef int LintDouble;

#define LINT_SINGLE_MASK ((1<<LINT_SINGLE_SIZE)-1)
#define LINT_ARRAY_COUNT (LINT_BIT_COUNT/LINT_SINGLE_SIZE)


typedef struct{
 LintSingle data[LINT_ARRAY_COUNT];
 } Lint;

typedef enum {  
 EXP_MUL, EXP_DIV, EXP_MOD,
 EXP_ADD, EXP_SUB,
 EXP_SL,  EXP_SR,
 EXP_XOR,
 EXP_AND,
 EXP_OR
 } LintSymbolType;




Lint lint_new(long long value);
long long lint_to_longlong(Lint value);
int lint_compare (Lint a, Lint b);
Lint lint_operate (Lint a, Lint b, LintSymbolType type);


#endif
