#ifndef CALLBACKS_H
#define CALLBACKS_H
#include "view.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <stdio.h>           

#define uchar unsigned char
#define REFRESH_PERIOD 200

typedef struct {        // custom run data
int    steps;
uchar  command;
} custom_start;



void callback_button_load (GtkButton*, gpointer);
void callback_load_isa (GtkMenuItem* menuitem, gpointer newvalue);
void callback_load_binary_address(GtkEntry*, gpointer);
void callback_load_isa_binary(GtkButton* button, gpointer entry);
void callback_load_binary(GtkButton*, gpointer);
void callback_button_compile (GtkButton*, gpointer);
void callback_button_ok_file(GtkButton*, gpointer);
void callback_fpgaload (GtkButton*, gpointer);
void callback_fpgaupdate (GtkButton*, gpointer);
void callback_window_raise (GtkObject*);
void callback_button_start (GtkButton*, gpointer);
void callback_button_start_custom(GtkButton*,gpointer);
void callback_button_stop (GtkButton*, gpointer);
void callback_button_walk (GtkButton*, gpointer);
void callback_button_continue (GtkButton*, gpointer);
void callback_button_ping (GtkButton*, gpointer);
void callback_start_toggle (GtkToggleButton*, gpointer);
void callback_rtf_toggle (GtkToggleButton*, gpointer);
void callback_refresh_toggle (GtkToggleButton*, gpointer);
void callback_button_reset (GtkButton*, gpointer);
void callback_global_refresh(void);
void callback_memory_refresh(void);
void callback_main_progress_bar_update(gfloat);
void callback_step_number (GtkEditable*, gpointer);
void callback_memwindow_length (GtkMenuItem*, gpointer);
void callback_memwindow_isa (GtkMenuItem*, gpointer);
void callback_memwindow_listsize (GtkEditable*, gpointer);
void callback_memwindow_no (GtkMenuItem*, gpointer);
void callback_memwindow_ascii_toggle (GtkToggleButton*, gpointer);
void callback_memwindow_dis_toggle (GtkToggleButton*, gpointer);
void callback_memwindow_address (GtkEditable*, gpointer);
void callback_memwindow_hex (GtkEditable*, gpointer);
void callback_memwindow_ascii (GtkEditable*, gpointer);
void callback_memwindow_dis (GtkEditable*, gpointer);
void callback_memwindow_clist (GtkCList*, gint, gint, GdkEventButton*,gpointer);
void callback_memwindow_scrollmove(GtkAdjustment*,gpointer);
gboolean callback_memwindow_scrollrelease(GtkWidget*,gpointer,gpointer);
void callback_regwindow_hex (GtkEditable*, gpointer);
void callback_regwindow_clist (GtkCList*, gint, gint, GdkEventButton*,gpointer);
gint callback_update_comms(gpointer);
gint callback_updateall(gpointer);
gint callback_walk(gpointer);
gint callback_updateregwindow(gpointer);
gint callback_updatememwindow(gpointer);
gint callback_console_update(gpointer data, gint source,
                                 GdkInputCondition condition);
void callback_comms (GtkEditable*, gpointer);                             
gint callback_terminal_keysnoop(GtkWidget *grab_widget, GdkEventKey *event, gpointer comms);
void callback_clear_text (gpointer);
void callback_main_quit(gpointer ignore, gpointer ignore2);
void callback_crash(void);

GList* view_load_isa;
int compile_communication[2];
int compile_communication[2];
FILE *view_console_port;
int child_dead;
#endif
