
/***************************************************************************
                          emoticoncollection.cpp  -  description
                             -------------------
    begin                : Mon Apr 15 2002
    copyright            : (C) 2003 by Michael Curtis
    email                : mdcurtis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/

#include "emoticoncollection.h"

#include <qcolor.h>
#include <qptrlist.h>
#include <qregexp.h>

#include <kdebug.h>
#include <klocale.h>

#include "emoticon.h"

// Initialize the instance to zero
EmoticonCollection* EmoticonCollection::instance_(0);


// The constructor
EmoticonCollection::EmoticonCollection()
 : QPtrList<Emoticon>()
{
  Emoticon *emoticon;

  clear();

  // MSN6 Smiley definitions added by Mokoshi

  // put some emoticons in our collection
  emoticon = new Emoticon( ":\\)",     "regular" );
  emoticon->addText( ":-\\)" );
  emoticon->setTooltip( i18n( "Smile" ) );
  append( emoticon );

  emoticon = new Emoticon( ";\\)",     "wink" );
  emoticon->addText( ";-\\)" );
  emoticon->setTooltip( i18n( "Wink" ) );
  append( emoticon );

  emoticon = new Emoticon( ":P",        "tongue" );
  emoticon->addText( ":p"  );
  emoticon->addText( ":-P" );
  emoticon->addText( ":-p" );
  emoticon->setTooltip( i18n( "Tongue out" ) );
  append( emoticon );

  emoticon = new Emoticon( ":D",        "teeth" );
  emoticon->addText( ":d"      );
  emoticon->addText( ":-D"     );
  emoticon->addText( ":-d"     );
  emoticon->addText( ":>"      );
  emoticon->addText( ":->"     );
  emoticon->addText( ":&gt;"   );
  emoticon->addText( ":-&gt;"  );
  emoticon->setTooltip( i18n( "Big smile" ) );
  append( emoticon );

  emoticon = new Emoticon( ":\\(",     "sad" );
  emoticon->addText( ":-\\("  );
  emoticon->addText( ":<"     );
  emoticon->addText( ":-<"    );
  emoticon->addText( ":&lt;"  );
  emoticon->addText( ":-&lt;" );
  emoticon->setTooltip( i18n( "Sad" ) );
  append( emoticon );

  emoticon = new Emoticon( ":'\\(",     "cry" );
  emoticon->setTooltip( i18n( "Crying" ) );
  append( emoticon );

  emoticon = new Emoticon( ":@",       "angry" );
  emoticon->addText( ":-@" );
  emoticon->setTooltip( i18n( "Angry" ) );
  append( emoticon );

  emoticon = new Emoticon( ":S",        "confused" );
  emoticon->addText( ":s"  );
  emoticon->addText( ":-S" );
  emoticon->addText( ":-s" );
  emoticon->setTooltip( i18n( "Confused" ) );
  append( emoticon );

  emoticon = new Emoticon( ":\\$",     "embarrassed" );
  emoticon->addText( ":-\\$" );
  emoticon->setTooltip( i18n( "Embarrassed" ) );
  append( emoticon );

  emoticon = new Emoticon( ":\\|",     "ugly" );
  emoticon->addText( ":-\\|" );
  emoticon->setTooltip( i18n( "Disappointed" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(H\\)",   "shade" );
  emoticon->addText( "\\(h\\)" );
  emoticon->setTooltip( i18n( "Hot" ) );
  append( emoticon );

  emoticon = new Emoticon( "8o\\|", "baringteeth" );
  emoticon->setTooltip( i18n( "Baring teeth" ) );
  append( emoticon );

  emoticon = new Emoticon( "8-\\|", "nerd" );
  emoticon->setTooltip( i18n( "Nerd" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\+o\\(", "sick" );
  emoticon->setTooltip( i18n( "Sick" ) );
  append( emoticon );

  emoticon = new Emoticon( ":O",        "omg" );
  emoticon->addText( ":o"  );
  emoticon->addText( ":-O" );
  emoticon->addText( ":-o" );
  emoticon->setTooltip( i18n( "Surprised" ) );
  append( emoticon );

  emoticon = new Emoticon( "<:o\\)",   "party" );
  emoticon->addText( "&lt;:o\\)" );
  emoticon->setTooltip( i18n( "Party" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\|-\\)", "sleepy" );
  emoticon->setTooltip( i18n( "Sleepy" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\*-\\)", "thinking" );
  emoticon->setTooltip( i18n( "Thinking" ) );
  append( emoticon );

  emoticon = new Emoticon( ":-\\#", "sshh" );
  emoticon->setTooltip( i18n( "Don't tell anyone" ) );
  append( emoticon );

  emoticon = new Emoticon( ":-\\*", "secret" );
  emoticon->setTooltip( i18n( "Secret telling" ) );
  append( emoticon );

  emoticon = new Emoticon( "8-\\)", "eyeroll" );
  emoticon->setTooltip( i18n( "Eye-rolling" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\^o\\)", "sarcastic" );
  emoticon->setTooltip( i18n( "Sarcastic" ) );
  append( emoticon );

  emoticon =  new Emoticon( ":\\^\\)", "huh" );
  emoticon->setTooltip( i18n( "I don't know" ) );
  append( emoticon );

  append( new Emoticon( "\\|-\\)", "unhappy" ) );
  emoticon->setTooltip( i18n( "Unhappy" ) );


  emoticon = new Emoticon( "\\(brb\\)", "brb" );
  emoticon->setTooltip( i18n( "Be right back" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(A\\)",   "angel" );
  emoticon->addText( "\\(a\\)" );
  emoticon->setTooltip( i18n( "Angel" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\{\\)", "dude_hug" );
  emoticon->setTooltip( i18n( "Left hug" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(Z\\)",   "boy" );
  emoticon->addText( "\\(z\\)" );
  emoticon->setTooltip( i18n( "Boy" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(L\\)",   "love" );
  emoticon->addText( "\\(l\\)" );
  emoticon->setTooltip( i18n( "Red heart" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(F\\)",   "rose" );
  emoticon->addText( "\\(f\\)" );
  emoticon->setTooltip( i18n( "Red rose" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(Y\\)",   "thumbs_up" );
  emoticon->addText( "\\(y\\)" );
  emoticon->setTooltip( i18n( "Thumby up" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(&\\)", "dog");
  emoticon->addText( "\\(&amp;\\)" );
  emoticon->setTooltip( i18n( "Dog face" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\#\\)", "sun" );
  emoticon->setTooltip( i18n( "Sun" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(6\\)",   "devil" );
  emoticon->setTooltip( i18n( "Devil" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\}\\)", "girl_hug" );
  emoticon->setTooltip( i18n( "Right hug" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(X\\)",   "girl" );
  emoticon->addText( "\\(x\\)" );
  emoticon->setTooltip( i18n( "Girl" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(U\\)",   "unlove" );
  emoticon->addText( "\\(u\\)" );
  emoticon->setTooltip( i18n( "Broken heart" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(W\\)",   "wilted_rose" );
  emoticon->addText( "\\(w\\)" );
  emoticon->setTooltip( i18n( "Wilted rose" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(N\\)",   "thumbs_down" );
  emoticon->addText( "\\(n\\)" );
  emoticon->setTooltip( i18n( "Thumbs down" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(@\\)", "cat" );
  emoticon->setTooltip( i18n( "Cat face" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(S\\)", "moon" );
  emoticon->setTooltip( i18n( "Sleeping half-moon" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(K\\)",   "kiss" );
  emoticon->addText( "\\(k\\)" );
  emoticon->setTooltip( i18n( "Red lips" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(h5\\)", "highfive" );
  emoticon->setTooltip( i18n( "Clapping" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(yn\\)", "fingerscrossed" );
  emoticon->setTooltip( i18n( "Crossed fingers" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(au\\)", "automobile" );
  emoticon->setTooltip( i18n( "Auto" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(ap\\)", "airplane" );
  emoticon->setTooltip( i18n( "Airplane" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(tu\\)", "turtle" );
  emoticon->setTooltip( i18n( "Turtle" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(sn\\)", "snail" );
  emoticon->setTooltip( i18n( "Snail" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(bah\\)", "sheep" );
  emoticon->setTooltip( i18n( "Black sheep" ) );
  append( emoticon );

  emoticon = new Emoticon( ":\\[",     "bat" );
  emoticon->addText( ":-\\[" );
  emoticon->setTooltip( i18n( "Vampire bat" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(pi\\)", "pizza" );
  emoticon->setTooltip( i18n( "Pizza" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(B\\)",   "beer" );
  emoticon->addText( "\\(b\\)" );
  emoticon->setTooltip( i18n( "Beer mug" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(D\\)",   "cocktail" );
  emoticon->addText( "\\(d\\)" );
  emoticon->setTooltip( i18n( "Martini glass" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(C\\)",   "cup" );
  emoticon->addText( "\\(c\\)" );
  emoticon->setTooltip( i18n( "Coffee cup" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\^\\)", "cake" );
  emoticon->setTooltip( i18n( "Birthday cake" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(pl\\)", "plate" );
  emoticon->setTooltip( i18n( "Plate" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\|\\|\\)", "bowl" );
  emoticon->setTooltip( i18n( "Bowl" ) );
  append( emoticon );

  emoticon =  new Emoticon( "\\(\\*\\)", "star" );
  emoticon->setTooltip( i18n( "Star" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(R\\)",   "rainbow" );
  emoticon->addText( "\\(r\\)" );
  emoticon->setTooltip( i18n( "Rainbow" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(st\\)", "storm" );
  emoticon->setTooltip( i18n( "Stormy cloud" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(li\\)", "lightning" );
  emoticon->setTooltip( i18n( "Lightning" ) );
  append( emoticon );

  emoticon =  new Emoticon( "\\(um\\)", "umbrella" );
  emoticon->setTooltip( i18n( "Umbrella" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(ip\\)", "island" );
  emoticon->setTooltip( i18n( "Island with a palm tree" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(T\\)",   "phone" );
  emoticon->addText( "\\(t\\)" );
  emoticon->setTooltip( i18n( "Telephone receiver" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(mp\\)", "mobilephone" );
  emoticon->setTooltip( i18n( "Mobile Phone" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(E\\)", "envelope" );
  emoticon->setTooltip( i18n( "Email" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(O\\)",   "clock" );
  emoticon->addText( "\\(o\\)" );
  emoticon->setTooltip( i18n( "Clock" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(P\\)",   "camera" );
  emoticon->addText( "\\(p\\)" );
  emoticon->setTooltip( i18n( "Camera" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\~\\)",   "film" );
  emoticon->setTooltip( i18n( "Filmstrip" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(8\\)",   "note" );
  emoticon->setTooltip( i18n( "Note" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\%\\)", "handcuffs" );
  emoticon->setTooltip( i18n( "Handcuffs" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(mo\\)", "money" );
  emoticon->setTooltip( i18n( "Money" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(I\\)",   "lightbulb" );
  emoticon->addText( "\\(i\\)" );
  emoticon->setTooltip( i18n( "Light bulb" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(ci\\)", "cigarette" );
  emoticon->setTooltip( i18n( "Cigarrette" ) );
  append( emoticon  );

  emoticon = new Emoticon( "\\(so\\)", "soccer" );
  emoticon->setTooltip( i18n( "Soccer ball" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(G\\)",   "present" );
  emoticon->addText( "\\(g\\)" );
  emoticon->setTooltip( i18n( "Gift with a bow" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(xx\\)", "gameconsole" );
  emoticon->setTooltip( i18n( "X-Box" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(co\\)", "computer" );
  emoticon->setTooltip( i18n( "Computer" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(\\?\\)",   "asl" );
  emoticon->setTooltip( i18n( "ASL (age, sex, location)" ) );
  append( emoticon );

  emoticon = new Emoticon( "\\(M\\)",   "messenger" );
  emoticon->addText( "\\(m\\)" );
  emoticon->setTooltip( i18n( "KMess Icon" ) );
  append( emoticon );
}



// The destructor
EmoticonCollection::~EmoticonCollection()
{
}



// Delete the instance of the emoticon collection
void EmoticonCollection::destroy()
{
  delete instance_;
  instance_ = 0;
}


// Return a singleton instance of the emoticon collection
EmoticonCollection* EmoticonCollection::instance()
{
  // If the instance is null, create a new emoticon collection and return that.
  if ( instance_ == 0 )
  {
    instance_ = new EmoticonCollection();
  }
  return instance_;
}



// Replace the emoticons in the text with the urls to the emoticon pngs.
void EmoticonCollection::parseEmoticons( QString &text, bool small )
{
  Emoticon *emoticon;

  // parse the emoticons in reverse order, as they get more complicated as they
  //  go along, therefore this avoids complicated emoticons clashing with
  //  simple ones
  for ( emoticon = last(); emoticon; emoticon = prev() )
  {
    if ( emoticon->isValid() )
    {
      text = text.replace( QRegExp( emoticon->getPattern() ),
                           emoticon->getHtml( small ) );
    }
  }
}



