/***************************************************************************
                          proxywidget.cpp  -  description
                             -------------------
    begin                : 03-08-2004
    copyright            : (C) 2004 by Madelman
    email                : madelman@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEWIDGET_H
#define IMAGEWIDGET_H


#include "imagewidgetinterface.h"
#include "../account.h"

#include <qstring.h>
#include <qpixmap.h>


class ImageWidget : public ImageWidgetInterface
{
  Q_OBJECT

  public:
    ImageWidget( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~ImageWidget();
    void loadSettings( Account *account );
    void saveSettings( Account *account );

  public slots:
    void selectImage();
    void showImageToggled(bool state);
    void useDefaultToggled(bool state);

  private:
    // The handle of the account
    QString myHandle_;
    // The image file of the account
    QString imageFile_;
    // The location for the custom image.
    QString tempImageFile_;
    // Do we have a custom image or not?
    bool    hasTempImage_;
    // The pixmap for the default kmess icon
    QPixmap defaultPixmap_;
    // The pixmap for the custom user icon
    QPixmap customPixmap_;
};

#endif // IMAGEWIDGET_H
