/***************************************************************************
                          kmesstest.cpp  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmesstest.h"

#include <math.h>
#include <stdlib.h>

#include <qlistview.h>
#include <qregexp.h>
#include <qfile.h>
#include <qimage.h>
#include <qcstring.h>

#include <kdebug.h>
#include <kapplication.h>

#include "settings/settingsdialog.h"
#include "network/msnnotificationconnection.h"
#include "network/msnswitchboardconnection.h"
#include "contact/contactbase.h"
#include "contact/contactlist.h"
#include "contact/group.h"
#include "currentaccount.h"
#include "emoticonmanager.h"
#include "kmess.h"
#include "kmessview.h"
#include "chat/chatwindow.h"
#include "chat/contactsidebar.h"
#include "chat/xsltransformation.h"
#include "nowlisteningclient.h"
#include "dialogs/transferwindow.h"
#include "dialogs/transferentryinterface.h"
#include "dialogs/transferentry.h"

#include "network/soap/httpsoapconnection.h"
#include "network/soap/soapmessage.h"
#include "network/soap/msnappdirectoryservice.h"

#include "notification/passivepopupinterface.h"
#include "notification/notificationcontactstatus.h"
// #include "network/upnp/manager.h"

// The constructor
KMessTest::KMessTest(KMess *kmess)
 : QObject()
 , kmess_(kmess)
{
}



// The destructor
KMessTest::~KMessTest()
{
  kdDebug() << "KMessTest DESTROYED" << endl;
}


#ifdef KMESSTEST

// The main testing function
void KMessTest::test()
{
  kdDebug() << "----------------------------------------" << endl << endl;
//   testTransferWindow();
//   testChatWindow();
//   testNotificationConnection();
//   testContactListWithNotificationConnection();
//   testConnect();
//   testSettings();
//   testSwitchboardConnection();
//   testNotifications();
//   testNowListening();
//   testSoapConnection();
//   testUpnpConnection();
//   testXslTransformation();
  kdDebug()  << endl << "----------------------------------------" << endl;

  // Close the application
}

void KMessTest::testTransferWindow()
{
  int id;
  KIconLoader *loader = KGlobal::iconLoader();
  TransferWindow *instance = TransferWindow::getInstance();

  id = instance->addEntry( "Filename1", 1234567890, true, QImage( loader->iconPath( "add", 48, false ) ) );
  kdDebug() << "Added ID: " << id << endl;

  id = instance->addEntry( "Filename2", 34567890, false, QImage( loader->iconPath( "remove", 48, false ) ) );
  kdDebug() << "Added ID: " << id << endl;

  id = instance->addEntry( "Filename3", 567890, true );
  kdDebug() << "Added ID: " << id << endl;

//   TransferWindow::destroy();
}


void KMessTest::testChatWindow()
{
  EmoticonManager::instance()->connected();
  ChatWindow *chatWindow = new ChatWindow();
  chatWindow->initialize("none");
  chatWindow->contactSidebar_->contactJoined("contact1@kmess.org", QString::null);
  chatWindow->contactSidebar_->contactJoined("contact2@kmess.org", QString::null);
  MsnSwitchboardConnection *sb = new MsnSwitchboardConnection();
  chatWindow->setSwitchboardConnection( sb );
  chatWindow->show();
}

void KMessTest::testNotifications()
{
  kdDebug() << "PassivePopup: Testing..." << endl;

  NotificationContactStatus  *cs = new NotificationContactStatus( kmess_->notificationManager_ );
  Contact *contact1 = new Contact( "gni", "Test!", 0, "0", "235");
  Contact *contact2 = new Contact( "dfg", "// Notify the user about this cationContactOnline( kmess_->notificatievent (a new email has arrived)      void NotificationNewEmail::notify( QString sender, QString subject, bool inInbox, QString command, QString folder, QString url )", 0, "0", "551");
  Contact *contact3 = new Contact( "ehb", "Status Contact", 0, "0", "745");

  contact1->setStatus( "NLN" );
  contact2->setStatus( "FLN" );
  contact3->setStatus( "BSY" );

  cs->notify( contact1, true );
  cs->notify( contact2, true );
  cs->notify( contact3, true );
}

void KMessTest::testNowListening()
{
  NowListeningClient *client = new NowListeningClient();
  client->setEnabled( true );
}

void KMessTest::testNotificationConnection()                { }
void KMessTest::testContactListWithNotificationConnection() { }
void KMessTest::testConnect()                               { }
void KMessTest::testSettings()                              { }
void KMessTest::testSwitchboardConnection()                 { }



void KMessTest::testSoapConnection()
{
  MsnAppDirectoryService *appDir = new MsnAppDirectoryService();
  appDir->queryServiceList( MsnAppDirectoryService::GAMES );

//   QString xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>"
//       "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">"
//       "<soap:Header>"
//       "<PassportCookie xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">"
//       "<t> Removed for security reasons </t>"
//       "<p> Removed for security reasons </p>"
//       "</PassportCookie>"
//       "</soap:Header>"
//       "<soap:Body>"
//       "<GetMessage xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">"
//       "<messageId>MSG1132093467.11</messageId>"
//       "<alsoMarkAsRead>false</alsoMarkAsRead>"
//       "</GetMessage>"
//       "</soap:Body>"
//       "</soap:Envelope>";
// 
//   HttpSoapConnection *soap = new HttpSoapConnection("http://localhost:81/index.xml");
//   soap->sendRequest("http://www.hotmail.msn.com/ws/2004/09/oim/rsi/GetMessage", xml);
}



void KMessTest::testUpnpConnection()
{
//  UPnP::Manager *manager = UPnP::Manager::instance();
}


void KMessTest::testXslTransformation()
{
  // A simple test using XSL/XML data of the KMess website
  QString wwwRoot = "/srv/www/vhosts/kmess/htdocs";

  // Load XSL
  XslTransformation xsl;
  xsl.setStylesheet( wwwRoot + "/resources/xsl/kmess.xsl" );

  // Open XML
  QFile file( wwwRoot + "/index.xml" );
  bool open = file.open(IO_ReadOnly);
  if(! open)
  {
    kdWarning() << "Could not open file: " << file.name() << endl;
  }

  // Load XML
  QByteArray fileData = file.readAll();
  QString xml = QString::fromUtf8(fileData.data(), fileData.size());
  file.close();

  // Transform XML
  kdDebug() << "XSL transformation result:" << endl;
  kdDebug() << xsl.convertXmlString(xml);
}



#endif  // KMESSTEST


#include "kmesstest.moc"
