/***************************************************************************
                          webcamtransferp2p.cpp -  description
                             -------------------
    begin                : Sun Aug 7 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "webcamtransferp2p.h"

#include "../mimemessage.h"

#include "../../kmessdebug.h"

#include <kmdcodec.h>
#include <klocale.h>


/**
 * Constructor
 *
 * @param  applicationList  The shared sources for the contact.
 */
WebcamTransferP2P::WebcamTransferP2P(ApplicationList *applicationList)
: P2PApplication(applicationList)
{
  setApplicationType( ChatMessage::TYPE_APPLICATION_WEBCAM );
}


/* *
 * Constructor
 *
 * @param  applicationList  The shared sources for the contact.
 */
/*
WebcamTransferP2P::WebcamTransferP2P(const QString &contactHandle, ...)
: P2PApplication(contactHandle)
{
}
*/


/**
 * Destructor
 */
WebcamTransferP2P::~WebcamTransferP2P()
{
}



/**
 * Step one of a contact-started chat: the contact invites the user
 *
 * @param  message  The invitation message
 */
void WebcamTransferP2P::contactStarted1_ContactInvitesUser(const MimeMessage & /*message*/)
{
#ifdef KMESSDEBUG_WEBAPPLICATION_P2P
  kdDebug() << "WebcamTransferP2P - contactStarted1_ContactInvitesUser" << endl;
#endif

#if 0
  QString  appID   = message.getValue("AppID");
  QString  eufGuid = message.getValue("EUF-GUID");
  QString  context = message.getValue("Context");

  // Parse the context
  context += "===="; // Make sure the base64 encoded string is null padded to avoid problems with QString::fromUcs2().
  QByteArray decodedContext;
  KCodecs::base64Decode(context.utf8(), decodedContext);

  // Contents is another GUID
  QString contextString = QString::fromUcs2( reinterpret_cast<const unsigned short*>(decodedContext.data()) );
#endif

  // KMess does not support the webapplication invitations yet,
  // this class is currently a STUB to produce a proper error message
  showSystemMessage( i18n("The contact is inviting you for '%1', but this is not implemented yet.")
                          .arg("webcam"),
                     ChatMessage::CONTENT_SYSTEM_NOTICE, true );

  // Tell the contact we don't support this.
  sendCancelMessage(CANCEL_NOT_INSTALLED);

//  // Everything seams OK, accept this message:
//  contactStarted2_UserAccepts();
}



/**
 * Return the application's GUID for "user push" invitations.
 */
QString WebcamTransferP2P::getPushAppId()
{
  return "{4BD96FC0-AB17-4425-A14A-439185962DC8}";
}



/**
 * Return the application's GUID for "contact pull" invitations.
 */
QString WebcamTransferP2P::getPullAppId()
{
  return "{1C9AA97E-9C05-4583-A3BD-908A196F1E92}";
}

