/***************************************************************************
                          notificationcontactstatus.h - notifies when a
                            contact changes their msn status
                             -------------------
    begin                : Saturday July 28 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTIFICATIONCONTACTSTATUS_H
#define NOTIFICATIONCONTACTSTATUS_H

#include "passivepopup.h"
#include "notificationmanager.h"
#include "../contact/contact.h"



/**
  * @brief Notifies the user when a contact has changed its MSN status
  *
  * Notification is made via a popup balloon and a sound (which can be customized)
  *
  * @author Valerio Pilo <amroth@coldshock.net>
*/
class NotificationContactStatus : public QObject
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    NotificationContactStatus( NotificationManager* manager );
    // Enable or disable the contact status notifications
    void                  setEnabled( bool enableNotifyOnline, bool enableNotifyOffline, bool enableNotifyStatus );

  private:
    // Obtains a status string like "contact has come online" for a MSN status code
    QString               getStatusString( QString status );

  signals:
    // Start a chat with a contact
    void                  startChat( QString contactHandle, ChatInformation::ConnectionType connection );

  public slots:
    // Notify the user about this event (a contact has changed status)
    void                  notify( Contact *contact, bool isNeeded );

  private slots:
    // Trigger this event's action
    void                  activate( QStringList stringList, QObject *object );

  private:  // Private properties
    // Notification status for contacts which come online
    bool                  enableNotifyOnline_;
    // Notification status for contacts which disconnect
    bool                  enableNotifyOffline_;
    // Notification status for contacts which change MSN status
    bool                  enableNotifyStatus_;
    // The notification manager instance
    NotificationManager  *manager_;
    // The popup object which we'll be using until it disappears or gets clicked
    PassivePopup         *popup_;

};


#endif
