/***************************************************************************
                          group.cpp  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "group.h"

#include "../utils/kmessconfig.h"
#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "specialgroups.h"



// The constructor
Group::Group(const QString &id, const QString &name)
 : id_(id),
   isExpanded_(true),
   name_(name),
   sortPosition_(0)
{
  // Only have test this once.
  isSpecialGroup_ = ( id_ == SpecialGroups::ONLINE      ) ||
                    ( id_ == SpecialGroups::OFFLINE     ) ||
                    ( id_ == SpecialGroups::ALLOWED     ) ||
                    ( id_ == SpecialGroups::REMOVED     ) ||
                    ( id_ == SpecialGroups::INDIVIDUALS );
}



// The destructor
Group::~Group()
{
#ifdef KMESSDEBUG_GROUP
  kDebug() << "DESTROYED. [handle=" << name_ << ", id=" << id_ << "]";
#endif
}



// Return the group ID
const QString& Group::getId() const
{
  return id_;
}




// Return the group name
const QString& Group::getName() const
{
  return name_;
}



// Return the old sort value  (XXX HACK FIXME OMG)
int Group::getOldSortPosition() const
{
  return oldSortPosition_;
}



// Return the sort value
int Group::getSortPosition() const
{
  return sortPosition_;
}



// Return true if this group is expanded.
bool Group::isExpanded() const
{
  return isExpanded_;
}



// Return true if this is a special group
bool Group::isSpecialGroup() const
{
  return isSpecialGroup_;
}



// Read in group properties
void Group::readProperties( const KConfigGroup &config )
{
  // Get the configuration group where this group's data is stored
  const KConfigGroup groupConfig( config.group( id_ ) );

  // Obtain the sort positiong of this group. Special groups have no sorting.
  if( ! isSpecialGroup() )
  {
    sortPosition_ = groupConfig.readEntry( "sortPosition", sortPosition_ );
  }
  else
  {
    sortPosition_ = 9999;
  }

#ifdef KMESSDEBUG_GROUP
  kDebug() << "Read sort position for group " << name_ << "=" << sortPosition_;
#endif

  // Is the group expanded? that is, can the user see the group's contacts?
  isExpanded_ = groupConfig.readEntry( "isExpanded", true );
}



// Save group properties
void Group::saveProperties( KConfigGroup &config )
{
  // Get the configuration group where this group's data is stored
  KConfigGroup groupConfig( config.group( id_ ) );

  // Save the sort positiong of this group. Special groups have no sorting.
  if( ! isSpecialGroup() )
  {
    groupConfig.writeEntry( "sortPosition", sortPosition_ );
  }

  groupConfig.writeEntry( "isExpanded", isExpanded_ );
}



// Change the group name
void Group::setName( const QString &newName )
{
#ifdef KMESSTEST
  KMESS_ASSERT( newName != "" );
  KMESS_ASSERT( ( id_ != SpecialGroups::ONLINE ) && ( id_ != SpecialGroups::OFFLINE ) && ( id_ != SpecialGroups::ALLOWED ) && ( id_ != SpecialGroups::REMOVED ) );
#endif

  if ( ( name_ != newName ) && ( ! newName.isEmpty() ) )
  {
    name_ = newName;
  }
}



// Change the sort position
void Group::setSortPosition( int sortPosition, bool signal )
{
#ifdef KMESSDEBUG_GROUP
  kDebug() << "Group " << name_ << " old sort position = " << sortPosition_
    << "new sort position = " << sortPosition;
#endif

  oldSortPosition_ = sortPosition_;
  sortPosition_    = sortPosition;
  if( signal )
  {
    emit changedPosition( this, oldSortPosition_, sortPosition_ );
  }
}



void Group::setOldSortPosition( int oldSortPosition )
{
  oldSortPosition_ = oldSortPosition;
}



// Change the expanded state
void Group::setExpanded(bool expanded)
{
  isExpanded_ = expanded;
}



#include "group.moc"
