/***************************************************************************
                          p2pfragmenttracker.h -  description
                             -------------------
    begin                : Wed Dec 5 2007
    copyright            : (C) 2007 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef P2PFRAGMENTTRACKER_H
#define P2PFRAGMENTTRACKER_H

#include <QList>



/**
 * @brief  Utility class to track completed ranges of a transferred file.
 * @author Diederik van der Boor
 * @ingroup NetworkExtra
 */
class P2PFragmentTracker
{
  public:
    // Constructor
                         P2PFragmentTracker();
    // Destructor
    virtual             ~P2PFragmentTracker();

    // Output for debugging
    QString              getDebugMap() const;
    // Return the message ID
    quint32              getMessageID() const;
    // Return the number of received bytes
    quint32              getTransferredBytes() const;
    // Return whether the tracker is empty, no data added yet.
    bool                 isEmpty() const;
    // Return whether the tracker is initialized to receive a part for the given message ID.
    bool                 isInitialized( quint32 messageID ) const;
    // Initialize to receive a new message
    void                 initialize( quint32 messageID, quint32 totalSize );
    // Return whether the fragment tracker is complete.
    bool                 isComplete() const;
    // Register the arrival of a new fragment.
    void                 registerFragment( quint32 offset, quint32 size );

  private:
    /**
     * Internal structure to track the byte ranges.
     */
    struct Range
    {
      quint32 start;
      quint32 end;
    };

    /// The identifier of the message being transferred
    quint32              messageID_;
    /// The total size of the message.
    quint32              totalSize_;
    /// The total number of bytes transferred.
    quint32              transferredBytes_;
    /// The list of transferred ranges.
    QList<Range*>        ranges_;
};


#endif
