/***************************************************************************
                          kmessinterface.h  -  description
                             -------------------
    begin                : Sun Dec 29 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSINTERFACE_H
#define KMESSINTERFACE_H

#include "contact/msnstatus.h"
#include "kmessdebug.h"

#include <KSqueezedTextLabel>
#include <KActionCollection>
#include <KXmlGuiWindow>


// Forward declarations
class QHBox;
class QLabel;
class KAction;
class KActionMenu;
class KConfig;
class KHelpMenu;
class KMessTest;
class KMenu;
class KSelectAction;
class KToggleAction;
class SystemTrayWidget;



/**
 * @brief User interface of the KMess class.
 *
 * This is the user interface of the KMess class, providing the menu items,
 * virtual implementations of some functions, and implementations of windowing-specific functions.
 *
 * @author Mike K. Bennett
 * @ingroup Root
 */
class KMessInterface : public KXmlGuiWindow
{
  Q_OBJECT

  public: // Public methods

    friend class     KMessTest;
    // The constructor
                     KMessInterface( QWidget *parent=0 );
    // The destructor
    virtual         ~KMessInterface();

  protected: // Protected methods
    // The application is closing, after queryExit() was approved
    virtual void     applicationClosing();
    // Enable/disable menus based on whether or not the application is
    //  connected to the server.
    virtual void     enableMenus(bool connected);
    // Initialize the class
    virtual bool     initialize();

    // Restore the window properties (called by KMainWindow)
    virtual void     readProperties( const KConfigGroup &config = *((const KConfigGroup *)0) );
    // Save the window properties (called by KMainWindow)
    virtual void     saveProperties( KConfigGroup &config = *((KConfigGroup *)0) );

  protected slots: // Protected slots
    // "Add a new contact" was selected from the menu.
    virtual void     addNewContact();
    // "Add a new group" was selected from the menu.
    virtual void     addNewGroup();
    // A view pictures mode has been selected from the menu.
    virtual void     changedListPictureSize(int mode);
    // A status was selected from the menu.
    virtual void     changeStatus( QAction *action );
    // A view mode has been selected from the menu.
    virtual void     changeViewMode(int mode);
    // Request to display the export list dialog
    virtual void     showListExportDialog();
    // Request to display the network window has been made
    virtual void     showNetworkWindow();
    // Request to display the transfer manager.
    virtual void     showTransferWindow();
    // "Add new account" has been selected from the menu.
    virtual void     createNewAccount();
    // Disconnect was selected from the menu.
    virtual void     disconnectClicked();
    // "Show status bar" was toggled.
    void             showStatusBar();
    // Show the user's MSN profile.
    virtual void     showUserProfile();
    // Show the chat history dialog and, if requested, that of a specific contact
    virtual void     showChatHistory( const QString &handle = QString() );
    // Change the status bar message.
    virtual void     statusMessage(QString message, bool isError );
    // The "show allowed contacts" menu item has been toggled.
    virtual void     toggleShowAllowed(bool show);
    // The "show empty groups" menu item has been toggled.
    virtual void     toggleShowEmpty( bool show );
    // The "show history box" menu item has been toggled.
    virtual void     toggleShowHistoryBox( bool show );
    // The "show search in contact list" menu item has been toggled.
    virtual void     toggleShowSearchFrame(bool show);
    // The "show offline contacts" menu item has been toggled.
    virtual void     toggleShowOffline(bool show);
    // The "Show removed contacts" menu item has been toggled.
    virtual void     toggleShowRemoved(bool show);
    // Increment and update the online timer.
    void             updateOnlineTimer();

  protected: // Protected attributes
    // The action to show the context-sensitive menu
    KAction         *contextMenuAction_;
    // The menu for "connect..." with a profile
    KActionMenu     *connectActionMenu_;
    // The "disconnect" menu item
    KAction         *disconnect_;
    // The menu for global settings
    KAction         *globalSettings_;
    // View list pictures mode
    KSelectAction   *listPictureSize_;
    // Action to toggle the history box
    KToggleAction   *showHistoryBoxAction_;
    // Action to toggle the contact list search bar
    KToggleAction   *showSearchAction_;
    // Action to display the settings for the connected account
    KAction         *showSettingsAction_;
    // Toggle actions for showing allowed, offline, and removed contacts, and empty groups.
    KToggleAction   *showAllowedAction_, *showOfflineAction_, *showRemovedAction_, *showEmptyAction_;
    // Show the network window
    KAction         *showNetworkAction_;
    // Toggle actions for showing and hiding the menu bar
    KToggleAction   *showMenuBar_;
    // Toggle actions for showing and hiding the status bar
    KToggleAction   *showStatusBar_;
    // Show the transfer manager
    KAction         *showTransferAction_;
    // The selection menu for the user's status
    KMenu           *status_;
    // The system tray widget
    SystemTrayWidget *systemTrayWidget_;
    // The menu for selecting the view mode.
    KSelectAction   *viewMode_;
    // ActionCollection
    KActionCollection *actionCollection_;

  private: // Private methods
    // Create the menus
    void             createMenus();
    // Initialize the system tray widget
    bool             initSystemTrayWidget();
    // Reject quitting unless the quit menu was pressed
    bool             queryExit();
    // Tell the user that KMess hides in the systray
    bool             queryClose();

  private slots: // Private slots
    // Close has been selected from the menu.
    void             menuClose();
    // Quit was selected from the menu.
    void             menuQuit();
    // Show the context-sensitive menu item
    virtual void     showContextMenu() = 0;
    // The "Show Global Settings" option was clicked.
    void             showGlobalSettings();
    // "Show menu bar" was toggled.
    void             showMenuBar();
    // "Show toolbar" was toggled.
   // void             showToolBar();

  private: // Private attributes
    // Export list action
    KAction             *exportList_;
    // Whether the status is a warning or not
    bool                isErrorStatus_;
    // Whether or not the object was initialized
    bool                initialized_;
    // Current message
    QString             message_;
    // Some action menus that the child doesn't need, but need to be
    //  made visible/invisible
    KAction             *newContact_, *newGroup_, *showProfile_, *showHistory_;
    // Minutes online
    unsigned int        onlineTime_;
    // Online interval timer
    QTimer              *onlineTimer_;
    // Toggle actions for showing and hiding the toolbar
    // KToggleAction   *showToolBar_;
    // Status messages
    KSqueezedTextLabel  *statusLabel_;
    // Online timer
    QLabel              *statusTimer_;
    // The view menu - stored here because it needs to be enabled/disabled
    KMenu               *viewMenu_;
};

#endif
