/***************************************************************************
                          kmessdbus.cpp  -  description
                             -------------------
    begin                : Wed Jun 25 2008
    copyright            : (C) 2008 by Ruben Vandamme
    email                : vandammeru gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "currentaccount.h"
#include "kmess.h"
#include "kmessdbus.h"
#include "kmessdebug.h"
#include "chat/chatmaster.h"
#include "model/contactlist.h"
#include "kmessdbusadaptor.h"
#include "utils/richtextparser.h"

#include <QtDBus/QDBusMetaType>



KMessDBus::KMessDBus( KMess *parent )
 : QObject( (QObject*) parent ),
   kmess_( parent )
{
  new RemoteControlAdaptor( this );
  QDBusConnection dbus = QDBusConnection::sessionBus();
  dbus.registerObject( "/remoteControl", this );

  KMESSDBUS_REGISTER_DATATYPES
}



// The destructor
KMessDBus::~KMessDBus()
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "DESTROYED.";
#endif
}



// Connect
void KMessDBus::connect()
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "Connect() called";
#endif

  if( ! kmess_->isConnected() )
  {
    kmess_->checkAutologin( "" );
  }
}



// Disconnect
void KMessDBus::disconnect()
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "Disconnect() called";
#endif

  if( kmess_->isConnected() )
  {
    kmess_->disconnectClicked();
  }
}



// Check if KMess is connected
bool KMessDBus::isConnected()
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "isConnected() called";
#endif

  return kmess_->isConnected();
}



// Set the status
void KMessDBus::setStatus( int status )
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "setStatus( int ) called";
#endif

  if( kmess_->isConnected() )
  {
    kmess_->changeStatus( (Status) status );
  }
}



// Get the status
int KMessDBus::getStatus()
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "getStatus() called";
#endif

  return kmess_->currentAccount_->getStatus();
}



// Get friendly name
QString KMessDBus::getFriendlyName( int formattingMode )
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "getFriendlyname( int ) called";
#endif

  if(formattingMode < 0 || formattingMode > 2 )
  {
#ifdef KMESSDEBUG_KMESSDBUS
    kDebug() << "Unknown formattingMode supplied (" << formattingMode << "), defaulting";
#endif

    return kmess_->currentAccount_->getFriendlyName();
  }
  else
  {
    return kmess_->currentAccount_->getFriendlyName( FormattingMode( formattingMode ) );
  }
}


// Comparison function for qSort()
static bool _compareDBusContact( const DBusContact &contact1, const DBusContact &contact2 )
{
  return QString::compare( contact1.friendlyName, contact2.friendlyName, Qt::CaseInsensitive ) < 0;
}



// Get contactlist
DBusContactList KMessDBus::getList()
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "getList() called";
#endif

  QList<DBusContact> list;
  Contact *contact;

  QHashIterator<QString, Contact*> i( kmess_->currentAccount_->getContactList()->getContactList() );
  DBusContact dbusContact;

  while( i.hasNext() )
  {
    contact = i.next().value();

    // Don't show offline contacts
    if( contact->isOffline() ) continue;

    dbusContact = DBusContact();
    dbusContact.friendlyName = contact->getFriendlyName();
    dbusContact.handle       = contact->getHandle();
    dbusContact.status       = contact->getStatus();
    list.append( dbusContact );
  }

  qSort( list.begin(), list.end(), _compareDBusContact );

  return list;
}


// Request Chat
void KMessDBus::requestChat( QString handle )
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "startChat() called";
#endif

  kmess_->chatMaster_->requestChat( handle );
}



// Start a filetransfer
void KMessDBus::startFileTransfer( QString handle, QString filename )
{
#ifdef KMESSDEBUG_KMESSDBUS
  kDebug() << "startFileTransfer() called";
  kDebug() << "sending file " << filename << " to " << handle;
#endif

  kmess_->chatMaster_->startChatAndFileTransfer( handle, filename );
}



#include "kmessdbus.moc"
