//KMformat
//by Mickael Minarie
//this program is under GNU/GPL licence



#include <QtGui>
#include <QString>
#include <QStringList>
#include "QFormatDLG.h"
#include "CDrive.h"
#include <QImage>
#include <QWhatsThis>


KFormatDLG::KFormatDLG(QString MPoint, bool floppy, QWidget *parent)
  : QDialog(parent)
{
  fl=floppy;
  QString mountpoint;
  if(!tse.testBaseFile())
    qDebug("Warning: KFormat need fdformat in fdutil package, please install it");
  drive= new CDrive();

  QFont f("helvetica", 16, QFont::Black); 
  labelTitle = new QLabel(tr("KDE formatting tool")); //the title
  labelTitle->setFont(f);
  label = new QLabel(tr("Media")); 

  QWMountPoint = new QComboBox; //choose the unit which be formatted
  QWMountPoint->insertItems(0,lmp.GetList()); //to have the list of mountpoint availlable
  QWMountPoint->setToolTip(tr("choose the unit will be formatted"));
  QWMountPoint->setWhatsThis(tr("This ComboBox list the unit can be formatted : \n\n The Unit which begin by sd can be a USB drive or a SATA or SCSI hard drive,\n you must check if it is the good unit with the size displaying."));
  if(MPoint.size()!=0)
    {
      QWMountPoint->setDuplicatesEnabled(true);
      QWMountPoint->insertItem(0,mountpoint);
      QWMountPoint->setCurrentIndex(0);
      QWMountPoint->setDisabled(true);
    }
  label->setBuddy(QWMountPoint);
	
  labelType = new QLabel(tr("Type"));
  leTypeMedia = new QLineEdit;
  leTypeMedia->setFrame(FALSE);
  leTypeMedia->setReadOnly(TRUE);
  leTypeMedia->insert(DetectType(mountpoint));
  leTypeMedia->setToolTip(tr("Description of the unit will be formatted"));
  leTypeMedia->setWhatsThis(tr("Description of the unit will be formatted."));
  labelType->setBuddy(leTypeMedia);

  labelfs = new QLabel(tr("FileSystem"));
  combofilesys = new QComboBox;    
  QStringList list=tse.listFileSytem();
  combofilesys->addItems(list);
  combofilesys->setToolTip(tr("choose the filesystem"));
  combofilesys->setWhatsThis(tr("Choose the filesystem :\n The _vfat_ format can be read by all the systems and the devices (Camera, DVD player...) but it is limited to 2GB. \n\n The _FAT32_ format is readable by all the systems but not all the device.\n It is not limited by the size but it is slow when your unit is big.\n\n The ext2 and ext3 is the standart filesystem for linux.\n\nThe other can be used for special use.\n"));
  labelfs->setBuddy(combofilesys);

  labelSize = new QLabel(tr("Size"));
  leDiskSize = new QLineEdit;
  leDiskSize->setFrame(FALSE);
  leDiskSize->setReadOnly(TRUE);
  leDiskSize->setToolTip(tr("Size of the partition or disk selected"));
  leDiskSize->setWhatsThis(tr("Size of the partition or disk selected,\n this size is the real size."));
  labelSize->setBuddy(leDiskSize);
  if(MPoint.size()!=0)
    {
      leDiskSize->setText(lmp.GetSize(MPoint));
    }


  labelVol = new QLabel(tr("Label"));	
  leDiskLabel = new QLineEdit;
  leDiskLabel->setToolTip(tr("Choose a name for your unit"));
  leDiskLabel->setWhatsThis(tr("You can choose a name for your device. \nFor the USB drive, it will be displayed in your desktop."));
  labelVol->setBuddy(leDiskLabel);

	
  FullFormatCheckBox = new QCheckBox(tr("Full &Format"));
  FullFormatCheckBox->setToolTip(tr("Totally erase the data for floppy"));
  FullFormatCheckBox->setWhatsThis(tr("If the floppy is new\n or if you want to destroy all the data in this,\n You must use this option."));

  CheckIntCheckBox = new QCheckBox(tr("Check &Integrity"));
  CheckIntCheckBox->setToolTip(tr("Verify if the media have error"));

  formatButton = new QPushButton(tr("&Format"));
  formatButton->setDefault(true);
  formatButton->setToolTip(tr("Click here to format"));

  closeButton = new QPushButton(tr("&Close"));
  closeButton->setToolTip(tr("Click here to close the window"));

  moreButton = new QPushButton(tr("&More"));
  moreButton->setCheckable(true);
  moreButton->setAutoDefault(false);

  helpButton = new QPushButton(tr("&Help"));
  helpButton->setToolTip(tr("Display help"));

  whatsThisButton = new QPushButton(tr("&What's This"));
  whatsThisButton->setToolTip(tr("Enter in What's this mode"));

  extension = new QWidget;

  if(floppy)
    {
      labelFloppy = new QLabel(tr("size after formatted"));
      combosizefloppy = new QComboBox;
      QStringList listsiz;
      listsiz<<"auto"<<"1440 mb"<<"720 kb"<<"1200 mb"<<"360 kb";
      combosizefloppy->addItems(listsiz);
    }

  PixUnit = new QPixmap("/usr/share/apps/kmformat/fd.png");
  labelPix = new QLabel;
  labelPix->setPixmap(*PixUnit); //the picture to decorate the window

  PixUnit2 = new QPixmap("/usr/share/apps/kmformat/usbkey.png");
  labelPix2 = new QLabel;
  labelPix2->setPixmap(*PixUnit2); //the picture to decorate the window

  connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
  connect(moreButton, SIGNAL(toggled(bool)), extension, SLOT(setVisible(bool)));
  connect(formatButton, SIGNAL(clicked()), this, SLOT(formatting()));
  connect(helpButton, SIGNAL(clicked()), this, SLOT(help())); 
  connect(whatsThisButton, SIGNAL(clicked()), this, SLOT(EnterWThis()));
  connect(drive, SIGNAL(SigState(int)), this, SLOT(receivSig(int)));
  connect(QWMountPoint, SIGNAL(highlighted(int)), this, SLOT(changeMP(int)));
  connect(QWMountPoint, SIGNAL(activated(int)), this, SLOT(changeMPs(int)));


  QVBoxLayout *extensionLayout = new QVBoxLayout;
  extensionLayout->setMargin(3);
  extensionLayout->addWidget(FullFormatCheckBox);
  extensionLayout->addWidget(CheckIntCheckBox);
  extension->setLayout(extensionLayout);

  QHBoxLayout *topLeftLayout = new QHBoxLayout;
  topLeftLayout->addWidget(label);
  topLeftLayout->addWidget(QWMountPoint);
  topLeftLayout->setSpacing(100);

  QHBoxLayout *middleLeftLayoutA = new QHBoxLayout;
  middleLeftLayoutA->addWidget(labelType);
  middleLeftLayoutA->addWidget(leTypeMedia);
  middleLeftLayoutA->setSpacing(5);

  QHBoxLayout *middleLeftLayoutB = new QHBoxLayout;
  middleLeftLayoutB->addWidget(labelfs);
  middleLeftLayoutB->addWidget(combofilesys);
  middleLeftLayoutB->setSpacing(100);

  QHBoxLayout *middleLeftLayoutC = new QHBoxLayout;
  middleLeftLayoutC->addWidget(labelSize);
  middleLeftLayoutC->addWidget(leDiskSize);
  middleLeftLayoutC->setSpacing(100);

  QHBoxLayout *middleLeftLayoutD = new QHBoxLayout;
  if(floppy)
    {
      middleLeftLayoutC->addWidget(labelFloppy);
      middleLeftLayoutC->addWidget(combosizefloppy);
      middleLeftLayoutC->setSpacing(100);
    }

  QHBoxLayout *bottomLeftLayout = new QHBoxLayout;
  bottomLeftLayout->addWidget(labelVol);
  bottomLeftLayout->addWidget(leDiskLabel);
  bottomLeftLayout->setSpacing(100);

  QVBoxLayout *leftLayout = new QVBoxLayout;
  leftLayout->addLayout(topLeftLayout);
  leftLayout->addLayout(middleLeftLayoutA);
  leftLayout->addLayout(middleLeftLayoutB);
  leftLayout->addLayout(middleLeftLayoutC);
  if(floppy)
    leftLayout->addLayout(middleLeftLayoutD);
  leftLayout->addLayout(bottomLeftLayout);	
  leftLayout->setSpacing(15);
  leftLayout->addStretch(1);

  QHBoxLayout *titleLayout = new QHBoxLayout;
  titleLayout->addWidget(labelPix);
  titleLayout->addWidget(labelTitle);
  titleLayout->addWidget(labelPix2);

  QVBoxLayout *rightLayout = new QVBoxLayout;
  rightLayout->addWidget(formatButton);
  rightLayout->addWidget(closeButton);
  rightLayout->addWidget(moreButton);
  rightLayout->addWidget(whatsThisButton);
  rightLayout->addWidget(helpButton);
  rightLayout->setSpacing(10);
  rightLayout->addStretch(1);

  QGridLayout *mainLayout = new QGridLayout;
  mainLayout->setSizeConstraint(QLayout::SetFixedSize);
  mainLayout->addLayout(titleLayout, 0, 0);
  mainLayout->addLayout(leftLayout, 1, 0);
  mainLayout->addLayout(rightLayout, 1, 1); 
  mainLayout->addWidget(extension, 2, 0, 1, 2);
  setLayout(mainLayout);

  setWindowTitle(tr("KMFormat for KDE 4"));
  extension->hide();
  if(MPoint.size()!=0)
    {
      drive->setMountPoint(MPoint);
      leTypeMedia->setText(DetectType(drive->getMountPoint()));
    }
}	


QString KFormatDLG::DetectType(const QString mountpoint)
{	
  QString temp;
  bool flppy=false;
  if(mountpoint.size()<2)
    temp+="unknown drive";
  else
    {
      if (mountpoint[0]=='h')
	{
	  temp+=tr("hard drive ");
	  WarningTag=true;
	}
      if (mountpoint[0]=='s')
	{
	  temp+=tr("USB, SCSI or Sata drive ");
	  WarningTag=false;
	}
      if (mountpoint[0]=='f')
	{
	  temp+=tr("floppy drive ");
	  WarningTag=false;
	  flppy=true;
	}
      if( (mountpoint[0]!='f') && (mountpoint[0]!='s') && (mountpoint[0]!='h') )
	{
	  temp+=tr("unknown drive");
	  WarningTag=true;
	}
      if(!flppy)
	{
	  temp+=mountpoint[2];
	  temp+=tr(" part ");
	  temp+=mountpoint[3];
	}
      else
	{
	  temp+=tr(" drive ");
	  temp+=mountpoint[2];
	}
    }
  return temp;
}


int KFormatDLG::DetectTypei(const QString mountpoint)
{
	qDebug("DetectTypei");
  if (mountpoint[0]=='h')
    return 1;
  if (mountpoint[0]=='s')
    return 2;
  if (mountpoint[0]=='f')
    return 3;
  return 4;
}


void KFormatDLG::formatting()
{
	qDebug("formatting");
  if(WarningTag)
    switch(QMessageBox::warning(this, "KFormat2",
				tr("You try to format a hard drive\n All your data will be erased in this  drive\n are you sure to continue?"),
				tr("Continue"), tr("Cancel"), 0, 0, 1 )) {
    case(0):
      break;
    case(1):
      return;
      break;
    }
  formatButton->setDisabled(TRUE);
  closeButton->setDisabled(TRUE);
  if( (FullFormatCheckBox->isChecked()) &&  (DetectTypei(drive->getMountPoint())==3) )
    {
	if(fl)
    	    drive->FullFormat(combosizefloppy->currentIndex());
	else
	    drive->FullFormat(0);
	}
  drive->QuickFormat(combofilesys->currentText(),leDiskLabel->text(), CheckIntCheckBox->isChecked());
}


void KFormatDLG::receivSig(int nb)
{
  formatButton->setDisabled(FALSE); //disabled the button when the system formatting a drive
  closeButton->setDisabled(FALSE);
  switch(nb)
    {
    case(0):
      QMessageBox::information(this, "KFormat alpha",
			       tr("Formatting successfull"),QMessageBox::Ok);
      break;
    case(1):
      QMessageBox::warning(this, "KFormat alpha",
			   tr("You cannot use label with this filesystem"));
      break;
    case(-1):
      QMessageBox::warning(this, "KFormat alpha",
			   tr("Error during formatting!"));
      break;
    case(-2):
      QMessageBox::warning(this, "KFormat alpha",
			   tr("Error during formatting, when fork is calling"));
      break;
    }
}


void KFormatDLG::help()
{
  QMessageBox::information(this, "KFormat For KDE 4",
			   tr("KFormat v0.1 for KDE 4 by Mickael Minarie\n"
			   "This program is Under GNU/GPL licence\n"
			   "Press Format when you are ready to format\n"
			   "Be carefull, the formatting erase everything in your drive\n"),
			   QMessageBox::Ok);
}

	
void KFormatDLG::changeMP(int nb)
{
  leDiskSize->setText(lmp.GetSize(nb));
	
}

void KFormatDLG::changeMPs(int nb)
{	
	
  drive->setMountPoint(lmp.GetMP(nb));
  leTypeMedia->setText(DetectType(drive->getMountPoint()));
}

void KFormatDLG::EnterWThis()
{	
  QWhatsThis::enterWhatsThisMode();
}
