//
// C++ Implementation: kmailconfig
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <kconfig.h>
#include <kglobalsettings.h>
#include <kdebug.h>

#include <qstring.h>
#include <qcolor.h>

#include "kmailconfig.h"

kmailConfig::kmailConfig()
{
	fontsAndColorsRead=false;
	headerFrameRead=false;
}

kmailConfig::~kmailConfig()
{
}

/*================================
================================*/
void kmailConfig::readAllParameters(){
	readFontsAndColors();
	readHeaderFrameParameters();
}
/*================================
================================*/
void kmailConfig::readFontsAndColors(){

	QString entrName;
	KConfig config("kmailrc",true,false,"config");
	KConfig gconfig("kdeglobals",true,false,"config");
	
	config.setGroup("Reader");
	if (config.readBoolEntry("defaultColors",false)){
		// Kmail uses default colors
		for(int i=0;i<3;i++) cols[i]="008000";
		cols[3]="000000";
	}else{
		// Kmail uses user defined colors
		for(int i=0;i<4;i++){
			if(i<3) entrName.sprintf("QuotedText%d",i+1);
			else entrName="ForegroundColor";
			QColor bCol=config.readColorEntry(entrName);
			QString l;
			l.sprintf("#%2X%2X%2X", bCol.red(),bCol.green(), bCol.blue());
			l.replace(" ","0");
			cols[i]=l;
		}
	}
	
	// read font values
	config.setGroup("Reader");
	useFixedFont=config.readBoolEntry("useFixedFont",false);
	//kdDebug()<<"useFixedFont="<<useFixedFont<<endl;
	config.setGroup("Fonts");
	defaultFonts=config.readBoolEntry("defaultFonts",false);
	//kdDebug()<<"defaultFonts="<<defaultFonts<<endl;
	bodyFont=config.readListEntry("body-font");
	breakFontList(bodyFont,5);
	breakFontList(bodyFont,3);
	gconfig.setGroup("General");
	systemFont=gconfig.readListEntry("font");
	breakFontList(systemFont,4);

	if (useFixedFont){
		if (defaultFonts){
			// Kmail uses system fixed fonts
			//kdDebug()<<"using system fixed fonts"<<endl;
			gconfig.setGroup("General");
			QStringList font=gconfig.readListEntry("fixed");
			breakFontList(font,0,true);
		}else{
			//kdDebug()<<"using user defined fixed fonts"<<endl;
			// Kmail uses user defined fixed fonts
			QStringList font=config.readListEntry("fixed-font");
			breakFontList(font,0,true);
		}
	}else{
		if (defaultFonts){
			// Kmail uses system scalable fonts
			//kdDebug()<<"using system scalable fonts"<<endl;
			breakFontList(systemFont,0,true);
		}else{
			//kdDebug()<<"using user defined scalable fonts"<<endl;
			// Kmail uses user defined scalable fonts
			for(int i=0;i<3;i++){
				entrName.sprintf("quote%d-font",i+1);
				QStringList font=config.readListEntry(entrName);
				breakFontList(font,i);
			}
		}
	}

	for(int i=0;i<5;i++){
		if(m_bold[i]=="75") bold[i]=true;
		else bold[i]=false;
		if(m_italics[i]=="1") italics[i]=true;
		else italics[i]=false;
	}
	fontsAndColorsRead=true;
}
/*================================
================================*/
void kmailConfig::readHeaderFrameParameters(){
	// read subject fore color
	QColor hCol=KGlobalSettings::highlightedTextColor();
	headerForegroundColor.sprintf("#%2X%2X%2X", hCol.red(),hCol.green(), hCol.blue());
	headerForegroundColor.replace(" ","0");
	//kdDebug()<<"headerForegroundColor="<<headerForegroundColor.local8Bit()<<endl;
	// read dubject back color
	hCol=KGlobalSettings::highlightColor();
	headerTableBackgroundColor.sprintf("#%2X%2X%2X", hCol.red(),hCol.green(), hCol.blue());
	headerTableBackgroundColor.replace(" ","0");
	//kdDebug()<<"headerTableBackgroundColor="<<headerTableBackgroundColor.local8Bit()<<endl;
	// create fallback color for others back color
	int h=0,s=0,v=0;
	hCol.getHsv(h,s,v);
	if(s!=0) s/=2;
	else s=180;
	if(h!=0) h+=45;
	else h=45;
	if(h>360) h-=360;
	hCol.setHsv(h,s,v);
	// read others back color
	KConfig config("kdeglobals",true,false,"config");
	config.setGroup("WM");
	QColor bCol=config.readColorEntry("frame",&hCol);
	innerTableBackgroundColor.sprintf("#%2X%2X%2X", bCol.red(),bCol.green(), bCol.blue());
	innerTableBackgroundColor.replace(" ","0");
	//kdDebug()<<"innerTableBackgroundColor="<<innerTableBackgroundColor.local8Bit()<<endl;
	headerFrameRead=true;
}
/*================================
================================*/
void kmailConfig::breakFontList(QStringList font, int id, bool setAll){
	QStringList::iterator it;
	int cc=0;
	for(it=font.begin();it!=font.end();++it ){
		if(cc==0) fonts[id]=*(it);
		else if(cc==1) size[id]=*(it);
		else if(cc==4) m_bold[id]=*(it);
		else if(cc==5) m_italics[id]=*(it);
		cc++;
	}
	if(setAll){
		for(int i=1;i<4;i++){
			fonts[i]=fonts[0];
			size[i]=size[0];
			m_bold[i]=m_bold[0];
		}
		// Quoted text is italics by default
		for(int i=0;i<3;i++) m_italics[i]="1";
		m_italics[3]=m_italics[0];
	}
}

// Interface
/*================================*/
QString kmailConfig::subjectBgColor(){
	if(!headerFrameRead) readHeaderFrameParameters();
	return headerTableBackgroundColor;
}
/*================================*/
QString kmailConfig::ItemsBgColor(){
	if(!headerFrameRead) readHeaderFrameParameters();
	return innerTableBackgroundColor;
}
/*================================*/
QString kmailConfig::tableForeColor(){
	if(!headerFrameRead) readHeaderFrameParameters();
	return headerForegroundColor;
}
/*================================*/
QString kmailConfig::fontName(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>4){
		kdDebug()<<"[kmailConfig::fontName] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return fonts[level];
}
/*================================*/
QString kmailConfig::fontSize(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>4){
		kdDebug()<<"[kmailConfig::fontSize] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return size[level];
}
/*================================*/
QString kmailConfig::fontColor(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>4){
		kdDebug()<<"[kmailConfig::fontColor] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return cols[level];
}
/*================================*/
bool kmailConfig::isFontBold(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>4){
		kdDebug()<<"[kmailConfig::isFontBold] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return bold[level];
}
/*================================*/
bool kmailConfig::isFontItalics(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>4){
		kdDebug()<<"[kmailConfig::isFontItalics] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return italics[level];
}
/*================================*/
QString kmailConfig::quotedFontName(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>2){
		kdDebug()<<"[kmailConfig::quotedFontName] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return fonts[level];
}
/*================================*/
QString kmailConfig::quotedFontSize(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>2){
		kdDebug()<<"[kmailConfig::quotedFontSize] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return size[level];
}
/*================================*/
QString kmailConfig::quotedFontColor(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>2){
		kdDebug()<<"[kmailConfig::quotedFontName] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return cols[level];
}
/*================================*/
bool kmailConfig::isQuotedFontBold(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>2){
		kdDebug()<<"[kmailConfig::quotedFontName] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return bold[level];
}
/*================================*/
bool kmailConfig::isBQuotedFontItalics(int level){
	if(!fontsAndColorsRead) readFontsAndColors();
	if(level>2){
		kdDebug()<<"[kmailConfig::quotedFontName] Warning: Wrong parameter value: level"<<endl;
		level=0;
	}
	return italics[level];
}
/*================================*/
QString kmailConfig::bodyFontName(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return fonts[3];
}
/*================================*/
QString kmailConfig::bodyFontSize(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return size[3];
}
/*================================*/
QString kmailConfig::bodyFontColor(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return cols[3];
}
/*================================*/
bool kmailConfig::isBbodyFontBold(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return bold[3];
}
/*================================*/
bool kmailConfig::isBbodyFontItalics(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return italics[3];
}
/*================================*/
QString kmailConfig::standardFontName(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return fonts[4];
}
/*================================*/
QString kmailConfig::standardFontSize(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return size[4];
}
/*================================*/
QString kmailConfig::standardFontColor(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return cols[4];
}
/*================================*/
bool kmailConfig::isStandardFontBold(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return bold[4];
}
/*================================*/
bool kmailConfig::isStandardFontItalics(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return italics[4];
}

/*================================*/
QString kmailConfig::standardBodyFontName(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return fonts[5];
}
/*================================*/
QString kmailConfig::standardBodyFontSize(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return size[5];
}
/*================================*/
QString kmailConfig::standardBodyFontColor(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return cols[5];
}
/*================================*/
bool kmailConfig::isStandardBodyFontBold(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return bold[5];
}
/*================================*/
bool kmailConfig::isStandardBodyFontItalics(){
	if(!fontsAndColorsRead) readFontsAndColors();
	return italics[5];
}
