/* -*- c++ -*-
*
* main.h
*
* Copyright (C) 2003, 2004 Petter E. Stokke <gibreel@kmldonkey.org>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*/

#ifndef __kmldonkey_kded_kmldonkey_main_h__
#define __kmldonkey_kded_kmldonkey_main_h__

#include <kdedmodule.h>
#include <qstring.h>
#include <qstringlist.h>

class KConfig;
class MMServer;
class CoreLauncher;
class PreviewStreamerServer;

class KDEDKMLDonkey : public KDEDModule
{
    Q_OBJECT
    K_DCOP
public:
    KDEDKMLDonkey( const QCString& name );
    virtual ~KDEDKMLDonkey();

k_dcop:
    virtual void setMobileMuleEnabled(bool);
    virtual void enableMobileMule();
    virtual void disableMobileMule();
    virtual bool mobileMuleEnabled() const;
    
    virtual void startCore(const QString& name);
    virtual void stopCore(const QString& name);
    virtual bool isCoreRunning(const QString& name);
    virtual bool isValidCore(const QString& name);
    virtual QStringList coreNames();

private:
    KConfig* mmcfg;
    MMServer* mmserver;
    CoreLauncher* launcher;
    PreviewStreamerServer* streamer;
};



#endif
