/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef D_PICKPHONEBOOK_H
#define D_PICKPHONEBOOK_H

#include <kdialogbase.h> 
#include <kabc/addressbook.h>
#include <kcompletion.h> 
#include <kprogress.h>
#include <qtimer.h>

#include "kmobiletools.h"
#include "d_newsms.h"
#include "ui_PickPhonebook.h"

/**
@author Marco Gulino
*/
class d_PickPhoneBook : public KDialogBase
{
Q_OBJECT
public:
    d_PickPhoneBook(QWidget *parent = 0, const char *name = 0);
    ~d_PickPhoneBook();
private:
	ui_PickPhonebook* mainWidget;
	KABC::AddressBook* addressbook;
	kmobiletools* k_parent;
	d_NewSMS*     newSMSWin;
	KProgressDialog* updating;
	int progressVersus;
	QTimer refresh;
	QStringList memSourcesList;
	
public slots:
    void filterChanged(const QString &text);
    void slotOk();
    void slotCancel();
    void selChanged();
    void refreshClicked();
    void updatingSlot();
    void initList( int );
};

#endif
