/***************************************************************************
                       kmfcheckinput.h  -  description
                          -------------------
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFCHECKINPUT_H
#define KMFCHECKINPUT_H


/**
  *@author Christian Hubinger
  */

#include <qdict.h>

class QString;
class KMFError;
class KMFCheckInput {
public:
	KMFCheckInput();
	~KMFCheckInput();

	KMFError* checkInput( QString& inp, const QString& inp_type );

private:    // functions
	void generateMsgDict();
	bool checkIP( QString input );
	bool checkFQHN( QString inp );
	bool checkChainName( QString inp );
	bool checkRuleName( QString inp );
	bool checkMAC( QString inp );
	bool checkNetMask ( QString inp );
	bool checkNetWork ( QString inp );
	bool checkPORT( QString inp );
	bool checkPORTRANGE( QString inp );
	bool checkMULTIPORT( QString inp );
private:     // data
	QDict<QString> m_msg_dict;
};

#endif
