/***************************************************************************
                       kmfprocout.h  -  description
                          -------------------
 begin                : Thu Sep 5 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFPROCOUT_H
#define KMFPROCOUT_H

// QT includes
#include <qwidget.h>
#include <qstring.h>
#include <qpixmap.h>

// KDE includes
#include <kprocess.h>

/**
  *@author Christian Hubinger
  */

class QLabel;
class QGridLayout;
class KPushButton;
class QTextBrowser;

class KMFProcOut : public QWidget {
	Q_OBJECT
public:
	KMFProcOut( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFProcOut();
	KProcess* childproc;
	KProcess &operator<<( const QString& arg );

	bool isRunning();
	void runCmd( QString&, QString& );
	void setText( const QString& );

protected:
	// Component notifications:

	void startJob();
	void prepareJob( QString &dir );
	void childFinished( bool normal, int status );
	void insertStderrLine( const QString &line );
	void insertStdoutLine( const QString &line );

protected:
	QString* stderrbuf;
	QString* stdoutbuf;

protected slots:
	void slotKillJob();
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
	void slotProcessExited( KProcess* );

private:
	void flushStdoutBuf();
	void flushStderrBuf();
	void slotSetButtons();
	void initGUI();

private:    // data
	QPixmap icon_stop, icon_close;
	QString m_job_name;
	QTextBrowser *m_lbview;
	QLabel *m_ljob_name;
	QGridLayout *m_layout;
	KPushButton *m_bkill;
	KPushButton *m_bclose;

signals:
	void processExited( KProcess * );
	void rowSelected( int row );
	void sigJobFinished( bool, const QString& );
};

#endif
