//
// C++ Interface: ipaddress
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef IPADDRESS_H
#define IPADDRESS_H

/**
@author Christian Hubinger
*/

// QT includes
#include <qstring.h>
#include <qvaluelist.h>

// KDE includes
#include <kdemacros.h>

// Project includes

class KMFError;
class KMFCheckInput;

#define NUMDIGITS 4


class KDE_EXPORT IPAddress {
public:
	IPAddress( int = 0, int = 0, int = 0, int = 0 );
	~IPAddress();

	/** Sets the address to the given 4 int representation.
		Returns false if the address is invalid */
	bool setAddress( int, int, int, int );
	
	/** Set the address to the address given in the string.
		Returns false if the address is invalid */
	bool setAddress( const QString& );
	
	
	IPAddress&  plus(int); // FIXME: remove that!!!
	
	/** check if the address is equal to the other */	
	int operator==( const IPAddress& );

	/** Return the int for the given posintion in the address */
	int getDigit( int num ) const;
	
	/** returns a QString holding the address e.g. 123.234.123.234 */
	const QString& toString() const;

	/** Return values for the comparision operator== */
	enum { EQUAL, BIGGER, SMALLER };
	
	
private:
	int m_digits[ NUMDIGITS ];
	KMFCheckInput *m_checkInput;
	KMFError *m_err;



// static stuff
public:	
	/** Calculates the netmask from the mask length
		e.g. 255.255.255.0 -> 24 */
	static IPAddress& calcNetworkMaskFromLength( int maskLen );
	
	/** Calculates the given netmask length to the net mask.
		e.g. 24 -> 255.255.255.0 */
	static int calcLenthToMask( IPAddress& );
	
	/** Returns true it the given adddress is a valid net mask */
	static bool isValidMask( IPAddress& );
	
	/** Checks if the the addresses are on the same network. */
	static bool hostsOnSameNetwork( IPAddress&, IPAddress&, int maskLen );
	
	/** Checks if the the addresses are on the same network. */
	static bool hostsOnSameNetwork( IPAddress&, IPAddress&, IPAddress& mask );

private:	
	private: static int calcLenthToMaskDigit( int nMask, int *nextOne );

};
#endif
