/***************************************************************************
   begin                : Thu Apr 24 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NETFILTEROBJECT_H
#define NETFILTEROBJECT_H

// QT includes
#include <qobject.h>
#include <qstring.h>
#include <qdom.h>
#include <qptrlist.h>
#include <qintdict.h>
#include <qstringlist.h>

#include <kdemacros.h>

// KDE includes

// Project includes
class KMFDoc;

/** NetfilterObject ist the base class for (allmost)  all data classes
	used within KMF. It defines the needed prperties and methods to 
	allow things undo/redo, unique object id's etc. */ 
class KDE_EXPORT NetfilterObject : public QObject {
	//############# Beginn static stuff ##############
private:
	private: static int m_last_given_id;
	private: static QPtrList<NetfilterObject>* m_all_objects;
	private: static QIntDict<NetfilterObject>* m_dict_all_objects;
public:
	public: static QPtrList<NetfilterObject>* getObjectsList() {
		return m_all_objects;
	};
	public: static QIntDict<NetfilterObject>* getObjectsDict() {
		return m_dict_all_objects;
	};

public:
	static void resetNextObjectID();
	//############# End static stuff ##############

public:
	NetfilterObject( QObject* );
	virtual ~NetfilterObject();
	
	/** Known object types */ 
	public: enum { TABLE = 0, CHAIN = 1, RULE = 2, RULEOPTION = 3, PROTOCOL = 4, NETZONE = 5, NETHOST = 6 };
	
	/** Sets the Neame of the Object */
	void setName( const QString& );

	/** Retrun the Object's name */
	const QString& name() const {
		return m_name;
	};

	/** return the object type */
	int type() const {
		return m_object_type;
	};
	/** Set the Object's id */
	void setObjectID( int );

	/** Return the Object's id */
	int objectID() const {
		return m_object_id;
	};

	/** Set Description for this Object */
	virtual void setDescription( const QString& );

	/** Return DomDocument of this Object */
	virtual const QDomDocument& getDOMTree() = 0;

	/** Return String representation of the DomDocument generated 
		by const QDomDocument& getDOMTree() */
	virtual const QString& getXMLSniplet();

	/** Load configuration from the given QDdomDocument */
	virtual void loadXML( const QDomDocument& ) = 0;


	/** Return the Object's Description */
	const QString description() const {
		return m_desc;
	};

	/** Set m_saved = true*/
	void save();

	/** Return m_saved */
	bool saved() const {
		return m_saved;
	};

	/** undo the last change */
	void undo();
	
	/** redo the last undo */
	void redo();
	
	/** save state to the undo list */
	void saveState();
	
	/** undoThe last saveState */
	void undoSaveState();
	
	/** Set the parent object */
	void setParent( NetfilterObject* );
	
	/** check if the object is a (indirect) child of the object 
		with the given id */
	bool isChildOf( int id );
	
	/** Passes the change( int id ) calles to the parent object */
	void changed( int id );
	
	/** set the changed flag, and calling changed( int id ) in the parent 
		object with it's own id */
	void changed();

protected:
	protected: NetfilterObject *m_parent;
	protected: KMFDoc *m_doc;
	protected: QString m_name, m_desc;
	protected: int m_object_id, m_object_type;
	protected: bool m_saved;
	protected: QStringList m_undo_list;
	protected: QStringList m_redo_list;
};

#endif
