/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: qbpickstartdate.cpp 1450 2008-02-12 10:56:12Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

// QBanking includes
#include "kbpickstartdate.h"
#include <qbanking/qbanking.h>

// Gwenhywfar includes
#include <gwenhywfar/debug.h>

// QT includes
#include <qradiobutton.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qdatetime.h>

// KDE includes
#include <kpushbutton.h>
#include <kdatewidget.h>
#include <kstdguiitem.h>

// KMyMoney includes
#include <kmymoney/kmymoneydateinput.h>



KBPickStartDate::KBPickStartDate(QBanking *qb,
                                 const QDate &firstPossible,
                                 const QDate &lastUpdate,
                                 int defaultChoice,
                                 QWidget* parent, const char* name,
                                 bool modal, WFlags fl) :
  KBPickStartDateUi(parent, name, modal, fl),
  _banking(qb),
  _firstPossible(firstPossible),
  _lastUpdate(lastUpdate)
{
  buttonOk->setGuiItem(KStdGuiItem::ok());
  buttonCancel->setGuiItem(KStdGuiItem::cancel());
  buttonHelp->setGuiItem(KStdGuiItem::help());

  QObject::connect(buttonHelp, SIGNAL(clicked()),
                   this, SLOT(slotHelpClicked()));

  if (_lastUpdate.isValid()) {
    lastUpdateLabel->setText(_lastUpdate.toString());
    lastUpdateButton->setEnabled(true);
    lastUpdateLabel->setEnabled(true);
  }
  else {
    lastUpdateButton->setEnabled(false);
    lastUpdateLabel->setEnabled(false);
    if (defaultChoice==2)
      defaultChoice=1;
  }

  if (_firstPossible.isValid()) {
    firstDateLabel->setText(_firstPossible.toString());
    firstDateButton->setEnabled(true);
    firstDateLabel->setEnabled(true);
    // As long as we use the KDateWidget we don't have
    // a chance to control the range. Once we are able
    // to use a KMyMoneyDateInput widget, we can make use
    // of the setRange() method again.
    // pickDateEdit->setRange(_firstPossible, QDate());
  }
  else {
    firstDateButton->setEnabled(false);
    firstDateLabel->setEnabled(false);
    if (defaultChoice==3)
      defaultChoice=1;
  }

  switch(defaultChoice) {
  case 2:  lastUpdateButton->setChecked(true); break;
  case 3:  firstDateButton->setChecked(true); break;
  default: noDateButton->setChecked(true); break;
  }

  pickDateEdit->setDate(QDate::currentDate());

  buttonGroup->setFocus();
}



KBPickStartDate::~KBPickStartDate(){
}


QDate KBPickStartDate::date() {
  if (noDateButton->isChecked())
    return QDate();
  else if (firstDateButton->isChecked())
    return _firstPossible;
  else if (pickDateButton->isChecked())
    return pickDateEdit->date();
  else if (lastUpdateButton->isChecked())
    return _lastUpdate;
  else {
    DBG_ERROR(0, "Unknown date state");
    return QDate();
  }
}



void KBPickStartDate::slotHelpClicked() {
  _banking->invokeHelp("KBPickStartDate", "none");
}

