/***************************************************************************
                          kmymoneyfile.h  -  description
                             -------------------
    begin                : Mon Jun 10 2002
    copyright            : (C) 2000-2002 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYMONEYFILE_H
#define KMYMONEYFILE_H

#include "../mymoney/mymoneyaccount.h"
class MyMoneySeqAccessMgr;

/**
  *@author Michael Edwardes
  */

class KMyMoneyFile {
private:
  // static KMyMoneyFile *_instance;
  // MyMoneyFile *m_file;
  MyMoneySeqAccessMgr *m_storage;
  bool m_open;

protected:
  // KMyMoneyFile(const QString&);

public:
  KMyMoneyFile();
  ~KMyMoneyFile();
//  static KMyMoneyFile *instance();

  // MyMoneyFile* file();
  MyMoneySeqAccessMgr* storage();
  void reset();
  void open();
  void close();
  bool isOpen();

  /**
    * This method is used to convert the internal representation of
    * an account type into a human readable format
    *
    * @param accountType numerical representation of the account type.
                         For possible values, see MyMoneyAccount::accountTypeE
    * @return QString representing the human readable form
    */
  static const QString accountTypeToString(const MyMoneyAccount::accountTypeE accountType);

  /**
    * This method is used to convert an account type from it's
    * string form to the internal used numeric value.
    *
    * @param accountType reference to a QString containing the string to convert
    * @return accountTypeE containing the internal used numeric value. For possible
    *         values see MyMoneyAccount::accountTypeE
    */
  static const MyMoneyAccount::accountTypeE stringToAccountType(const QString& type);
};

#endif
