/***************************************************************************
                          kselectdatabase.h
                             -------------------
    copyright            : (C) 2005 by Tony Bloomfield
    author               : Tony Bloomfield
    email                : tonybloom@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSELECTDATABASEDLG_H
#define KSELECTDATABASEDLG_H

// ----------------------------------------------------------------------------
// QT Includes
#include <qlistbox.h>
#include <qlineedit.h>
#include <qlabel.h>

// ----------------------------------------------------------------------------
// KDE Includes
#include <kurl.h>

// ----------------------------------------------------------------------------
// Project Includes
#include "kselectdatabasedlgdecl.h"
#include "../mymoney/storage/mymoneystoragesql.h"

class KSelectDatabaseDlg : public KSelectDatabaseDlgDecl
{
Q_OBJECT
public:
  KSelectDatabaseDlg(QWidget *parent = 0, const char *name = 0);
  ~KSelectDatabaseDlg();
  /** Set the mode of this dialog
    * @param - openMode (IO_ReadWrite = open database; IO_WriteOnly = saveas database)
  **/
  void setMode(int openMode);
  /** Return URL of database
    * @return - pseudo-URL of database selected by user
  **/
  const KURL selectedURL();

/* leave these in for now, useful for testing...
  const QString driverName() const {return (listDrivers->currentText().section (' ', 0, 0));}
  const QString dbName() const {return (textDbName->text());}
  const QString hostName() const {return (textHostName->text());}
  const QString userName() const {return (textUserName->text());}
  const QString password() const {return (textPassword->text());} */
    
public slots:
  void slotDriverSelected(QListBoxItem *driver);
  void slotHelp();
  void slotGenerateSQL();
  void slotOKPressed();
private:
  int m_mode;
  void getFileName();
  MyMoneyDbDrivers m_map;
};

#endif
