#include "MultiTextInput.h"
#include <qcombobox.h>
#include <qlabel.h>
#include <qstring.h>
#include <qkeycode.h>
#include <qtextedit.h>
#include <qscrollview.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qframe.h>
#include <qvariant.h>
#include <klocale.h>
#include <kurl.h>
#include <algorithm>
#include <qsize.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <qfile.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kio/netaccess.h>
#include <klocale.h>

#include "kmysqladmin/helpers/tfunctions.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "editsentry.h"
#include "blobstorage.h"
#include "textstorage.h"

#define Inherited CMultiTextInputData

#define VARIABLEPOS 2

using namespace std;

CMultiTextInput::CMultiTextInput(bool aemptys_too,bool acheck_ops,QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    emptys_too = aemptys_too;
    check_ops = acheck_ops;
    m_result_list = 0;
    setCaption( "KMySQL - MultiWindow" );
    FrameWidget = 0;
    EditLayout = 0;
    handleBlobSettings();
}

CMultiTextInput::~CMultiTextInput()
{
    if (m_result_list) {
        delete m_result_list;
    }
}

bool CMultiTextInput::readFile(const std::string&aFile,std::string&target)
{
    target="";
    if (aFile.size()==0)  {
        return false;
    }

    KURL url(STL_TO_QT_STRING(aFile));
    QString filename;

    if( !KIO::NetAccess::download( url, filename,this ) ) {
        KMessageBox::error(this,i18n(
        "Error while trying to open file:\n %1").arg(url.url()));
        KIO::NetAccess::removeTempFile( filename );
        return false;
    }

    int file = ::open(QT_TO_STL_STRING(filename).c_str(),O_RDONLY);
    if (file<0) {
        KIO::NetAccess::removeTempFile(filename);
        return false;
    }
    char s[4096];
    int l = 0;
    while ( (l = ::read(file,s,4096))>0 ) {
        target.append(s,l);
    }
    ::close(file);
    KIO::NetAccess::removeTempFile( filename );
    return true;
}

//horrible - but I did not found any other way
//as such long functions
void CMultiTextInput::build_widgets(e_PatternList*which,const char**operators,const char*checkbox_msg)
{
    QString s,t;
    QLineEdit*dummy;
    QComboBox*d3;
    CBlobstorage*d4;
    CTextstorage*d5;
    QLabel*d_label;
    QListBox*dlistbox;
    QSize hint;

    FrameWidget = new QFrame(MainScrollView->viewport());
    FrameWidget->setFrameStyle(QFrame::NoFrame|QFrame::Plain);
    MainScrollView->setFrameStyle(QFrame::WinPanel|QFrame::Plain);
    MainScrollView->setResizePolicy( QScrollView::AutoOneFit );
    MainScrollView->addChild(FrameWidget,0,0);

    EditLayout = new QGridLayout(FrameWidget);
    EditLayout->setMargin(3);
    EditLayout->setSpacing(3);

    if (!which || which->size() == 0)
        return;
    EditList.clear();

    e_PatternIterator p_iterator;
    if (!EditLayout) {
        debug("could not find editlayout");
        return;
    }
    QComboBox * box = 0;
    QCheckBox* check = 0;
    int lpos = 0;
    QImage test_image;
    for (p_iterator = which->begin(),lpos=0;p_iterator!=which->end();++p_iterator,++lpos){
        s = p_iterator->get_entry();
        d_label = new QLabel(FrameWidget,s);
        d_label->setAlignment(AlignRight|AlignVCenter);
        t = s.copy();
        t +=": ";
        d_label->setText(t);
        hint=d_label->sizeHint();
        d_label->setMinimumSize(hint);
        EditLayout->addWidget(d_label,lpos,0);
        EditList.push_back(EditEntry(s));
        if (operators && !p_iterator->isBlob()) {
            box = new QComboBox(FrameWidget);
            for (unsigned i=0; operators[i]!=0;++i) {
                box->insertItem(operators[i]);
            }
            EditLayout->addWidget(box,lpos,1);
            EditList[lpos].setList(box);
        } else {
            box = 0;
        }
        if (checkbox_msg) {
            check = new QCheckBox(FrameWidget);
            check->setText(checkbox_msg);
            EditLayout->addWidget(check,lpos,3);
            EditList[lpos].setCheck(check);
        }
        if (p_iterator->isLargeText()) {
            d5 = new CTextstorage(FrameWidget,s);
            //d5->setTextFormat(Qt::PlainText);
            d5->resize(30,50);
            d5->setText(p_iterator->get_pattern());
            /*if (which->begin() == p_iterator)
                d2->setFocus();*/
            EditLayout->addWidget(d5,lpos,VARIABLEPOS);
            EditList[lpos].setEdit(d5);
        } else if (p_iterator->isBlob()) {
            d4 = new CBlobstorage(FrameWidget,s);
            EditLayout->addWidget(d4,lpos,VARIABLEPOS);
            EditList[lpos].setEdit(d4);
            d_label = new QLabel(FrameWidget,s);
            d_label->setText(i18n("<blockquote>Select an input file.</blockquote>"));
            d_label->setMaximumWidth(240);
            d_label->setScaledContents(true);
            EditLayout->addWidget(d_label,lpos,1);
        } else if (p_iterator->enum_list().size()>0) {
            if (p_iterator->get_is_set()) {
                dlistbox = new QListBox(FrameWidget,s);
                dlistbox->setSelectionMode(QListBox::Multi);
                dlistbox->resize(30,50);
                EditLayout->addWidget(dlistbox,lpos,VARIABLEPOS);
                stringlist l = tfunctions::Explode()(p_iterator->get_pattern(),",",false);
                std::string sub;
                for (unsigned _c=0; _c < p_iterator->enum_list().size();++_c) {
                    sub = p_iterator->enum_list()[_c];
                    dlistbox->insertItem(STL_TO_QT_STRING(sub));
                    if (l.find(sub)!=l.end()) {
                        dlistbox->setSelected(dlistbox->count()-1,true);
                    }
                }
                EditList[lpos].setEdit(dlistbox);
            } else {
                d3 = new QComboBox(FrameWidget,s);
                d3->resize(30,25);
                d3->setMinimumSize(10,25);
                d3->setMaximumSize(32767,25);
                if (which->begin() == p_iterator)
                    d3->setFocus();
                EditLayout->addWidget(d3,lpos,VARIABLEPOS);
                int cur_pos=-1;
                for (unsigned _c=0;_c<p_iterator->enum_list().size();++_c) {
                    d3->insertItem(STL_TO_QT_STRING(p_iterator->enum_list()[_c]));
                    if (p_iterator->enum_list()[_c] == p_iterator->get_pattern()) {
                        cur_pos = _c;
                    }
                }
                if (cur_pos>-1) {
                    d3->setCurrentItem(cur_pos);
                }
                EditList[lpos].setEdit(d3);
            }
        } else {
            dummy = new QLineEdit(FrameWidget,s);
            dummy->resize(30,25);
            dummy->setMinimumSize(10,25);
            dummy->setMaximumSize(32767,25);
            dummy->setText(p_iterator->get_pattern());
            if (p_iterator->isNumeric()) {
                dummy->setMaxLength(29);
            } else {
                dummy->setMaxLength(255);
            }
            EditLayout->addWidget(dummy,lpos,VARIABLEPOS);
            if (which->begin() == p_iterator)
                dummy->setFocus();
            connect( dummy, SIGNAL(returnPressed()), SLOT(change_focus()) );
            EditList[lpos].setEdit(dummy);
        }
    }
    FrameWidget->setMinimumSize(FrameWidget->sizeHint());
}

PatternList*CMultiTextInput::get_entries()
{
    PatternList * temp = m_result_list;
    m_result_list = 0;
    return temp;
}

bool CMultiTextInput::build_result()
{
    QWidget*currentEdit;
    QString pat;
    string name;
    string content;
    QString op;
    QCheckBox * check;

    m_result_list = new PatternList;
    bool status = true;
    bool force = false;

    for (size_t pos = 0; pos<EditList.size();++pos) {
        name = EditList[pos].getName();
        currentEdit=EditList[pos].getEdit();
        check = EditList[pos].getCheck();
        force = (check && check->isChecked());
        content = "";
        if (currentEdit->isA("CBlobstorage")) {
            pat = ((CBlobstorage*)currentEdit)->getname();
            if (pat.length()==0) {
            } else if ( readFile(QT_TO_STL_STRING(pat),content) == false) {
                status = false;
                break;
            }
        } else if (currentEdit->isA("QTextEdit")) {
            pat = ((QTextEdit*)currentEdit)->text();
        } else if (currentEdit->isA("CTextstorage")) {
            pat = ((CTextstorage*)currentEdit)->getText();
        } else if (currentEdit->isA("QLineEdit")) {
            pat = ((QLineEdit*)currentEdit)->text();
        } else if (currentEdit->isA("QComboBox")) {
            pat = ((QComboBox*)currentEdit)->currentText();
        } else if (currentEdit->isA("QListBox")) {
            QListBox*b = (QListBox*)currentEdit;
            stringlist l;
            for (unsigned int i = 0; i < b->count();++i) {
                if (b->isSelected(i)) {
                    l.push_back(QT_TO_STL_STRING(b->text(i)));
                }
            }
            if (l.size()>0) {
                content = tfunctions::Implode<stringlist>()(l,std::string(","),false);
            } else {
                content = "";
            }
        } else {
            if (EditList[pos].getDisplayOnly()) {
                pat = "";
            } else {
                pat = "";
            }
        }
        if (EditList[pos].getList()) {
            op = EditList[pos].getList()->currentText().stripWhiteSpace();
        } else {
            op = "";
        }
        if ( (pat.length() > 0) || (check_ops && op.length()>0) || emptys_too || force) {
            if (content.size()>0) {
                m_result_list->push_back(CPatternPair(name,content,QT_TO_STL_STRING(op)));
            } else {
                m_result_list->push_back(CPatternPair(name,QT_TO_STL_STRING(pat),QT_TO_STL_STRING(op)));
            }
        }
    }
    if (!status && m_result_list) {
        delete m_result_list;
        m_result_list = 0;
    }
    return status;
}

void CMultiTextInput::change_focus()
{
    focusNextPrevChild(true);
}

void CMultiTextInput::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
        e->accept();
        OkButton->animateClick();
        return;
    }
    if (e->key() == Key_Escape) {
        e->accept();
        CancelButton->animateClick();
        return;
    }
    if (e->isAccepted())
        return;
    QDialog::keyPressEvent(e);
}

void CMultiTextInput::handleBlobSettings()
{
    GlobalSettings.getBlobimages(m_BlobAsImage,m_ScaleBlob,
        m_blob_width,m_blob_height);
}

void CMultiTextInput::checkInput()
{
    if (!build_result()) {
        return;
    }
    accept();
}
