// -*-Mode: C++;-*- 
#ifndef CModifyTable_included
#define CModifyTable_included

#include "CreateTableData.h"
#include <qlineedit.h>
#include <qptrlist.h>
#include <qlayout.h>
#include "kmysqladmin/tabledescr.h"
#include "kmysqladmin/helpers/smart_pointer.h"

class CMySql;

class CModifyTable : public CCreateTableData
{
    Q_OBJECT

public:

    CModifyTable(smart_pointer<CMySql>&_sql_server,QWidget* parent = NULL,const char* name = NULL);
    virtual ~CModifyTable();

protected slots:
    virtual void SetFloat(int);
    virtual void Set_KeySize(int);
    virtual void SetDec(int);
    virtual void SetTypeInt(int);
    virtual void Set_AutoInc(bool);
    virtual void Set_KeyNone(bool);
    virtual void TableTextChanged(const QString&);
    virtual void TableTextActivate();
    virtual void NameChanged(const QString&);
    virtual void SetDBString(const QString&);
    virtual void AddColumn();
    virtual void Set_UniqueKey(bool);
    virtual void Set_Primary_Key(bool how);
    virtual void Set_MultiKey(bool how);
    virtual void ColumnSelected(int);
    virtual void Delete_Column();
    virtual void Modify_Column();
    virtual void Build_Compound();
    virtual void AddEnum();
    virtual void DelEnum();
    virtual void Set_ValNotNull(bool);

protected:
    smart_pointer<CMySql> sql_server;
    virtual bool _modify_column();
    virtual bool _add_column();

    stringlist CurrentTables;
    stringIlist enums;
    ColumnList desc_list;
    KeyList key_list;
    CKeyDescriptor current_key;
    void SetKey(bool how);
    int ReadDescriptor(CColumnDescriptor*col_target,QString*str_target,CKeyDescriptor*target_key);
    virtual void RemoveFromKey(const std::string&col_name,const bool compounds=false,const std::string&new_name="");
};
#endif // CModifyTable_included
