//
// C++ Interface: profiles_input
//
// Description: 
//
//
// Author: Rajko Albrecht <ral@alwins-world.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef PROFILES_INPUT_H
#define PROFILES_INPUT_H

#include "profiles_inputdata.h"
#include <qdialog.h>
#include <qmap.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>

/**
@author Rajko Albrecht
*/
class CProfilesInput : public CProfilesInputData
{
    Q_OBJECT
public:
    CProfilesInput(const QStringList&current_names,QWidget *parent = 0, const char *name = 0);
    CProfilesInput(const QMap<QString,QString>&aValues,const QStringList&current_names,QWidget *parent = 0, const char *name = 0);
    ~CProfilesInput();

    const QMap<QString,QString>&values()const;
protected:
    QStringList m_currentNames;
    QString m_ChangeName;
    bool m_EditMode;
    void checkOk();
    bool m_NameOk;
    bool m_PassOk;
    QMap<QString,QString> m_Values;
    
protected slots:
    virtual void keyPressEvent(QKeyEvent*e);
    virtual void focus_user();
    virtual void focus_port();
    virtual void focus_password();
    virtual void focus_password2();
    virtual void focus_ok();
    virtual void focus_host();
    virtual void nameChange(const QString&);
    virtual void passChange(const QString&);
    virtual void accept();

};

#endif
