#include <kapp.h>
#include <klocale.h>

#include <qstrlist.h>
#include <qlayout.h>

#include "ThreadView.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include "kmysqladmin/globals.h"
#include "kmysqladmin/stringres.h"
#include "kmysqladmin/setup/settings.h"
#include <qlistview.h>
#include <klocale.h>
#include <qpushbutton.h>

#define Inherited CListViewData

CThreadView::CThreadView(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    sql_server = _sql_server;
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(127);
    setCaption(head);
    setIcon(kapp->icon());
    m_Timeout = GlobalSettings.ThreadPolltime();
    ResetTimer = new QTimer(this);
    CHECK_PTR(ResetTimer);
    connect(ResetTimer,SIGNAL(timeout()),this,SLOT(RefreshList()));
    KillButton->setText(GET_TEXT(107));
    connect(&GlobalSettings,SIGNAL(threadtimer_changed(int)),this,SLOT(newTimeout(int)));
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(NewFixedFont()));
    viewList->setSorting(-1);
    viewList->setFont(GlobalSettings.get_fixed_font());
    resize( 650,150 );
}

CThreadView::~CThreadView()
{
}

void CThreadView::RefreshList()
{
    if (ResetTimer)
        ResetTimer->stop();
    if (!sql_server)
        return;
    list_vector list;
    if (!sql_server->get_threads(list))
        return;

    unsigned int count = 0;
    unsigned int max_count = viewList->columns();
    unsigned int rowCount = viewList->childCount();
    unsigned int rowCounter = 0;

    list_vector::iterator iter = list.begin();
    stringlist::iterator siter;
    QListViewItem*item = 0;
    QListViewItem*next = 0;

    item = viewList->firstChild();

    for (;iter != list.end();++iter) {
        if (rowCounter>=rowCount)
            break;
        siter = iter->begin();
        count = 0;
        for (;siter!=iter->end();++siter) {
            item->setText(count,siter->c_str());
            count++;
            if (count == max_count)
                break;
        }
        item = item->nextSibling();
        ++rowCounter;
    }
    for(;iter!=list.end();++iter) {
        item = new QListViewItem(viewList,item);
        siter = iter->begin();
        count = 0;
        for (;siter!=iter->end();++siter) {
            item->setText(count,siter->c_str());
            count++;
            if (count == max_count)
                break;
        }
        ++rowCounter;
    }
    if (rowCounter < rowCount) {
        while(item) {
            next = item->nextSibling();
            viewList->takeItem(item);
            item = next;
        }
    }
    if (ResetTimer)
        ResetTimer->start(m_Timeout * 1000,TRUE);
}

void CThreadView::hide_me()
{
    hide();
}

void CThreadView::hide()
{
    if (ResetTimer)
        ResetTimer->stop();
    Inherited::hide();
}

void CThreadView::show()
{
    RefreshList();
    Inherited::show();
}

void CThreadView::KillThread()
{
    QListViewItem* currentItem = viewList->selectedItem();
    if (!currentItem)
        return;
    QString s = currentItem->text(0);
    if (s.isEmpty())
        return;
    unsigned long pid = s.toULong();
    if (pid == 0)
        return;
    sql_server->kill_thread(pid);
    RefreshList();
}

void CThreadView::newTimeout(int aValue)
{
    m_Timeout = aValue;
}

void CThreadView::NewFixedFont()
{
    viewList->setFont(GlobalSettings.get_fixed_font());
}

void CThreadView::standalone(bool how)
{
    if (how) {
        CloseButton->show();
    } else {
        CloseButton->hide();
    }
}
