
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "devicedialog.h"

#include <kcombobox.h>
#include <klocale.h>
#include <qlabel.h>
#include <qhbox.h>

DeviceDialog::DeviceDialog(const QString& defaultDevice, QWidget* parent) :
        KDialogBase(parent, "device dialog", true,
        i18n("Select Network Device"), Ok|Cancel, Ok),
        device(defaultDevice) {
    QHBox* page = makeHBoxMainWidget();

    new QLabel(i18n("Network device to monitor:"), page);

    // Items in the combo box are not wrapped with i18n() since they're
    // literal interface names.
    KComboBox* deviceBox = new KComboBox(true, page);
    deviceBox->insertItem("lo");
    deviceBox->insertItem("eth0");
    deviceBox->insertItem("ippp0");
    deviceBox->insertItem("ppp0");
    deviceBox->setCurrentText(defaultDevice);

    connect(deviceBox, SIGNAL(textChanged(const QString&)),
        this, SLOT(updateDevice(const QString&)));
}

const QString& DeviceDialog::getDevice() const {
    return device;
}

void DeviceDialog::updateDevice(const QString& text) {
    device = text;
}

#include "devicedialog.moc"
