/***************************************************************************
                          tabmanager.h  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABMANAGER_H
#define TABMANAGER_H

#include <qobject.h>
#include <qptrlist.h>
#include <kapp.h>
#include <kconfig.h>
#include "tabbox.h"

/**
  *@author Troy Corbin Jr.
  */

typedef QPtrList<TabBox> TabBoxList;
class resource;

class TabManager : public QObject
{
	Q_OBJECT
	public:
								TabManager( resource *rsrc );
								~TabManager();
		void				addTab( QWidget *child, const QString &caption );
		void				childEvent( QChildEvent *event );
		void				changeCaption( QWidget *child, const QString &caption );
		void				showTab( QWidget *child );
		bool				isTab( QWidget *child );

	public slots:
		void				removeTab( QObject *child );

	protected slots:
		void				manageNewBox( TabBox *newBox );
		void				saveTabGeometry( const QString&, const QSize& );

	protected:
		TabBox*			getParentBox( QWidget* );

	private:
		TabBoxList	myList;
		KConfig			*appConfig;
		resource		*myResource;
};

#endif
