// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.16 $

#include "hk_kdeinterpreterdialog.h"
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmultilineedit.h>
#include <klocale.h>
#include <hk_actionquery.h>
#include <hk_connection.h>
#include <hk_visible.h>
#include <qapplication.h>
#include <kapplication.h>
#include <kconfig.h>

#include <kparts/genericfactory.h>
//#include "hk_kdegridpart.h"
#include <locale.h>

#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
class hk_kdeinterpreterdialogprivate
{
public:
        KAction*  p_closeaction;
        KAction*  p_printaction;
	KAction*  p_clearselectionaction;
	KAction*  p_toggleinsertaction;
	KAction*  p_undoaction;
};

/*
 *  Constructs a hk_kdeinterpreterdialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */

hk_kdeinterpreterdialog::hk_kdeinterpreterdialog(QWidget* w,const char* n,WFlags f):KParts::MainWindow(w,n,f|WType_Dialog|WShowModal)
{
p_private=new hk_kdeinterpreterdialogprivate;
in_loop=false;
rescode=Accepted;
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");

    setXMLFile(locate("data","hk_kdeclasses/hk_kdeinterpreterdialog.rc"));

    KLibFactory* p_factory= KLibLoader::self()->factory( "libkatepart" );
    p_katepart = (Kate::Document *) p_factory->create (0L, "kate", "KTextEditor::Document");
    p_designkate=(Kate::View *)p_katepart->createView (this, 0L);
    p_has_changed =false;
    setName( "hk_kdeinterpreterdialog" );
    resize( 596, 480 );
    p_factory= KLibLoader::self()->factory( "libhk_kdegridpart" );

//    p_design = new QMultiLineEdit(this);
    p_qbe = NULL;                                 //new QWidget(this);
    p_autoclose =true;
    p_private->p_printaction=new KAction(i18n("&Print"),"fileprint",0,this,SLOT(print()),actionCollection(),"print");
//p_printaction->setEnabled(false);
    p_private->p_closeaction=new KAction(i18n("&Close"),"fileclose",0,this,SLOT(accept()),actionCollection(),"closedialog");
    //p_private->p_selectallaction=new KAction( i18n("Select &All"), 0,0, this, SLOT( select_all() ) ,actionCollection(),"selectall");
    p_private->p_undoaction=new KAction(i18n("&Undo"),"undo",CTRL+Key_Z,this,SLOT(undo()),actionCollection(),"undo");
    p_private->p_undoaction->setEnabled(false);
        
    p_private->p_toggleinsertaction= new KAction(i18n("Toggle &Insert"),Key_Insert,this,SLOT(toggle_insert()),actionCollection(),"toggleinsert");
    KStdAction::replace(p_designkate,SLOT(replace()),actionCollection());
    KStdAction::find(p_designkate,SLOT(find()),actionCollection());
    KStdAction::findNext(p_designkate,SLOT(findAgain()),actionCollection());
    KStdAction::findPrev(p_designkate,SLOT(findPrev()),actionCollection());
    KStdAction::selectAll(this,SLOT(select_all()),actionCollection());
    KStdAction::gotoLine(p_designkate,SLOT(gotoLine()),actionCollection());
    KStdAction::copy(p_designkate,SLOT(copy()),actionCollection());
    KStdAction::paste(p_designkate,SLOT(paste()),actionCollection());
    KStdAction::cut(p_designkate,SLOT(cut()),actionCollection());
    p_private->p_clearselectionaction=new KAction( i18n("Dese&lect"), 0,0, this, SLOT( clear_selection() ) ,actionCollection(),"clearselection");
    setCentralWidget(p_designkate);
    createGUI(p_katepart);

    connect( p_designkate->getDoc(), SIGNAL( textChanged() ), this, SLOT( slot_has_changed() ) );
    p_designkate->setLineNumbersOn(true);
    connect(p_designkate->getDoc(), SIGNAL(undoChanged()), this, SLOT(slot_undo_changed()));
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Interpreter");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdeinterpreterdialog::~hk_kdeinterpreterdialog()
{
// no need to delete child widgets, Qt does it all for us
hide();
setCentralWidget(NULL);
delete p_designkate;
delete p_katepart;
delete p_private->p_closeaction;
delete p_private;
}






void hk_kdeinterpreterdialog::closeEvent ( QCloseEvent* e)
{
	e->accept();
	accept();
}





void hk_kdeinterpreterdialog::savebutton_clicked(void)
{
    set_caption();
}


void hk_kdeinterpreterdialog::saveasbutton_clicked(void)
{


}




void hk_kdeinterpreterdialog::set_caption(void)
{

}


void hk_kdeinterpreterdialog::print(void)
{

// this is a workaround: otherwise float numbers in the postscript file
// would be created with locale dots (e.g. a comma in Germany) from Qt
        hk_string origlocale=setlocale(LC_NUMERIC,NULL);
        hk_string origmonetarylocale=setlocale(LC_MONETARY,NULL);
        setlocale(LC_NUMERIC,"C");
        setlocale(LC_MONETARY,"C");
        p_designkate->getDoc()->printDialog();
//workaround part 2
        setlocale(LC_NUMERIC,origlocale.c_str());
        setlocale(LC_MONETARY,origmonetarylocale.c_str());
//workaround part 2 end
}


void    hk_kdeinterpreterdialog::keyPressEvent ( QKeyEvent * e )
{
      if (e->state()&ControlButton)
    {
        switch (e->key())
        {
            case Key_C :
	        {           //copy
		p_designkate->copy();
		}
                break;
            case Key_V :   //paste
            {
	        p_designkate->paste();
                break;
            }
            case Key_X :   //cut
            {
	       p_designkate->cut();

                break;
            }
	    /*case Key_Z :
	    {
		p_katepart->undo();
		break;
            }*/
	    default:;

        }

    } // ende->state()&ControlButton


  KParts::MainWindow::keyPressEvent(e);
}



void hk_kdeinterpreterdialog::done( int r )
{
KConfig* c=kapp->config();
  c->setGroup("Interpreter");
  c->writeEntry("Geometry",geometry());
  
cerr <<"done close Interpreter"<<endl;
    hide();
    setResult( r );
    //close();
        // emulate QWidget::close()
    if ( qApp->mainWidget() == this )
	qApp->quit();
    else if ( testWFlags(WDestructiveClose) ) {
	clearWFlags(WDestructiveClose);
	deleteLater();
    }

}


int hk_kdeinterpreterdialog::exec(int rownumber,const hk_string& w)
{
    if ( in_loop ) {
	qWarning( "hk_kdeinterpreterdialog::exec: Recursive call detected." );
	return -1;
    }

    bool destructiveClose = testWFlags( WDestructiveClose );
    clearWFlags( WDestructiveClose );

    bool wasShowModal = testWFlags( WShowModal );
    setWFlags( WShowModal );
    setResult( 0 );

    if (hk_visible::open_maximized_windows())
    	showMaximized();
    else show();
    unsigned int i=0;
    Kate::Document *doc = p_designkate->getDoc();
    p_designkate->gotoLineNumber(rownumber);
            while (i<doc->hlModeCount())
        {//cerr <<"mode: "<<doc->hlModeName(i)<<endl;
            if (doc->hlModeName(i)=="Python")
            {
                doc->setHlMode(i);
            }
            ++i;
        }
    if (w.size()>0) hk_class::show_warningmessage(w);
    in_loop = TRUE;
    qApp->enter_loop();

    if ( !wasShowModal )
	clearWFlags( WShowModal );

    int res = result();
    if ( destructiveClose )
      delete this;
return res;

}


void hk_kdeinterpreterdialog::accept()
{

    done( Accepted );
}

/*!
  Hides the modal dialog and sets the result code to \c Rejected.
  \sa accept() done()
*/

void hk_kdeinterpreterdialog::reject()
{
    done( Rejected );
}



hk_string hk_kdeinterpreterdialog::code(void)
{
return p_designkate->getDoc()->text().local8Bit().data();

}
void hk_kdeinterpreterdialog::set_code(const hk_string& c,bool registerchange)
{
if(!registerchange)p_designkate->getDoc()->blockSignals(true);
p_designkate->getDoc()->setText(c.c_str());
p_designkate->getDoc()->clearUndo();
if(!registerchange)p_designkate->getDoc()->blockSignals(false);
}

void hk_kdeinterpreterdialog::hide()
{
    if ( isHidden() )
	return;


    QWidget::hide();
    if ( in_loop ) {
	in_loop = FALSE;
	qApp->exit_loop();
    }
}
void hk_kdeinterpreterdialog::slot_has_changed(void)
{
 p_has_changed=true;
}


void hk_kdeinterpreterdialog::clear_selection()
{
p_katepart->clearSelection();

}

void hk_kdeinterpreterdialog::select_all(void)
{
p_katepart->selectAll();
}

void hk_kdeinterpreterdialog::toggle_insert(void)
{
p_designkate->setOverwriteMode(!p_designkate->isOverwriteMode());
}

void hk_kdeinterpreterdialog::set_caption(hk_visible* v,const hk_string& action)
{
QString txt;
if (v)
   {
     txt=QString::fromLocal8Bit(v->identifier().c_str());
     QString n;n.setNum(v->presentationnumber());
     txt+=" ("+n+")";
     txt+=" - ";
   }

   txt+=QString::fromLocal8Bit(action.c_str());
   setCaption(txt);
}


void hk_kdeinterpreterdialog::undo(void)
{
p_katepart->undo();
}

void hk_kdeinterpreterdialog::slot_undo_changed(void)
{
  p_private->p_undoaction->setEnabled(p_designkate->getDoc()->undoCount()>0);
}
