// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.53 $
#include <hk_datasource.h>
#include <hk_kdecombobox.h>
#include <hk_kdecombobox.moc>
#include <hk_form.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <kglobalsettings.h>

class qlineedit:public QLineEdit
{
public:
   qlineedit(hk_kdecombobox* c):QLineEdit(c){p_combobox=c;}
  virtual ~qlineedit(){}
        virtual void            mousePressEvent(QMouseEvent* e)
	{
                  p_combobox->mousePressEvent(e);
	}
        virtual void            mouseDoubleClickEvent(QMouseEvent*e)
	{
                 p_combobox->mouseDoubleClickEvent(e);
	}

hk_kdecombobox* p_combobox;
};


hk_kdecombobox::hk_kdecombobox(QWidget* wid,hk_form* form):QComboBox(wid),hk_dscombobox(form)
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug("hk_kdecombobox::hk_kdecombobox");
#endif
    p_widget_specific_row_change=true;
    p_whiledatachange=false;
    setEditable(true);
    setAutoCompletion(true);
    setDuplicatesEnabled(false);
    setEnabled(false);
    setInsertionPolicy(NoInsertion);

    QColor qcolor=paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);

    connect(this,SIGNAL(activated(int)),this,SLOT(slot_data_changed(int)));
    connect(this,SIGNAL(textChanged( const QString& )),this,SLOT(slot_text_changed()));
    widget_specific_font_changed();
    setLineEdit( new qlineedit(this));

}


hk_kdecombobox::~hk_kdecombobox()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdecombobox::~hk_kdecombobox");
#endif

}


void hk_kdecombobox::slot_data_changed(int index)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::slot_data_changed");
#endif
#ifdef HK_DEBUG
    hkdebug("kdecombobox::data has changed!");
#endif
    set_selecteditemdata(index);

}


void hk_kdecombobox::slot_text_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::slot_text_changed");
#endif
    int f=find_edittextitem();
    if (f>-1||viewcolumn()==NULL)
        set_selecteditemdata(f);

}


bool hk_kdecombobox::widget_specific_row_change(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::widget_specific_row_change");
#endif
    hk_column* c=column();
    p_widget_specific_row_change=true;
    if (c!=NULL)
    {
        hk_dscombobox::widget_specific_row_change();
    }

    if (mode()==selector)
    {
        blockSignals(true);
        setCurrentItem(datasource()->row_position());
        blockSignals(false);

    }

    p_widget_specific_row_change=false;
    return true;
}


void hk_kdecombobox::widget_specific_enable_disable()
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::widget_specific_enable_disable");
#endif
    if ((datasource()!=NULL)&&((column()!=NULL)||mode()==selector))
    {
#ifdef HK_DEBUG
        hkdebug("kdecombobox::if ((datasource()!=NULL)&&(column()!=NULL))");
#endif

        if (datasource()->is_enabled()>0)
        {

            setEnabled(true);
            setAutoCompletion(true);

        }
        else setEnabled(false);
    }
    else
    {
        setEnabled(false);
    }
    setFocusPolicy(StrongFocus);

}


bool hk_kdecombobox::datasource_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::datasource_enable");
#endif
    bool erg=hk_dscombobox::datasource_enable();
    load_listitems();
    return erg;
}


bool hk_kdecombobox::datasource_disable(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::datasource_disable");
#endif
    before_row_change();
    clear();                                      //clears the columnbox
    if (listdatasource()!=NULL&& mode()==combo) listdatasource()->disable();
    return hk_dsdatavisible::datasource_disable();

}


void hk_kdecombobox::set_currentlistitem(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::set_currentlistitem");
#endif
    if (datasource()==NULL) return;
    if (column()==NULL) return;
    setEditText(QString::fromLocal8Bit (value_at(datasource()->row_position()).c_str()));
}


void hk_kdecombobox::set_selecteditemdata(int index)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::set_selecteditemdata");
#endif
    if (mode()==selector)
    {
        selector_row_changed(index);
        return;
    }

    if (column()==NULL) return;

    blockSignals(true);
    if (lineEdit()!=NULL) lineEdit()->blockSignals(true);

    if((listcolumn()==NULL)||(listdatasource()==NULL)||(viewcolumn()==NULL))
    {
#ifdef HK_DEBUG
        hkdebug("kdecombobox::set_selecteditemdata listcolumn==NULL");
#endif
        p_whiledatachange=true;
	column()->set_asstring(currentText().local8Bit().data(),true,true);
	p_whiledatachange=false;
        blockSignals(false);
        if (lineEdit()!=NULL) lineEdit()->blockSignals(false);
        return;
    }
    unsigned int r=viewcolumn()->find(text(index).local8Bit().data(),true);
    if (r<listdatasource()->max_rows())
    {
#ifdef HK_DEBUG
        hkdebug("r= ",(int)r);
        hkdebug(viewcolumn()->asstring_at(r,true),listcolumn()->asstring_at(r,true));
#endif
        p_whiledatachange=true;
	column()->set_asstring(listcolumn()->asstring_at(r,false),true,false);
	p_whiledatachange=false;
    }
/*    clear();
    for (unsigned int k=0;k<listdatasource()->max_rows();k++) insertItem(QString::fromLocal8Bit (viewcolumn()->asstring_at(k,true).c_str()));

    setEditText(QString::fromLocal8Bit (viewcolumn()->asstring_at(r,true).c_str()));*/
    blockSignals(false);
    if (lineEdit()!=NULL) lineEdit()->blockSignals(false);
}


bool hk_kdecombobox::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
    setGeometry(px,py,pwidth,pheight);
    qApp->processEvents();
    return true;
}


void hk_kdecombobox::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::resizeEvent");
#endif
    QComboBox::resizeEvent(event);
    reposition();

}


void hk_kdecombobox::keyPressEvent(QKeyEvent * e)
{
    QComboBox::keyPressEvent(e);
/*  if (!e->isAccepted())
     if (datasource()&&datasource()->is_enabled())
        e->accept();*/
}


void  hk_kdecombobox::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::resizeEvent");
#endif
    QComboBox::moveEvent(event);
    reposition();
}


void hk_kdecombobox::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QComboBox::x()):QComboBox::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QComboBox::y()):QComboBox::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QComboBox::height()):QComboBox::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QComboBox::width()):QComboBox::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}


void    hk_kdecombobox::widget_specific_insert_mode(void)
{
    blockSignals(true);
    setCurrentItem(0);
    setEditText("");
    blockSignals(false);
}


void  hk_kdecombobox::load_listitems(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::load_listitems");
#endif
   if(p_whiledatachange) return;
    blockSignals(true);
    clear();
    if  (listdatasource()==NULL)
    {
#ifdef HK_DEBUG
        hkdebug("kdecombobox::load_listitems listdatasource==NULL");
#endif
	set_currentlistitem();
//cout <<"listdatasource==NULL"<<endl;
        blockSignals(false);
        return;
    }
    unsigned int r=listdatasource()->max_rows();
    if (viewcolumn()!=NULL)
    {
        for (unsigned int k=0;k<r;k++)
        {
            insertItem(QString::fromLocal8Bit (viewcolumn()->asstring_at(k,true).c_str()));
        }
    };
    set_currentlistitem();
    blockSignals(false);
}


void hk_kdecombobox::widget_specific_row_added(void)
{
    widget_specific_row_change();
}


void hk_kdecombobox::widget_specific_row_deleted(void)
{
    widget_specific_row_change();
}


int     hk_kdecombobox::find_edittextitem(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::find_edittextitem");
#endif
    QString value;
    if (lineEdit()!=NULL)value= lineEdit()->text();
    for (int i=0;i<count();i++)
    {
        if (value==text(i))
        {
#ifdef HK_DEBUG
            hkdebug("kdecombobox::find_edittextitem value found",i);
#endif
            return i;
        }
    }
#ifdef HK_DEBUG
    hkdebug("kdecombobox::find_edittextitem value not found");
#endif

    return -1;
}


void    hk_kdecombobox::widget_specific_mode_change(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::widget_specific_mode_change");
#endif
    if (mode()==combo)
    {
        setEditable(true);

    }
    else
    {

        setEditable(false);

    }

}


void hk_kdecombobox::selector_row_changed(int index)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::selector_row_changed");
#endif
    if (listdatasource()) listdatasource()->goto_row(index);

}


void    hk_kdecombobox::after_store_changed_data(void)
{
#ifdef HK_DEBUG
    hkdebug("kdecombobox::after_store_changed_data");
#endif
    hk_dscombobox::after_store_changed_data();
    if (mode()==selector) setCurrentItem(datasource()->row_position());

}


void hk_kdecombobox::widget_specific_font_changed(void)
{
    setFont(QFont(QString::fromLocal8Bit (hk_dscombobox::font().fontname().c_str())
                  ,hk_dscombobox::font().fontsize(),hk_dscombobox::font().bold()?QFont::Bold:QFont::Normal,
		   hk_dscombobox::font().italic()));
}


void    hk_kdecombobox::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteBackgroundColor(newcolour);

}


void    hk_kdecombobox::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
//setPaletteForegroundColor(newcolour);
    QPalette pl=palette();
    pl.setColor(QPalette::Active,QColorGroup::Text,newcolour);
    setPalette(pl);

}


void  hk_kdecombobox::mousePressEvent(QMouseEvent* event)
{
   QComboBox::mousePressEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_click();
}



void  hk_kdecombobox::mouseDoubleClickEvent(QMouseEvent* event)
{
   QComboBox::mouseDoubleClickEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_doubleclick();
}



void hk_kdecombobox::set_value(const hk_string&v)
{
    setEditText(QString::fromLocal8Bit (v.c_str()));

}


hk_string hk_kdecombobox::value(void)
{
  return currentText().local8Bit().data();
}


void	hk_kdecombobox::presentationmode_changed(void)
{
hk_dscombobox::presentationmode_changed();
if (!p_presentation) return;
if (p_presentation->mode()==hk_presentation::designmode)
   {
    setEnabled(false);
        blockSignals(true);
        setEditText("");
        blockSignals(false);
   }
 else
 {
   setEnabled(true);
 }

}

