// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.55 $
#include <hk_kdelineedit.h>
#include <hk_kdelineedit.moc>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <klocale.h>
#include "hk_kdefinddialog.h"

hk_kdelineedit::hk_kdelineedit(QWidget* wid,hk_form* form)
:KLineEdit(wid)
,hk_dslineedit(form)
{
    QObject::connect(this,SIGNAL(textChanged(const QString& )),this,SLOT(slot_data_changed()));
#ifdef HK_DEBUG
    hkclassname("hk_kdelineedit");
    hkdebug("hk_kdelineedit::hk_kdelineedit");
#endif
    p_widget_specific_row_change=true;
    setEnabled(false);
    set_alignment(hk_dslineedit::alignment(),false);
    p_finddialog=NULL;
    p_findfirstview=true;
    findpopupid=0;

    QColor qcolor=paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);

    widget_specific_font_changed();

}


hk_kdelineedit::~hk_kdelineedit()
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::destructor");
#endif
    p_widget_specific_row_change=true;

}


void hk_kdelineedit::keyPressEvent( QKeyEvent * e )
{
    if (e->key()==Key_Return)
    {
        if (e->state()&ControlButton)
            focusNextPrevChild(false);
        else
            focusNextPrevChild(true);

    }
    else
    {

       // if (column()!=NULL)
        {
            if (e->key()==Key_F && e->state()&ControlButton) find_clicked(findpopupid);
            else
            if ((column()&&column()->is_readonly())||is_readonly())
            {
                switch (e->key())
                {
                    case Key_Left:
                    case Key_Right:
                    case Key_Home:
                    case Key_End:
                    case Key_Return: break;
                    case Key_C: if (e->state()&ControlButton)
                    {                             //Copy pressed
                        break;
                    }

                    default: return;
                }
            }
        }
        QLineEdit::keyPressEvent(e);
    }
}


void hk_kdelineedit::slot_data_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::slot_data_changed");
#endif
    if (!p_widget_specific_row_change)
    {
#ifdef HK_DEBUG
        hkdebug("kdelineedit::data has changed!");
#endif
        if (column()!=NULL)
        {
#ifdef HK_DEBUG
            hkdebug("kdelineedit::data will be updated");
#endif
            if (is_numerictype(column()))
                column()->set_asstring(format_number(text().local8Bit().data(),true,use_numberseparator(),commadigits(),locale()),true,true);
            else column()->set_asstring(text().local8Bit().data(),true,true);
        }
    }
}


bool hk_kdelineedit::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::widget_specific_coordinates");
#endif
    setGeometry(px,py,pwidth,pheight);
    qApp->processEvents();

    return true;
}


bool hk_kdelineedit::widget_specific_row_change(void)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::widget_specific_row_change");
#endif
    hk_column* c=column();
    p_widget_specific_row_change=true;
    if (datasource()!=NULL)
        if (c!=NULL)
    {
        hk_string v=datasource()->mode()==hk_datasource::mode_insertrow?
            use_defaultvalue()?defaultvalue():"":
        (c->has_changed()?c->changed_data_asstring():c->asstring(true));
        if (is_numerictype(c)&&c->columntype()!=hk_column::auto_inccolumn&&v.length()>0
            || (c->columntype()==hk_column::auto_inccolumn
            && datasource()->mode()!=hk_datasource::mode_insertrow))
        {
            v=format_number(v,true,use_numberseparator(),commadigits(),locale());
        }

        setText(QString::fromLocal8Bit (v.c_str()));
        if (hk_dsdatavisible::alignment()==hk_dsdatavisible::alignleft)
            setCursorPosition(0);
    }

    p_widget_specific_row_change=false;
    return true;
}


void hk_kdelineedit::widget_specific_enable_disable()
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::widget_specific_enable_disable");
#endif
    if ((datasource()!=NULL)&&(column()!=NULL))
    {
#ifdef HK_DEBUG
        hkdebug("kdelineedit::if ((datasource()!=NULL)&&(column()!=NULL))");
#endif

        if (datasource()->is_enabled())
        {
            if (column() && column()->columntype()==hk_column::textcolumn) setMaxLength(column()->size());
            else setMaxLength(32767);

            setEnabled(true);
            widget_specific_row_change();
        }
        else setEnabled(false);
    }
    else
    {
        setEnabled(true);
	if (datasource()&&!datasource()->is_enabled()) setEnabled(false);
        blockSignals(true);
        setText("");
        blockSignals(false);
    }

}


bool hk_kdelineedit::datasource_disable()
{
    bool erg=hk_dsdatavisible::datasource_disable();
    widget_specific_enable_disable();
    return erg;
}


bool hk_kdelineedit::datasource_enable()
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::datasource_enable");
#endif
    bool erg=hk_dsdatavisible::datasource_enable();
    widget_specific_enable_disable();
    return erg;
}


void hk_kdelineedit::datasource_delete(void)
{
    setText("");
    hk_dsdatavisible::datasource_delete();

}


void    hk_kdelineedit::widget_specific_insert_mode(void)
{
//  widget_specific_row_change();
    blockSignals(true);
    setText(QString::fromLocal8Bit (use_defaultvalue()?defaultvalue().c_str():""));
    blockSignals(false);
}


void hk_kdelineedit::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::resizeEvent");
#endif
    KLineEdit::resizeEvent(event);
    reposition();

}


void  hk_kdelineedit::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::resizeEvent");
#endif
    KLineEdit::moveEvent(event);
    reposition();
}

void  hk_kdelineedit::mousePressEvent(QMouseEvent* event)
{
   KLineEdit::mousePressEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_click();
}



void  hk_kdelineedit::mouseDoubleClickEvent(QMouseEvent* event)
{
   KLineEdit::mouseDoubleClickEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_doubleclick();
}



void hk_kdelineedit::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(KLineEdit::x()):KLineEdit::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(KLineEdit::y()):KLineEdit::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(KLineEdit::height()):KLineEdit::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(KLineEdit::width()):KLineEdit::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}


void hk_kdelineedit::widget_specific_font_changed(void)
{
    setFont(QFont(QString::fromLocal8Bit (hk_dslineedit::font().fontname().c_str())
                  ,hk_dslineedit::font().fontsize(),hk_dslineedit::font().bold()?QFont::Bold:QFont::Normal,
		   hk_dslineedit::font().italic()));
}


void hk_kdelineedit::widget_specific_row_added(void)
{
    widget_specific_row_change();
}


void hk_kdelineedit::widget_specific_row_deleted(void)
{
    widget_specific_row_change();
}


void hk_kdelineedit::widget_specific_alignment(void)
{
    Qt::AlignmentFlags f;
    switch (hk_dslineedit::alignment())
    {
        case alignright  : f= Qt::AlignRight;
        break;
        case aligncenter  : f= Qt::AlignHCenter;
        break;
        default       : f= Qt::AlignLeft;

    }
    setAlignment(f);

}


QPopupMenu* hk_kdelineedit::createPopupMenu()

{
    QPopupMenu* popup=QLineEdit::createPopupMenu();
    hk_column* c=column();
    if (c  && !c->is_readonly()&&!c->is_notnull())
    {
        findpopupid=popup->insertItem(i18n("Find"));
        popup->insertSeparator();
        NULLpopupid=popup->insertItem( i18n( "set 'NULL' value" ) );
        connect( popup, SIGNAL(activated(int)), SLOT(NULLselected(int)) );
        connect( popup, SIGNAL(activated(int)), SLOT(find_clicked(int)) );

    }

    return popup;

}


void    hk_kdelineedit::NULLselected( int r )
{

    hk_column* c=column();
    if (c  && NULLpopupid==r)
    {
        c->set_asnullvalue();
        widget_specific_row_change();
    }

}


void hk_kdelineedit::find_clicked(int r)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::find_clicked");
#endif
    if (!column()||findpopupid!=r) return;
    if (p_finddialog==NULL)
    {
        p_finddialog=new hk_kdefinddialog(this,0,false);
        connect(p_finddialog, SIGNAL(signal_findbutton_clicked()),this,SLOT(find_next()));
        connect(p_finddialog, SIGNAL(signal_findargument_changed()),this,SLOT(findargument_changed()));
    }

    p_findfirstview=true;
    findargument_changed();
    p_finddialog->show();
}


void    hk_kdelineedit::find_next(void)
{
#ifdef HK_DEBUG
    hkdebug("kdelineedit::find_next");
#endif
    bool search=true;
    if (p_finddialog==NULL)return;
    while (search)
    {
        if (p_finddialog->all_columnsbox->isChecked())
        {
            cout <<"noch nicht eingebaut"<<endl;
            search=false;
        }

        else
        {
            hk_column* c= column();
            if (c==NULL) return;
            unsigned int from=0;
            unsigned int to=0;
            if (p_finddialog->find_backwardsbox->isChecked())
            {

                from=0;
                to=((datasource()->row_position()>0)&&!p_findfirstview)?
                    datasource()->row_position()-1:
                (p_findfirstview?datasource()->row_position():datasource()->max_rows()-1);
            }
            else
            {
                from=((datasource()->row_position()<datasource()->max_rows()-2)&&!p_findfirstview)?
                    datasource()->row_position()+1:
                (p_findfirstview?datasource()->row_position():0);
                to=datasource()->max_rows()-1;
            }

            unsigned int r=c->find( from,
                to,
                p_finddialog->searchfield->currentText().local8Bit().data(),
                !p_finddialog->part_of_columnbox->isChecked(),
                p_finddialog->case_sensitivebox->isChecked(),
                p_finddialog->find_backwardsbox->isChecked()
                );
            if (r<datasource()->max_rows())
            {
                datasource()->goto_row(r);
                search=false;
            }
            else
            {
                if (!p_findfirstview)
                {
                    show_warningmessage(hk_translate("Not found."));
                    search=false;
                    return;
                }
                else
                {
                    datasource()->goto_first();
                }

            }
        }

        p_findfirstview=false;
    }

}


void hk_kdelineedit::findargument_changed(void)
{
    p_findfirstview=true;

}


void    hk_kdelineedit::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteBackgroundColor(newcolour);

}


void    hk_kdelineedit::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteForegroundColor(newcolour);

}


void hk_kdelineedit::set_value(const hk_string&v)
{
 hk_column* c=column();
 if (c)c->set_asstring(v);
 else setText(QString::fromLocal8Bit (v.c_str()));

}

hk_string hk_kdelineedit::value(void)
{
  if (!column()) return text().local8Bit().data();
  else return hk_dslineedit::value();
}


void	hk_kdelineedit::presentationmode_changed(void)
{
hk_dslineedit::presentationmode_changed();
if (!p_presentation) return;
if (p_presentation->mode()==hk_presentation::designmode)
   {
    setEnabled(false);
        blockSignals(true);
        setText("");
        blockSignals(false);
   }
 else
 {
   setEnabled(true);
 }

}

