// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.89 $
#include "hk_kdeproperty.h"
#include "hk_visible.h"
#include "hk_dsvisible.h"
#include "hk_dsdatavisible.h"
#include "hk_kdeformdatasourcedialog.h"
#include "hk_kdesimpleform.h"
#include "hk_kdespinbox.h"
#include "hk_kdelabel.h"
#include "hk_kdereportconditiondialog.h"
#include "hk_kdeinterpreterdialog.h"
#include <hk_database.h>
#include <hk_colour.h>
#include <hk_button.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qfontdatabase.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qcolor.h>
#include <hk_datasource.h>
#include <hk_dscombobox.h>
#include <klocale.h>
#include <kcolorbutton.h>

/*
 *  Constructs a hk_kdeproperty which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdeproperty::hk_kdeproperty( hk_kdesimpleform* parent,  const char* name, bool modal, WFlags fl )
: hk_kdepropertyeditorbase( parent, name, modal, fl )  , hk_class()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::hk_kdeproperty");
#endif
    QString no=i18n("no");
    QString yes=i18n("yes");
    p_form=parent;
    p_visible=NULL;
    widthfield->setRange(0,10000);
    heightfield->setRange(0,10000);
    xfield->setRange(0,10000);
    yfield->setRange(0,10000);
    p_fontdatabase = new QFontDatabase();
    fontfield->insertStringList(p_fontdatabase->families());
    actionfield->insertItem("");
    actionfield->insertItem(i18n("Open form"));
    actionfield->insertItem(i18n("Close form"));
    actionfield->insertItem(i18n("Open table"));
    actionfield->insertItem(i18n("Open query"));
    actionfield->insertItem(i18n("Preview report"));
    actionfield->insertItem(i18n("Print report"));
    actionfield->insertItem(i18n("Goto first row"));
    actionfield->insertItem(i18n("Goto last row"));
    actionfield->insertItem(i18n("Goto next row"));
    actionfield->insertItem(i18n("Goto previous row"));
    actionfield->insertItem(i18n("Insert row"));
    actionfield->insertItem(i18n("Delete row"));
    actionfield->insertItem(i18n("Store row"));
    actionfield->insertItem(i18n("Execute actionquery"));
    //actionfield->insertItem(i18n("Execute script"));

    actionfield->setCurrentItem(0);
    tab->changeTab(tab_3,i18n("&Format"));
    tab->changeTab(tab_2,i18n("&Data"));
    tab->changeTab(tab_4,i18n("&Action"));
    labellabel->setText(i18n("Label:"));
    xlabel->setText(i18n("X:"));
    ylabel->setText(i18n("Y:"));
    widthlabel->setText(i18n("Width:"));
    heightlabel->setText(i18n("Height:"));
    fontlabel->setText(i18n("Font:"));
    fontsizelabel->setText(i18n("Fontsize:"));
    datasourcelabel->setText(i18n("Datasource:"));
    columnlabel->setText(i18n("Column:"));
    actionlabel->setText(i18n("Action:"));
    objectlabel->setText(i18n("Object:"));
    defaultlabel->setText(i18n("Default value:"));
    digitfield->setRange(-1,10);

    listdatasourcelabel->setText(i18n("Listdatasource:"));
    listcolumnlabel->setText(i18n("Listcolumn:"));
    viewcolumnlabel->setText(i18n("Viewcolumn:"));

    showmaximizedlabel->setText(i18n("show maximized:"));
    showmaximizedfield->insertItem(no);
    showmaximizedfield->insertItem(yes);
    separatorfield->insertItem(yes);
    separatorfield->insertItem(no);

    readonlyfield->insertItem(yes);
    readonlyfield->insertItem(no);

    alignmentlabel->setText(i18n("Alignment:"));
    alignmentfield->insertItem(i18n("Left"));
    alignmentfield->insertItem(i18n("Center"));
    alignmentfield->insertItem(i18n("Right"));
    alignmentfield->insertItem(i18n("Default"));
    connect( alignmentfield, SIGNAL( activated(const QString&) ), this, SLOT( format_changes() ) );
    connect( alignmentfield, SIGNAL( textChanged(const QString&) ), this, SLOT( format_changes() ) );
    digitlabel->setText(i18n("Precision:"));
    separatorlabel->setText(i18n("Separator:"));
    boldfield->insertItem(yes);
    boldfield->insertItem(no);
    italicfield->insertItem(yes);
    italicfield->insertItem(no);
    boldlabel->setText(i18n("Bold:"));
    italiclabel->setText(i18n("Italic:"));
    p_foregroundcolourlabel->setText( i18n( "Foregroundcolour" ) );
    p_backgroundcolourlabel->setText( i18n( "Backgroundcolour" ) );
    toplinefield->set_displaytype(hk_kdespinbox::pixels);
    bottomlinefield->set_displaytype(hk_kdespinbox::pixels);
    leftlinefield->set_displaytype(hk_kdespinbox::pixels);
    rightlinefield->set_displaytype(hk_kdespinbox::pixels);
    diagonallurofield->set_displaytype(hk_kdespinbox::pixels);
    diagonallorufield->set_displaytype(hk_kdespinbox::pixels);
    toplinefield->setLineStep(1);
    bottomlinefield->setLineStep(1);
    leftlinefield->setLineStep(1);
    rightlinefield->setLineStep(1);
    diagonallurofield->setLineStep(1);
    diagonallorufield->setLineStep(1);


    connect( p_foregroundcolourbutton, SIGNAL( changed(const QColor&) ), this, SLOT( format_changes() ) );
    connect( p_backgroundcolourbutton, SIGNAL( changed(const QColor&) ), this, SLOT( format_changes() ) );
    settxt=i18n("set");
    notsettxt=i18n("not set");
}



/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdeproperty::~hk_kdeproperty()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::~hk_kdeproperty");
#endif
    delete  p_fontdatabase;
}


/*
 * public slot
 */
void hk_kdeproperty::action_changes()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::action_changes()");
#endif
//cerr <<"action_changes"<<endl;
    if (p_form==NULL) return;
    if (p_form->database()==NULL)return;
    set_actionobjectlist();
    set_objectaction();
}


void hk_kdeproperty::set_actionobjectlist(void)
{
    objectfield->clear();
    int i = actionfield->currentItem()-1; //cerr <<"set_actionobjectlist i="<<i<<endl;
    vector<hk_string>* liste=NULL;
    objectfield->insertItem("");
    if (i==2)  liste=p_form->database()->tablelist();
    else
    if (i==3||i==13)  liste=p_form->database()->querylist();
        else
        if (i==4||i==5)  liste=p_form->database()->reportlist();
            else
            if (i==0||i==1)  liste=p_form->database()->formlist();
                if (liste==NULL) return;
    vector<hk_string>::iterator it =  liste->begin();
    while (it!=liste->end())
    {
        objectfield->insertItem(QString::fromLocal8Bit ((*it).c_str()));
        it++;
    }
    objectfield->setCurrentItem(0);

}


void hk_kdeproperty::actionobject_changes()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::action_changes()");
#endif
    if (p_visible==NULL) return;
    if (p_visible->type()==hk_visible::button) set_objectaction();
}


/*
 * public slot
 */
void hk_kdeproperty::data_changes()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::data_changes()");
#endif
    if (p_visible==NULL) return;
    switch (p_visible->type())
    {
        case hk_visible::lineedit:;
        case hk_visible::boolean:;
        case hk_visible::memo:;
        case hk_visible::combobox:;
        set_objectdsdatavisible();

        case hk_visible::form:
        case hk_visible::grid:
        case hk_visible::button:
        case hk_visible::rowselector:
            set_objectdsvisible();
        default:;

    }
}


void hk_kdeproperty::identifier_changed(void)
{

hk_string t=identifierfield->text().local8Bit().data();
if (p_visible->identifier()!=t) p_visible->set_identifier(t);


}

/*
 * public slot
 */
void hk_kdeproperty::format_changes()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::format_changes()");
#endif
    set_objectvisible();
}

void hk_kdeproperty::geometry_changes()
{
    if (!p_visible) return;
    if (p_visible->type()==hk_visible::form)
    {
        hk_form* f=dynamic_cast <hk_form*>(p_visible);
        if (f!=NULL)
        {
            f->set_designsize(widthfield->value(),heightfield->value());
        }
    }
    else
    {
	p_visible->set_size(xfield->value(),yfield->value(),widthfield->value(),heightfield->value());

    }


}

/*
 * public slot
 */
void hk_kdeproperty::set_object(hk_visible* v)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_object");
#endif
    p_visible=v;
    tab_2->setEnabled(false);
    tab_3->setEnabled(false);
    tab_4->setEnabled(true);
    actionfield->setEnabled(false);
    xfield->setEnabled(true);
    yfield->setEnabled(true);
    fontfield->setEnabled(true);
    fontsizefield->setEnabled(true);
    boldfield->setEnabled(true);
    italicfield->setEnabled(true);
    conditionbutton->setEnabled(false);
	frametab->setEnabled(false);
    if (p_visible==NULL) return;
    QString head;
    head.setNum(p_visible->presentationnumber());

    setCaption(i18n("Property editor (")+head+")");
    tab_3->setEnabled(true);
    datasourcefield->setEnabled(true);
    readonlyfield->setEnabled(true);
    columnfield->setEnabled(false);
    defaultfield->setEnabled(false);
    listcolumnfield->setEnabled(false);
    viewcolumnfield->setEnabled(false);
    combomodefield->setEnabled(false);
    listdatasourcefield->setEnabled(false);
    listdatasourcebutton->setEnabled(false);
    separatorfield->setEnabled(false);
    alignmentfield->setEnabled(false);
    digitfield->setEnabled(false);
    widthlabel->setText(i18n("Width:"));
    heightlabel->setText(i18n("Height:"));
    if (p_form->sizetype()==hk_presentation::relative)
    {
     widthfield->set_displaytype(hk_kdespinbox::percent);
     heightfield->set_displaytype(hk_kdespinbox::percent);
     xfield->set_displaytype(hk_kdespinbox::percent);
     yfield->set_displaytype(hk_kdespinbox::percent);
    }
    else
    {
     widthfield->set_displaytype(hk_kdespinbox::pixels);
     heightfield->set_displaytype(hk_kdespinbox::pixels);
     xfield->set_displaytype(hk_kdespinbox::pixels);
     yfield->set_displaytype(hk_kdespinbox::pixels);
    }
    beforeupdateactionbutton->setEnabled(false);
    afterupdateactionbutton->setEnabled(false);
    beforerowchangeactionbutton->setEnabled(false);
    afterrowchangeactionbutton->setEnabled(false);
    beforedeleteactionbutton->setEnabled(false);
    afterdeleteactionbutton->setEnabled(false);
    beforeinsertactionbutton->setEnabled(false);
    afterinsertactionbutton->setEnabled(false);

    set_visible();
    switch (p_visible->type())
    {
        case hk_visible::grid:            set_dsvisible();
        tab_2->setEnabled(true);
        set_gridvisible();
        break;
        case hk_visible::rowselector: set_dsvisible();
        tab_2->setEnabled(true);
        break;
        case hk_visible::combobox:    listcolumnfield->setEnabled(true);
        viewcolumnfield->setEnabled(true);
        listdatasourcefield->setEnabled(true);
        listdatasourcebutton->setEnabled(true);
	    combomodelabel->setText(i18n("Combomode:"));
            combomodefield->blockSignals(true);
	    combomodefield->clear();
	    combomodefield->insertItem(i18n("Combo"));
            combomodefield->insertItem(i18n("Selector"));
            combomodefield->blockSignals(false);

        combomodefield->setEnabled(true);
        case hk_visible::lineedit:;
        case hk_visible::memo:        alignmentfield->setEnabled(true);
        digitfield->setEnabled(true);
        separatorfield->setEnabled(true);
        case hk_visible::boolean:;
        defaultfield->setEnabled(true);
        columnfield->setEnabled(true);
        set_dsvisible();
        set_dsdatavisible();
        tab_2->setEnabled(true);

        break;

        case  hk_visible::form:
            {combomodefield->setEnabled(true);
	    combomodefield->blockSignals(true);
	    combomodefield->clear();
	    combomodefield->insertItem(i18n("relative"));
	    combomodefield->insertItem(i18n("absolute"));
	    combomodelabel->setText(i18n("Sizetype:"));

	    combomodefield->setCurrentItem((p_form->sizetype()==hk_presentation::relative?0:1));
	    combomodefield->blockSignals(false);

	    combomodefield->blockSignals(false);
            set_dsvisible();
            readonlyfield->setEnabled(false);
            widthlabel->setText(i18n("Form width:"));
            heightlabel->setText(i18n("Form height:"));
            xfield->setEnabled(false);
//fontfield->setEnabled(false);
//fontsizefield->setEnabled(false);
            yfield->setEnabled(false);
	    widthfield->set_displaytype(hk_kdespinbox::pixels);
     	    heightfield->set_displaytype(hk_kdespinbox::pixels);
	    tab_2->setEnabled(true);
            break;
	    }
        case  hk_visible::button:     set_button();
        set_dsvisible();
        tab_2->setEnabled(true);
        //tab_4->setEnabled(true);
	actionfield->setEnabled(true);
        readonlyfield->setEnabled(false);
        break;
        case  hk_visible::textlabel:  tab_2->setEnabled(true);
        datasourcefield->setEnabled(false);
        alignmentfield->setEnabled(true);
        columnfield->setEnabled(false);
        labelfield->setEnabled(true);
        defaultfield->setEnabled(false);
        listdatasourcefield->setEnabled(false);
        listdatasourcebutton->setEnabled(false);
        readonlyfield->setEnabled(false);
	frametab->setEnabled(true);
	set_labelvisible();
        break;
        default:;

    }
}


void hk_kdeproperty::focus_resized(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::focus_resized");
#endif
    set_geometry();
}


void hk_kdeproperty::set_visible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_visible");
#endif
   if (p_visible==NULL)return;
   set_geometry();
     hk_font f=p_visible->font();
    fontsizefield->blockSignals(true);
    fontsizefield->setValue(f.fontsize());
    fontsizefield->blockSignals(false);
    fontfield->blockSignals(true);
    fontfield->setEditText(QString::fromLocal8Bit (f.fontname().c_str()));
    fontfield->blockSignals(false);
    boldfield->blockSignals(true);
    boldfield->setCurrentItem(f.bold()?0:1);
    boldfield->blockSignals(false);
    italicfield->blockSignals(true);
    italicfield->setCurrentItem(f.italic()?0:1);
    italicfield->blockSignals(false);
    labelfield->blockSignals(true);
    labelfield->setText(QString::fromLocal8Bit (p_visible->label().c_str()));
    labelfield->blockSignals(false);
    identifierfield->blockSignals(true);
    identifierfield->setText(QString::fromLocal8Bit (p_visible->identifier().c_str()));
    identifierfield->blockSignals(false);

    p_foregroundcolourbutton->blockSignals(true);
    hk_colour c=p_visible->foregroundcolour();
    QColor qcol(c.red(),c.green(),c.blue());
    p_foregroundcolourbutton->setColor(qcol);
    p_foregroundcolourbutton->blockSignals(false);

    p_backgroundcolourbutton->blockSignals(true);
    c=p_visible->backgroundcolour();
    qcol.setRgb(c.red(),c.green(),c.blue());
    p_backgroundcolourbutton->setColor(qcol);
    p_backgroundcolourbutton->blockSignals(false);

    int a=0;
    switch (p_visible->alignment())
    {
        case hk_visible::alignleft :  a=0;
        break;
        case hk_visible::aligncenter :    a=1;
        break;
        case hk_visible::alignright : a=2;
        break;
        case hk_visible::aligndefault :   a=3;
        break;
        default:;//cerr<<"alignment==default!!!!"<<endl;

    }
    alignmentfield->blockSignals(true);
    alignmentfield->setCurrentItem(a);
    alignmentfield->blockSignals(false);
    onpushactionbutton->setText(p_visible->on_click_action().size()>0?settxt:notsettxt);
    ondoubleclickactionbutton->setText(p_visible->on_doubleclick_action().size()>0?settxt:notsettxt);
    onopenactionbutton->setText(p_visible->on_open_action().size()>0?settxt:notsettxt);
    oncloseactionbutton->setText(p_visible->on_close_action().size()>0?settxt:notsettxt);

}


void hk_kdeproperty::set_geometry(void)
{
   if (p_visible==NULL)return;
    int w=0;
    int h=0;
    if (p_visible->type()==hk_visible::form)
    {
        hk_form* f=dynamic_cast <hk_form*>(p_visible);
        if (f!=NULL)
        {
            w=f->designwidth();
            h=f->designheight();
        }
    }
    else
    {
        w=p_visible->width();
        h=p_visible->height();

    }
    widthfield->blockSignals(true);
    widthfield->setValue(w);
    widthfield->blockSignals(false);
    heightfield->blockSignals(true);
    heightfield->setValue(h);
    heightfield->blockSignals(false);
    xfield->blockSignals(true);
    xfield->setValue(p_visible->x());
    xfield->blockSignals(false);
    yfield->blockSignals(true);
    yfield->setValue(p_visible->y());
    yfield->blockSignals(false);



}



void hk_kdeproperty::set_dsvisible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_dsvisible");
#endif
    if (p_visible==NULL)return;
    set_datasourcelist();
    columnfield->blockSignals(true);
    columnfield->clear();
    columnfield->blockSignals(false);
    datasource_selected();
    listdatasource_selected();
    hk_dsvisible* ds= dynamic_cast <hk_dsvisible*>(p_visible);
    if (!ds)return;
    readonlyfield->blockSignals(true);
    readonlyfield->setCurrentItem(ds->is_readonly()?0:1);
    readonlyfield->blockSignals(false);

    beforeupdateactionbutton->setEnabled(true);
    afterupdateactionbutton->setEnabled(true);
    beforerowchangeactionbutton->setEnabled(true);
    afterrowchangeactionbutton->setEnabled(true);
    beforedeleteactionbutton->setEnabled(true);
    afterdeleteactionbutton->setEnabled(true);
    beforeinsertactionbutton->setEnabled(true);
    afterinsertactionbutton->setEnabled(true);
    beforerowchangeactionbutton->setText(ds->before_row_change_action().size()>0?settxt:notsettxt);
    afterrowchangeactionbutton->setText(ds->after_row_change_action().size()>0?settxt:notsettxt);
    beforeupdateactionbutton->setText(ds->before_update_action().size()>0?settxt:notsettxt);
    afterupdateactionbutton->setText(ds->after_update_action().size()>0?settxt:notsettxt);
    beforedeleteactionbutton->setText(ds->before_delete_action().size()>0?settxt:notsettxt);
    afterdeleteactionbutton->setText(ds->after_delete_action().size()>0?settxt:notsettxt);
    beforeinsertactionbutton->setText(ds->before_insert_action().size()>0?settxt:notsettxt);
    afterinsertactionbutton->setText(ds->after_insert_action().size()>0?settxt:notsettxt);

}


void hk_kdeproperty::set_dsdatavisible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_dsdatavisible");
#endif
    if (p_visible==NULL)return;
    hk_dsdatavisible* ds= dynamic_cast <hk_dsdatavisible*>(p_visible);
    if (ds==NULL) {return;}
    columnfield->blockSignals(true);
    columnfield->setEditText(QString::fromLocal8Bit (ds->columnname().c_str()));
    columnfield->blockSignals(false);
    defaultfield->blockSignals(true);
    defaultfield->setText(QString::fromLocal8Bit (ds->raw_defaultvalue().c_str()));
    defaultfield->blockSignals(false);
    digitfield->blockSignals(true);
    digitfield->setValue(ds->commadigits());
    digitfield->blockSignals(false);
    separatorfield->blockSignals(true);
    separatorfield->setCurrentItem(ds->use_numberseparator()?0:1);
    separatorfield->blockSignals(false);

    hk_dscombobox* combo=dynamic_cast <hk_dscombobox*>(p_visible);
    if (combo==NULL) return;
    listcolumnfield->blockSignals(true);
    listcolumnfield->setEditText(QString::fromLocal8Bit (combo->listcolumnname().c_str()));
    listcolumnfield->blockSignals(false);
    viewcolumnfield->blockSignals(true);
    viewcolumnfield->setEditText(QString::fromLocal8Bit (combo->viewcolumnname().c_str()));
    viewcolumnfield->blockSignals(false);
    combomodefield->blockSignals(true);
    combomodefield->setCurrentItem((combo->mode()==hk_dscombobox::selector)?1:0);
    combomodefield->blockSignals(false);
    if (combo->mode()==hk_dscombobox::selector)
    {
        listdatasourcefield->setEnabled(false);
        listcolumnfield->setEnabled(false);
        columnfield->setEnabled(false);
    }
    else
    {
        listdatasourcefield->setEnabled(true);
        listcolumnfield->setEnabled(true);
        columnfield->setEnabled(true);

    }

}

void hk_kdeproperty::set_labelvisible(void)
{
 hk_kdelabel* label=dynamic_cast<hk_kdelabel*>(p_visible);
   if (!label) return;


    toplinefield->blockSignals(true);
    toplinefield->setValue(label->topline());
    toplinefield->blockSignals(false);

    bottomlinefield->blockSignals(true);
    bottomlinefield->setValue(label->bottomline());
    bottomlinefield->blockSignals(false);

    leftlinefield->blockSignals(true);
    leftlinefield->setValue(label->leftline());
    leftlinefield->blockSignals(false);

    rightlinefield->blockSignals(true);
    rightlinefield->setValue(label->rightline());
    rightlinefield->blockSignals(false);

    diagonallurofield->blockSignals(true);
    diagonallurofield->setValue(label->diagonalluro());
    diagonallurofield->blockSignals(false);

    diagonallorufield->blockSignals(true);
    diagonallorufield->setValue(label->diagonalloru());
    diagonallorufield->blockSignals(false);

}

void hk_kdeproperty::set_gridvisible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_gridvisible");
#endif
    if (p_visible==NULL)return;
}


void hk_kdeproperty::set_button(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_button");
#endif
    if (p_visible==NULL)return;
    hk_button* bt = dynamic_cast <hk_button*>(p_visible);
    if (bt==NULL) return;
    int i = bt->action()+1;
    showmaximizedfield->blockSignals(true);
    showmaximizedfield->setCurrentItem(bt->show_maximized()?1:0);
    showmaximizedfield->blockSignals(false);
    actionfield->setCurrentItem(i);
    set_actionobjectlist();
    vector<hk_string>* liste=NULL;
    conditionbutton->setEnabled(false);

    if (i==4||i==14)  liste=p_form->database()->querylist();
    else
    if (i==5||i==6)
    {
        liste=p_form->database()->reportlist();
        conditionbutton->setEnabled(true);

    }
    else
    if (i==1||i==2)  liste=p_form->database()->formlist();
        else
            liste=p_form->database()->tablelist();
    vector<hk_string>::iterator it =  liste->begin();
    int current=1;
    while (it!=liste->end())
    {

        if ((*it)==bt->object())
        {
            objectfield->setCurrentItem(current);
        }
        it++;  current++;
    }

}


void hk_kdeproperty::set_objectvisible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_objectvisible");
#endif
    if (p_visible==NULL)return;
    p_visible->set_label(labelfield->text().local8Bit().data());
    hk_string ps =  fontfield->currentText().local8Bit().data();
    hk_font f(fontfield->currentText().local8Bit().data(),fontsizefield->value());
    f.set_bold(boldfield->currentItem()==0);
    f.set_italic(italicfield->currentItem()==0);
    geometry_changes();
//hk_string ps;
//if (s!=NULL)
//ps=s;cout <<"font: "<<ps<<endl;
    p_visible->set_font(f);
    int i=alignmentfield->currentItem();
    hk_visible::alignmenttype at=hk_visible::alignleft;
    switch (i)
    {
        case 1 : at=hk_visible::aligncenter;break;
        case 2 : at=hk_visible::alignright;break;
        case 3 : at=hk_visible::aligndefault;break;
        default:;

    }
    p_visible->set_alignment(at);

    QColor qcol=p_foregroundcolourbutton->color();
    hk_colour c(qcol.red(),qcol.green(),qcol.blue());
    p_visible->set_foregroundcolour(c);

    qcol=p_backgroundcolourbutton->color();
    c.set_colour(qcol.red(),qcol.green(),qcol.blue());
    p_visible->set_backgroundcolour(c);

}


void hk_kdeproperty::set_objectdsvisible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_objectdsvisible");
#endif
    if (p_visible==NULL)return;

    list<hk_datasource*>* dslist = p_form->datasources();
    if (dslist==NULL) return;
    list<hk_datasource*>::iterator it=dslist->begin();
    hk_dsvisible* ds = dynamic_cast <hk_dsvisible*>(p_visible);
    hk_dscombobox* combo =dynamic_cast <hk_dscombobox*>(p_visible);
    if (ds==NULL) return;
    ds->set_readonly((readonlyfield->currentItem()==0));

    if (datasourcefield->currentText()=="") ds->set_presentationdatasource(-1);
    if (combo!=NULL&&listdatasourcefield->currentText()=="") combo->set_listpresentationdatasource(-1);
    while (it!=dslist->end())
    {
        QString name= QString::fromLocal8Bit (p_form->unique_datasourcename((*it)->presentationnumber()).c_str());
        if (name==datasourcefield->currentText())
        {
            ds->set_presentationdatasource( (*it)->presentationnumber() );
        }
        if (combo!=NULL)
        {
            if (combomodefield->currentItem()==1)
            {
                listdatasourcefield->setEnabled(false);
                listcolumnfield->setEnabled(false);
                columnfield->setEnabled(false);
            }
            else
            {
                listdatasourcefield->setEnabled(true);
                listcolumnfield->setEnabled(true);
                columnfield->setEnabled(true);

            }
            if (name==listdatasourcefield->currentText())
            {
                if (combo->mode()==hk_dscombobox::selector)
                {                                 // combobox changes from selectormode to combomode
                    combo->set_listpresentationdatasource(-1 );
                    listdatasourcefield->blockSignals(true);
                    listdatasourcefield->setCurrentItem(0);
                    listdatasourcefield->blockSignals(false);

                }
                else
                {
                    combo->set_listpresentationdatasource( (*it)->presentationnumber() );
                }
            }
        }
        it++;
    }
    if (combo)
        {
	combo->set_mode(combomodefield->currentItem()==1?hk_dscombobox::selector:hk_dscombobox::combo);
	}
}


void hk_kdeproperty::set_objectdsdatavisible(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_objectdsdatavisible");
#endif
    if (p_visible==NULL)return;
    hk_dsdatavisible* ds= dynamic_cast <hk_dsdatavisible*>(p_visible);
    ds->set_columnname(columnfield->currentText().local8Bit().data());
    if (defaultfield->text().isEmpty()) ds->reset_default();
    else ds->set_defaultvalue(defaultfield->text().local8Bit().data());

    ds->set_numberformat(separatorfield->currentItem()==0,digitfield->value());

    hk_dscombobox* combo =dynamic_cast <hk_dscombobox*>(p_visible);
    if (combo==NULL) return;
    combo->set_viewcolumnname(viewcolumnfield->currentText().local8Bit().data());
    combo->set_listcolumnname(listcolumnfield->currentText().local8Bit().data());
}


void hk_kdeproperty::set_objectaction(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_objectaction");
#endif
//cerr <<"set_objectaction"<<endl;
    if (p_visible==NULL)return;
    hk_button* bt = dynamic_cast <hk_button*>(p_visible);
    //cerr <<"bt="<<bt<<endl;
    if (bt==NULL) return;
    bt->set_action(
        actionfield->currentItem()-1,
        objectfield->currentText().isEmpty()?"":objectfield->currentText().local8Bit().data(),
        (showmaximizedfield->currentItem()==1?true:false )
        );

    int i = bt->action(); //cerr <<"set_objectaction i="<<endl;
    conditionbutton->setEnabled(i==4||i==5);

}


void hk_kdeproperty::add_formdatasource()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::add_formdatasource");
#endif
    hk_kdeformdatasourcedialog* d = new hk_kdeformdatasourcedialog(p_form,this,0,true);
    hk_datasource* ds=p_form->get_datasource(datasourcefield->currentText().local8Bit().data());
    d->set_datasource(ds);
    if (ds)
    {
        d->alterbutton->setEnabled(true);
        d->deletebutton->setEnabled(true);
    }
    d->exec();
    delete d;
    set_datasourcelist();
}


void hk_kdeproperty::add_listformdatasource()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::add_listformdatasource");
#endif
    hk_kdeformdatasourcedialog* d = new hk_kdeformdatasourcedialog(p_form,this,0,true);
    hk_datasource* ds=p_form->get_datasource(listdatasourcefield->currentText().local8Bit().data());
    d->set_datasource(ds);
    if (ds)
    {
        d->alterbutton->setEnabled(true);
        d->deletebutton->setEnabled(true);
    }
    d->exec();
    delete d;
    set_datasourcelist();
}


void hk_kdeproperty::set_datasourcelist(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::set_datasourcelist");
#endif
    if (p_form==NULL) return;
    datasourcefield->blockSignals(true);
    listdatasourcefield->blockSignals(true);
    datasourcefield->clear();
    datasourcefield->insertItem("");
    listdatasourcefield->clear();
    listdatasourcefield->insertItem("");

    list<hk_datasource*>* dslist = p_form->datasources();
    if (dslist==NULL)
    {
        datasourcefield->blockSignals(false);
        listdatasourcefield->blockSignals(false);
        return;
    }
    list<hk_datasource*>::iterator it=dslist->begin();
    int item=1;
    while (it!=dslist->end())
    {
        QString name= QString::fromLocal8Bit (p_form->unique_datasourcename((*it)->presentationnumber()).c_str());
        datasourcefield->insertItem(name);
        listdatasourcefield->insertItem(name);
        hk_dsvisible* ds = dynamic_cast <hk_dsvisible*>(p_visible);
        hk_dscombobox* dscombo = dynamic_cast <hk_dscombobox*>(p_visible);
        if (ds!=NULL)
        {
            if (ds->datasource()==(*it)) datasourcefield->setCurrentItem(item);
            if (dscombo!=NULL)if (dscombo->listdatasource()==(*it))
                listdatasourcefield->setCurrentItem(item);

        }

        it++; item++;
    }
    datasourcefield->blockSignals(false);
    listdatasourcefield->blockSignals(false);
}


void hk_kdeproperty::datasource_selected(void)
{
#ifdef HK_DEBUG
    hkdebug("datasource_selected");
#endif
    columnfield->blockSignals(true);
    QString currentvalue=columnfield->currentText();
    columnfield->clear();
    columnfield->blockSignals(false);
    if (p_form==NULL) return;
    hk_database* db=p_form->database();
    if (db==NULL) return;
    QString f=datasourcefield->currentText();
    if (f.isEmpty()) f="";
    hk_datasource* ds= p_form->get_datasource(f.local8Bit().data());
    if (ds==NULL) return;
    list<hk_column*>* v=NULL;
    hk_datasource* tmpds=NULL;

    if (ds->type()==hk_datasource::ds_query)
    {
        tmpds=ds->database()->new_resultquery();
        if (tmpds)
        {
            tmpds->set_sql(ds->sql());
            tmpds->set_filter("1=0");
            tmpds->enable();
            v=tmpds->columns();

        }

    }
    else    v=ds->columns();
    if (v==NULL)
    {
        if (tmpds)
        {
            tmpds->disable();
            delete tmpds;
        }
        return;
    }
    columnfield->blockSignals(true);
    viewcolumnfield->blockSignals(true);
    columnfield->insertItem("");
    list<hk_column*>::iterator it=v->begin();
    int i=1;
    while (it!=v->end())
    {
        columnfield->insertItem(QString::fromLocal8Bit ((*it)->name().c_str()));
        if (QString::fromLocal8Bit((*it)->name().c_str())==currentvalue) columnfield->setCurrentItem(i);

        it++;++i;
    }
    columnfield->blockSignals(false);
    viewcolumnfield->blockSignals(false);
    set_viewcolumnvalues();
    if (tmpds)
    {
        tmpds->disable();
        delete tmpds;
    }
}


void hk_kdeproperty::listdatasource_selected(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeproperty::listdatasource_selected");
#endif
    listcolumnfield->blockSignals(true);
    listcolumnfield->clear();
    listcolumnfield->blockSignals(false);
    viewcolumnfield->blockSignals(true);
    viewcolumnfield->clear();
    viewcolumnfield->blockSignals(false);
    if (p_form==NULL) return;
    hk_database* db=p_form->database();
    if (db==NULL) return;
    QString f=listdatasourcefield->currentText();
    if (f.isEmpty()) f="";
    hk_datasource* ds= p_form->get_datasource(f.local8Bit().data());
    if (ds==NULL) return;
    list<hk_column*>* v=NULL;
    hk_datasource* tmpds=NULL;

    if (ds->type()==hk_datasource::ds_query)
    {
        tmpds=ds->database()->new_resultquery();
        if (tmpds)
        {
            tmpds->set_sql(ds->sql());
            tmpds->set_filter("1=0");
            tmpds->enable();
            v=tmpds->columns();

        }

    }
    else    v=ds->columns();
    if (v==NULL)
    {
        if (tmpds)
        {
            tmpds->disable();
            delete tmpds;
        }
        return;
    }
    listcolumnfield->insertItem("");
    viewcolumnfield->insertItem("");
    list<hk_column*>::iterator it=v->begin();
    while (it!=v->end())
    {
        listcolumnfield->insertItem(QString::fromLocal8Bit ((*it)->name().c_str()));
        viewcolumnfield->insertItem(QString::fromLocal8Bit ((*it)->name().c_str()));
        it++;
    }

    if (tmpds)
    {
        tmpds->disable();
        delete tmpds;
    }

}


void hk_kdeproperty::combomode_changed(void)
{
    if (p_visible->type()==hk_visible::form)
    {
	    p_form->set_sizetype(combomodefield->currentItem()==0?hk_presentation::relative:hk_presentation::absolute);
    return;
    }
    set_viewcolumnvalues();
}


void hk_kdeproperty::set_viewcolumnvalues()
{

    viewcolumnfield->blockSignals(true);
    viewcolumnfield->clear();
    viewcolumnfield->insertItem("");
    viewcolumnfield->blockSignals(false);

    QString f;
    if (combomodefield->currentItem()==1&& p_visible&&p_visible->type()==hk_visible::combobox)
        f=datasourcefield->currentText();
    else
        f=listdatasourcefield->currentText();
    if (f.isEmpty()) f="";
    hk_datasource* ds=p_form->get_datasource(f.local8Bit().data());
    if (ds==NULL)
    {
        return;
    }
    list<hk_column*>* v=ds->columns();
    if (!v) return;
    list<hk_column*>::iterator it=v->begin();
    while (it!=v->end())
    {

        viewcolumnfield->insertItem(QString::fromLocal8Bit((*it)->name().c_str()));
        it++;
    }
    viewcolumnfield->blockSignals(false);

}


void hk_kdeproperty::conditionbutton_clicked()
{
    hk_kdereportconditiondialog* d = new hk_kdereportconditiondialog(this,0);
    d->set_values(dynamic_cast <hk_button*>(p_visible),p_form,objectfield->currentText().local8Bit().data());
    d->exec();
    delete d;
}

void hk_kdeproperty::pushactionbutton_clicked(void)
{
pushactionbutton_clicked(0,"");
}

void hk_kdeproperty::pushactionbutton_clicked(int rownumber,const hk_string& warning)
{
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(p_visible->on_click_action(),false);
    d->set_caption(p_visible,"on_click_action");
    int r=d->exec(rownumber,warning);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      p_visible->set_on_click_action(d->code());
    }

   set_visible();
    delete d;


}


void hk_kdeproperty::doubleclickactionbutton_clicked(void)
{
doubleclickactionbutton_clicked(0,"");
}

void hk_kdeproperty::doubleclickactionbutton_clicked(int rownumber,const hk_string& warning)
{
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(p_visible->on_doubleclick_action(),false);
    d->set_caption(p_visible,"on_doubleclick_action");
    int r=d->exec(rownumber,warning);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      p_visible->set_on_doubleclick_action(d->code());
    }

   set_visible();
    delete d;


}


void hk_kdeproperty::openactionbutton_clicked(int rownumber,const hk_string& warningmessage)
{
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(p_visible->on_open_action(),false);
    d->set_caption(p_visible,"on_open_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      p_visible->set_on_open_action(d->code());
    }

   set_visible();
    delete d;


}

void hk_kdeproperty::openactionbutton_clicked(void)
{
openactionbutton_clicked(0,"");
}

void hk_kdeproperty::closeactionbutton_clicked(int rownumber,const hk_string& warningmessage)
{
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(p_visible->on_close_action(),false);
    d->set_caption(p_visible,"on_close_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      p_visible->set_on_close_action(d->code());
    }
   set_visible();

    delete d;


}

void hk_kdeproperty::closeactionbutton_clicked(void)
{
closeactionbutton_clicked(0,"");
}

void hk_kdeproperty::beforedeletebutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->before_delete_action(),false);
    d->set_caption(p_visible,"before_delete_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_before_delete_action(d->code());
    }

   set_dsvisible();

    delete d;


}

void hk_kdeproperty::beforedeletebutton_clicked(void)
{
beforedeletebutton_clicked(0,"");
}

void hk_kdeproperty::afterdeletebutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->after_delete_action(),false);
    d->set_caption(p_visible,"after_delete_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_after_delete_action(d->code());
    }

   set_dsvisible();

    delete d;

}

void hk_kdeproperty::afterdeletebutton_clicked(void)
{
afterdeletebutton_clicked(0,"");
}

void hk_kdeproperty::beforeinsertbutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->before_insert_action(),false);
    d->set_caption(p_visible,"before_insert_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_before_insert_action(d->code());
    }

   set_dsvisible();

    delete d;


}

void hk_kdeproperty::beforeinsertbutton_clicked(void)
{
beforeinsertbutton_clicked(0,"");
}

void hk_kdeproperty::afterinsertbutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->after_insert_action(),false);
    d->set_caption(p_visible,"after_insert_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_after_insert_action(d->code());
    }

   set_dsvisible();

    delete d;

}

void hk_kdeproperty::afterinsertbutton_clicked(void)
{
afterinsertbutton_clicked(0,"");
}

void hk_kdeproperty::beforeupdatebutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->before_update_action(),false);
    d->set_caption(p_visible,"before_update_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_before_update_action(d->code());
    }

   set_dsvisible();

    delete d;

}

void hk_kdeproperty::beforeupdatebutton_clicked(void)
{
beforeupdatebutton_clicked(0,"");
}

void hk_kdeproperty::afterupdatebutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->after_update_action(),false);
    d->set_caption(p_visible,"after_update_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_after_update_action(d->code());
    }
   set_dsvisible();


    delete d;

}

void hk_kdeproperty::afterupdatebutton_clicked(void)
{
afterupdatebutton_clicked(0,"");
}

void hk_kdeproperty::beforerowchangebutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_code(ds->before_row_change_action(),false);
    d->set_caption(p_visible,"before_row_change_action");
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_before_row_change_action(d->code());
    }

   set_dsvisible();

    delete d;

}

void hk_kdeproperty::beforerowchangebutton_clicked(void)
{
beforerowchangebutton_clicked(0,"");
}

void hk_kdeproperty::afterrowchangebutton_clicked(int rownumber,const hk_string& warningmessage)
{
  hk_dsvisible* ds=dynamic_cast<hk_dsvisible*>(p_visible);
  if (!ds) return;
    hk_kdeinterpreterdialog* d = new hk_kdeinterpreterdialog(0,0,Qt::WShowModal);
    d->set_caption(p_visible,"after_row_change_action");
    d->set_code(ds->after_row_change_action(),false);
    int r=d->exec(rownumber,warningmessage);
    if (r==hk_kdeinterpreterdialog::Accepted&&d->has_changed())
    {
      ds->set_after_row_change_action(d->code());
    }

   set_dsvisible();
    delete d;

}

void hk_kdeproperty::afterrowchangebutton_clicked(void)
{
afterrowchangebutton_clicked(0,"");
}


 void hk_kdeproperty::border_changes()
 {
   if (!p_visible) return;
   hk_kdelabel* label=dynamic_cast<hk_kdelabel*>(p_visible);
   if (!label) return;
       label->set_topline(toplinefield->value());
       label->set_bottomline(bottomlinefield->value());
       label->set_leftline(leftlinefield->value());
       label->set_rightline(rightlinefield->value());
       label->set_diagonalloru(diagonallorufield->value());
       label->set_diagonalluro(diagonallurofield->value());


 }

hk_visible* hk_kdeproperty::object(void)
{
return p_visible;
}


