// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.57 $

#include "hk_kdequery.h"
#include "hk_kdequery.moc"
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmultilineedit.h>
#include <klocale.h>
#include <hk_actionquery.h>
#include <hk_connection.h>
#include "hk_kdegrid.h"
#include "hk_kdeqbe.h"
#include <kparts/genericfactory.h>
//#include "hk_kdegridpart.h"
#include <locale.h>

#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kmdichildview.h>

class hk_kdequeryprivate
{
public:
        KRadioAction* p_designaction;
        KRadioAction* p_viewaction;
        KAction*      p_saveaction;
        KAction*      p_saveasaction;
        KAction*      p_closeaction;
        KAction*      p_printaction;
        KToggleAction*      p_qbeaction;
        bool          p_autoclose;
        bool 	      p_nodesignmode;
        hk_kdegrid*   p_grid;
        hk_kdeqbe*      p_qbe;
        KParts::ReadWritePart* p_part;
	KParts::ReadWritePart* p_qbepart;
        Kate::View*   p_designkate;
	Kate::Document* p_katepart;
        bool          highlighting_set;


};



/*
 *  Constructs a hk_kdequery which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */

hk_kdequery::hk_kdequery(QWidget* w,const char* n,WFlags f):KParts::MainWindow(w,n,f),hk_dsquery()
{
    p_private= new hk_kdequeryprivate;
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");

    setXMLFile(locate("data","hk_kdeclasses/hk_kdequery.rc"));

    KLibFactory* p_factory= KLibLoader::self()->factory( "libkatepart" );
    p_private->p_katepart = (Kate::Document *) p_factory->create (0L, "kate", "KTextEditor::Document");
    p_private->p_designkate=(Kate::View *)p_private->p_katepart->createView (this, 0L);
    setName( "hk_kdequery" );
    resize( 596, 480 );
    p_factory= KLibLoader::self()->factory( "libhk_kdegridpart" );
    p_private->p_part=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdegridpart", "KParts::ReadWritePart");
   if (!p_private->p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Grid part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
     p_factory= KLibLoader::self()->factory( "libhk_kdeqbepart" );
    p_private->p_qbepart=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdeqbepart", "KParts::ReadWritePart");
    p_private->p_grid = (hk_kdegrid*)p_private->p_part->widget();
    p_private->p_grid->set_enablingbehaviour(true,true);
//    p_design = new QMultiLineEdit(this);
    p_private->p_qbe = (hk_kdeqbe*)p_private->p_qbepart->widget();
    p_private->p_autoclose =true;
    p_private->p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,this,SLOT(designbutton_clicked()),actionCollection(),"designmode");
    p_private->p_designaction->setEnabled(!runtime_only());
    p_private->p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,this,SLOT(querybutton_clicked()),actionCollection(),"viewmode");
    p_private->p_printaction=new KAction(i18n("&Print"),"fileprint",0,this,SLOT(print()),actionCollection(),"print");
    p_private->p_qbeaction=new KToggleAction(i18n("use &QBE"),"dbdesigner",0,this,SLOT(action_useqbe()),actionCollection(),"useqbemode");
    p_private->p_qbeaction->blockSignals(true);
    p_private->p_qbeaction->setChecked(true);
    p_private->p_qbeaction->blockSignals(false);
    p_private->p_qbeaction->setEnabled(!runtime_only());
    
//p_private->p_printaction->setEnabled(false);
    p_private->p_closeaction=new KAction(i18n("&Close"),loader->loadIcon("exit",KIcon::User),0,this,SLOT(close_query()),actionCollection(),"closequery");
    p_private->p_saveaction=new KAction(i18n("&Save"),"filesave",0,this,SLOT(savebutton_clicked()),actionCollection(),"save");
    p_private->p_saveaction->setEnabled(!runtime_only());
    p_private->p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,this,SLOT(saveasbutton_clicked()),actionCollection(),"saveas");
    p_private->p_saveasaction->setEnabled(!runtime_only());
    p_private->p_designaction->setExclusiveGroup("mode");
    p_private->p_viewaction->setExclusiveGroup("mode");
    set_nodesignmode(runtime_only());
    designbutton_clicked();
    //p_private->p_saveaction->setEnabled(false);
    setCentralWidget(p_private->p_designkate);
    
    createGUI(p_private->p_katepart);
    connect( p_private->p_designkate->getDoc(), SIGNAL( textChanged() ), this, SLOT( query_changed() ) );
    connect (p_private->p_qbe,SIGNAL(signal_qbe_has_changed()),this, SLOT(qbe_has_changed()));
    p_private->p_designkate->setLineNumbersOn(true);
    p_private->highlighting_set=false;
    p_private->p_qbe->hide();
 //   set_use_qbe(true);
    

}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdequery::~hk_kdequery()
{
// no need to delete child widgets, Qt does it all for us
    setCentralWidget(NULL);
    delete p_private->p_katepart;
    hk_datasource* d=p_private->p_grid->datasource();
    if (d!=NULL)
    {
        if (!d->presentation())d->disable();
    }
    delete p_private->p_designaction;
    delete p_private->p_viewaction;
    delete p_private->p_saveaction;
    delete p_private->p_saveasaction;
    delete p_private->p_closeaction;
delete p_private;
}


void hk_kdequery::set_datasource(hk_datasource* d)
{
    hk_dsquery::set_datasource(d);
    p_private->p_grid->set_datasource(d);
    p_private->p_qbe->set_datasource(d);
    hk_database* db=NULL;
    if (d) db=d->database();
    p_private->p_qbe->set_database(db);
    if (d!=NULL)
    {
    p_private->p_designkate->getDoc()->blockSignals(true);
    p_private->p_designkate->getDoc()->setText(QString::fromLocal8Bit(d->sql().c_str()));
    p_private->p_designkate->getDoc()->blockSignals(false);
        //d->enable();
    }
    reset_has_changed();
    //p_private->p_saveaction->setEnabled(false);

}




void hk_kdequery::designbutton_clicked(void)
{
  set_designmode();
}

void hk_kdequery::internal_set_designmode(void)
{
    if (p_private->p_nodesignmode)
    {
        querybutton_clicked();
        return;
    }
    hk_datasource* d=p_private->p_grid->datasource();
    if (d!=NULL) d->disable();
    p_private->p_grid->hide();
    if (use_qbe())
    {
        setCentralWidget(p_private->p_qbe);
	set_block_has_changed(true);
	p_private->p_qbe->show();
    p_private->p_designkate->hide();
	set_block_has_changed(false);
    createGUI(p_private->p_qbepart);
    
    }
    else
    {
    setCentralWidget(p_private->p_designkate);
    p_private->p_designkate->show();
	p_private->p_qbe->hide();
    p_private->p_designkate->setFocus();	
//p_private->p_printaction->setEnabled(false);

    p_private->p_designaction->setChecked(true);
    createGUI(p_private->p_katepart);
    unsigned int i=0;
    Kate::Document *doc = p_private->p_designkate->getDoc();
    if (!p_private->highlighting_set)
    {
        while (i<doc->hlModeCount())
        {
            if (doc->hlModeName(i)=="SQL")
            {
                doc->setHlMode(i);
            }
            ++i;
        }
        p_private->highlighting_set=true;
    }
   } // end else if (use_qbe())
   p_private->p_designaction->setChecked(true);
       p_private->p_qbeaction->blockSignals(true);
    p_private->p_qbeaction->setChecked(use_qbe());
    p_private->p_qbeaction->blockSignals(false);
    set_caption();

}


void hk_kdequery::querybutton_clicked(void)
{
internal_set_viewmode();
}

void hk_kdequery::internal_set_viewmode(void)
{
    hk_datasource* d=p_private->p_grid->datasource();
    bool actionquery=false;
    if (!use_qbe())
    {
    hk_string tst_sql=p_private->p_designkate->getDoc()->text().local8Bit().data();
    hk_string separator=" \t\n";
    hk_string::size_type startpos=hk_string::npos;
    for (unsigned int tt=0;tt<tst_sql.size();tt++)
    {
        tst_sql[tt]=toupper(tst_sql[tt]);
    }
   startpos=tst_sql.find_first_not_of(separator);
   if (startpos==hk_string::npos) 
      {
        set_designmode();
	return;
      }
   hk_string::size_type endpos=tst_sql.find_first_of(separator,startpos+1);
    hk_string value=tst_sql.substr(startpos,endpos-startpos);
    
    actionquery=(value=="ALTER");
    if (!actionquery) actionquery=(value=="DROP");
    if (!actionquery) actionquery=(value=="INSERT");
    if (!actionquery) actionquery=(value=="UPDATE");
    if (!actionquery) actionquery=(value=="CREATE");
    if (!actionquery) actionquery=(value=="GRANT");
    if (!actionquery) actionquery=(value=="REVOKE");
    if (!actionquery) actionquery=(value=="FLUSH");
    }// !use_qbe end
    
    if (d!=NULL)
    {
        if ((!use_qbe()&&!actionquery)||
	((use_qbe()&& p_private->p_qbe &&
	(p_private->p_qbe->querytype()==hk_qbe::qt_select 
	||p_private->p_qbe->querytype()==hk_qbe::qt_groupselect)))
	)
        {   
            if (use_qbe()&& p_private->p_qbe)
	    {  
              p_private->p_qbe->set_columnvalues();
	      if (d->set_query(p_private->p_qbe))
	      {
	        p_private->p_designkate->getDoc()->blockSignals(true);
                p_private->p_designkate->getDoc()->setText(QString::fromLocal8Bit(d->sql().c_str()));
                p_private->p_designkate->getDoc()->blockSignals(false);
	      }
	      else
	      {
	        if (!runtime_only()) 
		{ 
		  set_designmode();
		  return;
		}  
	      }
	    }
	    else
	    {
	     d->set_sql(p_private->p_designkate->getDoc()->text().local8Bit().data(),true);
	    } 
            if ( !d->enable())
            {
                hk_string reason=hk_translate("Query could not be executed")+"\n"+hk_translate("Servermessage: ")+d->database()->connection()->last_servermessage();
                show_warningmessage(reason);
                if (!runtime_only())
                {
                    set_designmode();
                    return;
                }

            }
        }
        else
        {
            hk_actionquery* q=d->database()->new_actionquery();
            if (q!=NULL)
            {
                hk_string sql=p_private->p_designkate->getDoc()->text().local8Bit().data();
	      if (p_private->p_qbe&&use_qbe())
	      {
	      p_private->p_qbe->set_columnvalues();
	       if(p_private->p_qbe->querytype()==hk_qbe::qt_update 
	       ||p_private->p_qbe->querytype()==hk_qbe::qt_delete)
                if (!p_private->p_qbe->create_sql(sql))
		{
	         set_designmode();
		 return;
		}
	        if (!show_yesnodialog(hk_translate(
"Warning: This function is not stable:\nAre you sure that you want to execute the following SQL code?\n\n")+sql,true))
		{
	          set_designmode();
		  return;
	      	}
  	      }  
		q->set_sql(sql,true);
                if (q->execute())
                    show_warningmessage(hk_class::hk_translate("Query was successful"));
                else
                    show_warningmessage(hk_class::hk_translate("Query could not be executed")+"\n"+hk_translate("Servermessage: ")+d->database()->connection()->last_servermessage());
                delete q;
                if (!runtime_only())
                {
                    set_designmode();
                    return;
                }
            }

        }
    }
    setCentralWidget(p_private->p_grid);
    
    set_block_has_changed(true);
    p_private->p_designkate->hide();
    p_private->p_qbe->hide();
    p_private->p_grid->show();
    set_block_has_changed(false);
//p_private->p_printaction->setEnabled(true);

    p_private->p_viewaction->setChecked(true);
    createGUI(p_private->p_part);
    set_caption();
   p_private->p_viewaction->setChecked(true);

}


bool  hk_kdequery::set_mode(enum_mode s)
{
    hk_dsmodevisible::set_mode(s);
    switch (s)
    {
	case hk_dsmodevisible::designmode :
					internal_set_designmode();
					break;
	case hk_dsmodevisible::viewmode :
					internal_set_viewmode();
					break;

    }

return true;
}






void hk_kdequery::before_source_vanishes(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdequery::before_source_vanishes");
#endif
    if (has_changed())
    {
        save_query();
        reset_has_changed();

    }

    if (p_private->p_autoclose)
        close();
    else
    {
        hk_datasource* d=datasource();
        if (d!=NULL)d->disable();
        set_datasource(NULL);
	
    }
    hk_dsquery::before_source_vanishes();
}


void hk_kdequery::query_changed(void)
{
    set_has_changed();
    //p_private->p_saveaction->setEnabled(true);

    if (datasource()!=NULL)  datasource()->set_sql(p_private->p_designkate->getDoc()->text().local8Bit().data(),true);
}


void hk_kdequery::closeEvent ( QCloseEvent* e)
{
    if (has_changed())
    {
        save_query();
        reset_has_changed();

    }
    setCentralWidget(NULL);
    delete p_private->p_katepart;
    p_private->p_katepart=NULL;
    
    
    KParts::MainWindow::closeEvent(e);
   emit signal_closed(this);

}


void hk_kdequery::set_nodesignmode(bool d)
{
    p_private->p_nodesignmode=d;

}


bool hk_kdequery::save_query(const hk_string& n,bool ask)
{

    set_caption();
    if (p_private->p_qbe) p_private->p_qbe->set_columnvalues();
    return hk_dsquery::save_query(n,ask);
}


bool hk_kdequery::load_query(void)
{
   set_block_has_changed(true);

    bool r= hk_dsquery::load_query();
    hk_datasource* d=datasource();
    if (d==NULL)return false;
    p_private->p_designkate->getDoc()->blockSignals(true);
    p_private->p_designkate->getDoc()->setText(QString::fromLocal8Bit(d->sql().c_str()));
    p_private->p_designkate->getDoc()->blockSignals(false);
    p_private->p_grid->set_font(hk_font());
    set_caption();
    reset_has_changed();
    set_block_has_changed(false);
 return r;
}


void hk_kdequery::savebutton_clicked(void)
{
    if (save_query("",false))
    {
        reset_has_changed();
        //p_private->p_saveaction->setEnabled(false);
    }
    set_caption();
}


void hk_kdequery::saveasbutton_clicked(void)
{
    if (!p_private->p_grid->datasource()) return;
    hk_string oldname=p_private->p_grid->datasource()->name();
    p_private->p_grid->datasource()->set_name("");
    if (save_query("",false))
    {
        reset_has_changed();

        set_caption();

    }
    else
    {
        p_private->p_grid->datasource()->set_name(oldname);

    }

}


void hk_kdequery::close_query(void)
{
    close();
}


void hk_kdequery::set_caption(void)
{
    hk_datasource* d=datasource();
    if (d!=NULL)
    {
        QString n=i18n("Query - ");
        n+=QString::fromLocal8Bit(d->name().c_str());
        n+=" (";
        hk_string driver=d->database()->name();
        n+=QString::fromLocal8Bit(driver.c_str());
        n+=")";
        setCaption(QString::fromLocal8Bit(d->database()->connection()->drivername().c_str())+" "+n);
    	KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
        if (v) v->setCaption(n);
 }

}


void hk_kdequery::print(void)
{

    if (in_designmode())
    {
// this is a workaround: otherwise float numbers in the postscript file
// would be created with locale dots (e.g. a comma in Germany) from Qt
        hk_string origlocale=setlocale(LC_NUMERIC,NULL);
        hk_string origmonetarylocale=setlocale(LC_MONETARY,NULL);
        setlocale(LC_NUMERIC,"C");
        setlocale(LC_MONETARY,"C");
        p_private->p_designkate->getDoc()->printDialog();
//workaround part 2
        setlocale(LC_NUMERIC,origlocale.c_str());
        setlocale(LC_MONETARY,origmonetarylocale.c_str());
//workaround part 2 end
    }
    else
        p_private->p_grid->print_grid();
}


void    hk_kdequery::keyPressEvent ( QKeyEvent * e )
{
  if (in_designmode())
  {
      if (e->state()&ControlButton)
    {
        switch (e->key())
        {
            case Key_C :   
	        {           //copy
		p_private->p_designkate->copy();
		} 
                break;
            case Key_V :   //paste
            {
	        p_private->p_designkate->paste();
                break;
            }
            case Key_X :   //cut
            {
	       p_private->p_designkate->cut();

                break;
            }
	    case Key_Z :
	    {
		p_private->p_katepart->undo();
		break;
            }
	    default:;

        }

    } // ende->state()&ControlButton

  }
  KParts::MainWindow::keyPressEvent(e);
}

hk_dsgrid *hk_kdequery::grid(void)
{
return p_private->p_grid;
}



bool hk_kdequery::in_designmode(void) const
{
return mode()==hk_dsmodevisible::designmode;
}


void hk_kdequery::set_autoclose(bool c)
{
p_private->p_autoclose=c;
}


void hk_kdequery::action_useqbe(void)
{
  if (!use_qbe() && !show_yesnodialog(
  			hk_translate("If you change to the QBE window your SQL statement will be lost. Continue?"),true)) 
	{
	    p_private->p_qbeaction->blockSignals(true);
    	    p_private->p_qbeaction->setChecked(use_qbe());
            p_private->p_qbeaction->blockSignals(false);
        return;
	}
   
     set_use_qbe(!use_qbe());
     if (in_designmode()) designbutton_clicked();
    p_private->p_qbeaction->blockSignals(true);
    p_private->p_qbeaction->setChecked(use_qbe());
    p_private->p_qbeaction->blockSignals(false);
     
}


hk_qbe*  hk_kdequery::qbe(void)
{
 return p_private->p_qbe;
}

void hk_kdequery::qbe_has_changed(void)
{  
  set_has_changed();
}


void hk_kdequery::show()
{
  set_block_has_changed(true);
  KParts::MainWindow::show();
  set_block_has_changed(false);
}

void hk_kdequery::showMaximized()
{
  set_block_has_changed(true);
  KParts::MainWindow::showMaximized();
  set_block_has_changed(false);

}

